/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.MirrorManager;
import io.confluent.kafkarest.entities.v3.AlterMirrorsRequest;
import io.confluent.kafkarest.entities.v3.AlterMirrorsResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.kafkarest.utils.AlterMirrorHelper;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v3/clusters/{clusterId}/links/{linkName}/mirrors:pause")
@ResourceAccesslistFeature.ResourceName(value="api.v3.mirrors.*")
public final class PauseMirrorAction {
    private static final Logger log = LoggerFactory.getLogger(PauseMirrorAction.class);
    private final Provider<MirrorManager> mirrorManager;
    private final UrlFactory urlFactory;

    @Inject
    public PauseMirrorAction(Provider<MirrorManager> mirrorManager, UrlFactory urlFactory) {
        this.mirrorManager = Objects.requireNonNull(mirrorManager);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.mirrors.pause")
    @PerformanceMetric(value="v3.mirrors.pause")
    public void pauseMirrors(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="linkName") String linkName, @QueryParam(value="validate_only") boolean validateOnly, @Valid AlterMirrorsRequest request) {
        CompletableFuture<AlterMirrorsResponse> response = AlterMirrorHelper.alterMirrors(this.urlFactory, clusterId, linkName, () -> ((MirrorManager)this.mirrorManager.get()).pauseMirrors(clusterId, linkName, (Set<String>)request.getMirrorTopicNames(), request.getMirrorTopicNamePattern(), validateOnly));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, response);
    }
}

