/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.utils;

import io.confluent.kafkarest.entities.AlterMirrors;
import io.confluent.kafkarest.entities.v3.AlterMirrorsData;
import io.confluent.kafkarest.entities.v3.AlterMirrorsDataList;
import io.confluent.kafkarest.entities.v3.AlterMirrorsResponse;
import io.confluent.kafkarest.entities.v3.MirrorLagData;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.response.UrlFactory;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class AlterMirrorHelper {
    AlterMirrorHelper() {
    }

    public static CompletableFuture<AlterMirrorsResponse> alterMirrors(UrlFactory urlFactory, String clusterId, String linkName, Supplier<CompletableFuture<List<AlterMirrors>>> supplier) {
        String mirrorResourceUrl = urlFactory.create(new String[]{"v3", "clusters", clusterId, "links", linkName, "mirrors"});
        return supplier.get().thenApply(results -> AlterMirrorsResponse.create((AlterMirrorsDataList)((AlterMirrorsDataList.Builder)((AlterMirrorsDataList.Builder)AlterMirrorsDataList.builder().setData(AlterMirrorHelper.fromAlterMirrorsResults(results, mirrorResourceUrl))).setMetadata(ResourceCollection.Metadata.builder().setSelf(mirrorResourceUrl).build())).build()));
    }

    private static List<AlterMirrorsData> fromAlterMirrorsResults(List<AlterMirrors> results, String urlPrefix) {
        return results.stream().map(result -> ((AlterMirrorsData.Builder)AlterMirrorHelper.fromAlterMirrorResult(result).setMetadata(Resource.Metadata.builder().setSelf(urlPrefix + "/" + result.getMirrorTopicName()).build())).build()).collect(Collectors.toList());
    }

    private static AlterMirrorsData.Builder fromAlterMirrorResult(AlterMirrors result) {
        return AlterMirrorsData.builder().setMirrorTopicName(result.getMirrorTopicName()).setErrorMessage(result.getErrorMessage()).setErrorCode(result.getErrorCode()).setMirrorLags(MirrorLagData.fromPartitionLagInfo(result.getPartitionLagList()));
    }
}

