/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.oauth;

import io.confluent.kafka.clients.plugins.auth.oauth.internals.SpireJwtTokenLoginValidator;
import io.confluent.kafka.clients.plugins.auth.oauth.internals.SpireJwtTokenRetriever;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpireJwtLoginCallbackHandler
implements AuthenticateCallbackHandler {
    public static final String SASL_OAUTHBEARER_TOKEN_SPIRE_AGENT_ENDPOINT = "sasl.oauthbearer.token.spire.agent.endpoint";
    private final Logger log = LoggerFactory.getLogger(SpireJwtLoginCallbackHandler.class);
    private boolean isConfigured = false;
    protected AccessTokenRetriever accessTokenRetriever;
    private AccessTokenValidator accessTokenValidator;
    private String logicalCluster;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        JaasOptionsUtils.validateOAuthMechanismAndNonNullJaasConfig((String)saslMechanism, jaasConfigEntries);
        Map<String, ?> moduleOptions = Collections.unmodifiableMap(jaasConfigEntries.get(0).getOptions());
        this.logicalCluster = (String)moduleOptions.get("logicalCluster");
        if (this.logicalCluster == null || this.logicalCluster.isEmpty()) {
            this.log.error("No logical cluster extension was provided in JAAS config!");
            throw new ConfigException("Logical cluster for must be set in the JAAS config.");
        }
        String spireAgentEndpoint = this.validateSpireAgentEndpoint(configs.get(SASL_OAUTHBEARER_TOKEN_SPIRE_AGENT_ENDPOINT));
        this.initAccessTokenRetriever(spireAgentEndpoint);
        this.accessTokenValidator = new SpireJwtTokenLoginValidator();
        this.isConfigured = true;
    }

    protected void initAccessTokenRetriever(String spireAgentEndpoint) {
        this.accessTokenRetriever = new SpireJwtTokenRetriever(spireAgentEndpoint, this.logicalCluster);
    }

    public void close() {
        try {
            this.accessTokenRetriever.close();
        }
        catch (IOException e) {
            this.log.error("Unable to close the SpireJwtTokenRetriever", (Throwable)e);
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        this.checkConfigured();
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerTokenCallback) {
                this.handleSpireTokenCallback((OAuthBearerTokenCallback)callback);
                continue;
            }
            if (callback instanceof SaslExtensionsCallback) {
                this.handleExtensionsCallback((SaslExtensionsCallback)callback);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    private void handleSpireTokenCallback(OAuthBearerTokenCallback callback) throws IOException {
        this.checkConfigured();
        String accessToken = this.accessTokenRetriever.retrieve();
        OAuthBearerToken oAuthBearerToken = this.accessTokenValidator.validate(accessToken);
        callback.token(oAuthBearerToken);
    }

    private void handleExtensionsCallback(SaslExtensionsCallback callback) {
        this.checkConfigured();
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", this.logicalCluster);
        callback.extensions(new SaslExtensions(extensions));
    }

    private String validateSpireAgentEndpoint(Object spireAgentEndpoint) {
        if (spireAgentEndpoint == null || spireAgentEndpoint.toString().isEmpty()) {
            throw new ConfigException(String.format("The OAuth configuration option %s value must be non-null", SASL_OAUTHBEARER_TOKEN_SPIRE_AGENT_ENDPOINT));
        }
        return spireAgentEndpoint.toString();
    }

    private void checkConfigured() {
        if (!this.isConfigured) {
            throw new IllegalStateException(String.format("To use %s, first call the configure", this.getClass().getSimpleName()));
        }
    }
}

