/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common;

import io.confluent.common.EndPoint;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class EndPointTest {
    @Test
    public void testEndPointEquals() {
        EndPoint e0 = new EndPoint("foo", 8080, SecurityProtocol.PLAINTEXT);
        EndPoint e1 = new EndPoint("foo", 8080, SecurityProtocol.SASL_SSL);
        EndPoint e2 = new EndPoint("", 8080, SecurityProtocol.PLAINTEXT);
        EndPoint e3 = new EndPoint("foo", 8080, SecurityProtocol.SASL_SSL);
        this.checkNotEqual(e0, e1);
        this.checkNotEqual(e0, e2);
        this.checkNotEqual(e1, e2);
        this.checkEqual(e1, e3);
        this.checkNotEqual(e0, e3);
    }

    private void checkNotEqual(EndPoint a, EndPoint b) {
        Assertions.assertFalse((boolean)a.equals((Object)b));
        Assertions.assertFalse((boolean)b.equals((Object)a));
    }

    private void checkEqual(EndPoint a, EndPoint b) {
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertEquals((Object)b, (Object)a);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        Assertions.assertEquals((int)b.hashCode(), (int)a.hashCode());
    }

    @Test
    public void testEndPointParsing() {
        this.checkEndPoint(SecurityProtocol.PLAINTEXT, "", 8080, "PLAINTEXT://:8080");
        this.checkEndPoint(SecurityProtocol.SASL_SSL, "2001:0db8:85a3:0000:0000:8a2e:0370:7334", 23, "SASL_SSL://[2001:0db8:85a3:0000:0000:8a2e:0370:7334]:23");
        this.checkEndPoint(SecurityProtocol.SSL, "example.com", 9999, "SSL://example.com:9999");
    }

    private void checkEndPoint(SecurityProtocol securityProtocol, String host, int port, String connectionString) {
        EndPoint ep0 = new EndPoint(host, port, securityProtocol);
        EndPoint ep1 = EndPoint.parse((String)connectionString);
        Assertions.assertEquals((Object)ep0, (Object)ep1);
        Assertions.assertEquals((Object)ep1, (Object)ep0);
        Assertions.assertEquals((int)ep0.hashCode(), (int)ep1.hashCode());
        Assertions.assertEquals((int)ep1.hashCode(), (int)ep0.hashCode());
        Assertions.assertEquals((Object)connectionString, (Object)ep0.toString());
        Assertions.assertEquals((Object)connectionString, (Object)ep1.toString());
    }

    @Test
    public void testEndPointParsingFailsWithoutName() {
        Assertions.assertThrows(RuntimeException.class, () -> EndPoint.parse((String)"febtober"));
    }

    @Test
    public void testEndPointParsingFailsWithoutPort() {
        Assertions.assertThrows(RuntimeException.class, () -> EndPoint.parse((String)"PLAINTEXT://example"));
    }
}

