/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link.integration;

import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.kafka.link.integration.ClusterLinkTestUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.link.ClusterLinkAsyncTaskIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.server.link.ClusterLinkConfig;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

@Tag(value="integration")
public class ClusterLinkPrefixAsyncTaskIntegrationTest
extends ClusterLinkAsyncTaskIntegrationTest {
    Long offsetToCommit = 10L;
    Long syncPeriod = 100L;
    String consumerGroup = "testGroup";

    public ClusterLinkPrefixAsyncTaskIntegrationTest() {
        this.clusterLinkPrefix_$eq("src_");
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testOffsetMigrationTaskStateGoesIntoErrorWhenTheresAnExistingConsumerGroup(String quorum, boolean coordinator) {
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testOffsetMigrationTaskStateManagementVariousScenarios(String quorum, boolean coordinator) {
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testSyncTopicsConfigsTaskState(String quorum, boolean coordinator) {
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testTaskStateForVariousClusterLinkingTasks(String quorum, boolean coordinator) {
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAddPartitionsWithSourceLeaderEpochBump(String quorum, boolean coordinator) {
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkPrefixAddedToConsumerOffsets(String quorum, boolean coordinator) {
        String clusterLinkPrefix = "link1_";
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), (int)this.replicationFactor(), new Properties(), this.sourceCluster().listenerName(), this.sourceCluster().adminClientConfig());
        Properties linkProps = this.destLinkProps((Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()));
        linkProps.setProperty(ClusterLinkConfig.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup));
        linkProps.setProperty(ClusterLinkConfig.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod));
        linkProps.setProperty(ClusterLinkConfig.ClusterLinkPrefixProp(), clusterLinkPrefix);
        linkProps.setProperty(ClusterLinkConfig.ConsumerGroupPrefixEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig.LinkModeProp(), "DESTINATION");
        Assertions.assertFalse((boolean)clusterLinkPrefix.isEmpty());
        this.createClusterLink(this.linkName(), linkProps, this.sourceLinkProps((Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap())), false, true);
        this.destCluster().linkTopic(this.topic(), (short)2, this.linkName(), ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()), clusterLinkPrefix);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit, this.consumerGroup);
        Assertions.assertTrue((boolean)((String)JavaConverters.asJavaCollection((Iterable)this.destCluster().listTopics()).stream().findFirst().get()).startsWith(clusterLinkPrefix));
        Assertions.assertTrue((boolean)((String)JavaConverters.asJavaCollection((Iterable)this.destCluster().listConsumerGroups()).stream().findFirst().get()).startsWith(clusterLinkPrefix));
        this.destCluster().unlinkTopic(clusterLinkPrefix + this.topic(), this.linkName(), true, true, true, this.numPartitions());
        this.destCluster().deleteClusterLink(this.linkName(), false, (Seq)this.destCluster().brokers().toSeq());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkPrefixNotAddedToConsumerOffsets(String quorum, boolean coordinator) {
        String clusterLinkPrefix = "link1_";
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), (int)this.replicationFactor(), new Properties(), this.sourceCluster().listenerName(), this.sourceCluster().adminClientConfig());
        Properties linkProps = this.destLinkProps((Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()));
        linkProps.setProperty(ClusterLinkConfig.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup));
        linkProps.setProperty(ClusterLinkConfig.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod));
        linkProps.setProperty(ClusterLinkConfig.ClusterLinkPrefixProp(), clusterLinkPrefix);
        linkProps.setProperty(ClusterLinkConfig.ConsumerGroupPrefixEnableProp(), "false");
        Assertions.assertFalse((boolean)clusterLinkPrefix.isEmpty());
        this.createClusterLink(this.linkName(), linkProps, this.sourceLinkProps((Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap())), false, true);
        this.destCluster().linkTopic(this.topic(), (short)2, this.linkName(), ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()), clusterLinkPrefix);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit, this.consumerGroup);
        Assertions.assertTrue((boolean)((String)JavaConverters.asJavaCollection((Iterable)this.destCluster().listTopics()).stream().findFirst().get()).startsWith(clusterLinkPrefix));
        Assertions.assertFalse((boolean)((String)JavaConverters.asJavaCollection((Iterable)this.destCluster().listConsumerGroups()).stream().findFirst().get()).startsWith(clusterLinkPrefix));
        this.destCluster().unlinkTopic(clusterLinkPrefix + this.topic(), this.linkName(), true, true, true, this.numPartitions());
        this.destCluster().deleteClusterLink(this.linkName(), false, (Seq)this.destCluster().brokers().toSeq());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testBidirectionalConsumerOffsetSyncingWithSameTopicOnBothSidesOfLinkAndConsumerGroupPrefixDisabled(String quorum, boolean coordinator) throws ExecutionException, InterruptedException {
        String eastTopic = "clicks";
        String eastGroup = "east.group";
        String eastPrefix = "west.";
        String westTopic = "clicks";
        String westGroup = "west.group";
        String westPrefix = "east.";
        this.testBidirectionalConsumerOffsetSyncing(eastTopic, eastGroup, eastPrefix, westTopic, westGroup, westPrefix);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testBidirectionalConsumerOffsetSyncingWithDifferentTopicsOnEachSideOfLinkAndConsumerGroupPrefixDisabled(String quorum, boolean coordinator) throws ExecutionException, InterruptedException {
        String eastTopic = "east.clicks";
        String eastGroup = "east.group";
        String eastPrefix = "west.";
        String westTopic = "west.clicks";
        String westGroup = "west.group";
        String westPrefix = "east.";
        this.testBidirectionalConsumerOffsetSyncing(eastTopic, eastGroup, eastPrefix, westTopic, westGroup, westPrefix);
    }

    private void testBidirectionalConsumerOffsetSyncing(String eastTopic, String eastGroup, String eastPrefix, String westTopic, String westGroup, String westPrefix) throws ExecutionException, InterruptedException {
        int numRecords = 20;
        String eastRecordKeyPrefix = "east-key ";
        ClusterLinkTestHarness eastCluster = this.destCluster();
        KafkaProducer eastProducer = eastCluster.createProducer((Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer(), new Properties());
        String westRecordKeyPrefix = "west-key ";
        ClusterLinkTestHarness westCluster = this.sourceCluster();
        KafkaProducer westProducer = westCluster.createProducer((Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer(), new Properties());
        String westNonMirrorTopic = "west-non-mirror";
        String eastNonMirrorTopic = "east-non-mirror";
        BidirectionalStaticTestState testState = new BidirectionalStaticTestState(eastCluster, westCluster, eastTopic, westTopic, eastNonMirrorTopic, westNonMirrorTopic, eastGroup, westGroup, eastPrefix, westPrefix, eastRecordKeyPrefix, westRecordKeyPrefix, (KafkaProducer<byte[], byte[]>)eastProducer, (KafkaProducer<byte[], byte[]>)westProducer, numRecords);
        this.initializeTopics(testState, (KafkaProducer<byte[], byte[]>)eastProducer, (KafkaProducer<byte[], byte[]>)westProducer, numRecords);
        Properties westProps = this.linkOffsetSyncProps(eastGroup, westPrefix, eastCluster);
        Properties eastProps = this.linkOffsetSyncProps(westGroup, eastPrefix, westCluster);
        this.createClusterLink(this.linkName(), eastProps, Option.apply((Object)westProps), false, true);
        this.linkTopics(testState);
        java.util.Map<TopicPartition, Object> expectedOffsetsOnEast = this.expectedOffsets(westCluster, westTopic, eastPrefix);
        java.util.Map<TopicPartition, Object> expectedOffsetsOnWest = this.expectedOffsets(eastCluster, eastTopic, westPrefix);
        this.waitForMirrors(testState, expectedOffsetsOnEast, expectedOffsetsOnWest);
        this.produceToTopics(testState);
        expectedOffsetsOnEast = this.expectedOffsets(westCluster, westTopic, eastPrefix);
        expectedOffsetsOnWest = this.expectedOffsets(eastCluster, eastTopic, westPrefix);
        this.waitForMirrors(testState, expectedOffsetsOnEast, expectedOffsetsOnWest);
        Long offset = this.commitOffsets(testState);
        this.verifyMirrorAndNonMirrorOffsetMigration(offset, testState);
        this.unlinkMirrors(testState);
        this.verifyConsumption(testState);
        this.deleteLinks(testState);
    }

    private void waitForMirrors(BidirectionalStaticTestState testState, java.util.Map<TopicPartition, Object> expectedOffsetsOnEast, java.util.Map<TopicPartition, Object> expectedOffsetsOnWest) {
        List<TopicPartition> westMirrorPartitions = this.topicPartitionList(testState.westTopic, testState.eastPrefix);
        List<TopicPartition> eastMirrorPartitions = this.topicPartitionList(testState.eastTopic, testState.westPrefix);
        this.waitForMirrorPartitions((Seq)ClusterLinkTestUtils.convertListToScalaSeq(westMirrorPartitions), (Map)ClusterLinkTestUtils.convertMapToScalaMap(expectedOffsetsOnEast), (Seq)testState.eastCluster.brokers(), 15000L, testState.eastPrefix);
        this.waitForMirrorPartitions((Seq)ClusterLinkTestUtils.convertListToScalaSeq(eastMirrorPartitions), (Map)ClusterLinkTestUtils.convertMapToScalaMap(expectedOffsetsOnWest), (Seq)testState.westCluster.brokers(), 15000L, testState.westPrefix);
    }

    private void linkTopics(BidirectionalStaticTestState testState) throws ExecutionException, InterruptedException {
        testState.eastCluster.linkTopic(testState.westTopic, this.replicationFactor(), this.linkName(), (Map)new scala.collection.mutable.HashMap(), testState.eastPrefix).all().get();
        testState.westCluster.linkTopic(testState.eastTopic, this.replicationFactor(), this.linkName(), (Map)new scala.collection.mutable.HashMap(), testState.westPrefix).all().get();
    }

    private void produceToTopics(BidirectionalStaticTestState testState) {
        this.produceRecords(testState.westProducer, testState.westTopic, testState.numRecords, i -> testState.westRecordKeyPrefix + i, Option.empty(), Option.empty());
        this.produceRecords(testState.eastProducer, testState.eastTopic, testState.numRecords, i -> testState.eastRecordKeyPrefix + i, Option.empty(), Option.empty());
    }

    private Long commitOffsets(BidirectionalStaticTestState testState) {
        Long offset = testState.eastCluster.leaderLog(new TopicPartition(testState.eastTopic, 0)).logEndOffset();
        this.commitOffsets(testState.eastCluster, testState.eastTopic, 0, offset, testState.eastGroup);
        this.commitOffsets(testState.eastCluster, testState.eastPrefix + testState.westTopic, 0, offset, testState.eastGroup);
        this.commitOffsets(testState.eastCluster, testState.eastNonMirrorTopic, 0, offset, testState.eastGroup);
        this.commitOffsets(testState.westCluster, testState.westTopic, 0, offset, testState.westGroup);
        this.commitOffsets(testState.westCluster, testState.westPrefix + testState.eastTopic, 0, offset, testState.westGroup);
        this.commitOffsets(testState.westCluster, testState.westNonMirrorTopic, 0, offset, testState.westGroup);
        return offset;
    }

    private void verifyConsumption(BidirectionalStaticTestState testState) {
        List<TopicPartition> westPartitions = this.topicPartitionList(testState.westTopic, "");
        List<TopicPartition> eastPartitions = this.topicPartitionList(testState.eastTopic, "");
        List<TopicPartition> westMirrorPartitions = this.topicPartitionList(testState.westTopic, testState.eastPrefix);
        List<TopicPartition> eastMirrorPartitions = this.topicPartitionList(testState.eastTopic, testState.westPrefix);
        this.verifyConsumption(testState.eastCluster, westMirrorPartitions, westPartitions, testState.eastPrefix, "west-");
        this.verifyConsumption(testState.westCluster, eastMirrorPartitions, eastPartitions, testState.westPrefix, "east-");
    }

    private void unlinkMirrors(BidirectionalStaticTestState testState) {
        testState.eastCluster.unlinkTopic(testState.eastPrefix + testState.westTopic, this.linkName(), true, true, true, this.numPartitions());
        testState.westCluster.unlinkTopic(testState.westPrefix + testState.eastTopic, this.linkName(), true, true, true, this.numPartitions());
    }

    private void deleteLinks(BidirectionalStaticTestState testState) {
        testState.eastCluster.deleteClusterLink(this.linkName(), false, (Seq)testState.eastCluster.aliveBrokers().toSeq());
        testState.westCluster.deleteClusterLink(this.linkName(), false, (Seq)testState.westCluster.aliveBrokers().toSeq());
    }

    private List<TopicPartition> topicPartitionList(String topic, String prefix) {
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        for (int i = 0; i < this.numPartitions(); ++i) {
            partitions.add(new TopicPartition(prefix + topic, i));
        }
        return partitions;
    }

    private void initializeTopics(BidirectionalStaticTestState testState, KafkaProducer<byte[], byte[]> eastProducer, KafkaProducer<byte[], byte[]> westProducer, int numRecords) {
        testState.westCluster.createTopic(testState.westTopic, this.numPartitions(), (int)this.replicationFactor(), new Properties(), testState.westCluster.listenerName(), testState.westCluster.adminClientConfig());
        testState.eastCluster.createTopic(testState.eastTopic, this.numPartitions(), (int)this.replicationFactor(), new Properties(), testState.eastCluster.listenerName(), testState.eastCluster.adminClientConfig());
        this.produceRecords(westProducer, testState.westTopic, numRecords, i -> testState.westRecordKeyPrefix + i, Option.empty(), Option.empty());
        this.produceRecords(eastProducer, testState.eastTopic, numRecords, i -> testState.eastRecordKeyPrefix + i, Option.empty(), Option.empty());
        testState.westCluster.createTopic(testState.westNonMirrorTopic, this.numPartitions(), (int)this.replicationFactor(), new Properties(), testState.westCluster.listenerName(), testState.westCluster.adminClientConfig());
        testState.eastCluster.createTopic(testState.eastNonMirrorTopic, this.numPartitions(), (int)this.replicationFactor(), new Properties(), testState.eastCluster.listenerName(), testState.eastCluster.adminClientConfig());
        this.produceRecords(westProducer, testState.westNonMirrorTopic, numRecords, i -> testState.westRecordKeyPrefix + i, Option.empty(), Option.empty());
        this.produceRecords(eastProducer, testState.eastNonMirrorTopic, numRecords, i -> testState.eastRecordKeyPrefix + i, Option.empty(), Option.empty());
    }

    private java.util.Map<TopicPartition, Object> expectedOffsets(ClusterLinkTestHarness cluster, String topic, String prefix) {
        HashMap<TopicPartition, Object> expectedOffsets = new HashMap<TopicPartition, Object>();
        for (int i = 0; i < this.numPartitions(); ++i) {
            Long leo = cluster.leaderLog(new TopicPartition(topic, i)).logEndOffset();
            expectedOffsets.put(new TopicPartition(prefix + topic, i), leo);
        }
        return expectedOffsets;
    }

    private Properties linkOffsetSyncProps(String consumerGroup, String prefix, ClusterLinkTestHarness cluster) {
        HashMap<String, String> overrides = new HashMap<String, String>();
        overrides.put(ClusterLinkConfig.ConsumerOffsetSyncEnableProp(), "true");
        overrides.put(ClusterLinkConfig.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(consumerGroup));
        overrides.put(ClusterLinkConfig.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod));
        overrides.put(ClusterLinkConfig.ClusterLinkPrefixProp(), prefix);
        overrides.put("sasl.jaas.config", this.createLinkCredentials(this.linkName(), cluster, Option.empty()));
        overrides.put("bootstrap.servers", cluster.bootstrapServers(cluster.listenerName()));
        Properties props = this.bidirectionalProps(overrides);
        props.putAll((java.util.Map<?, ?>)cluster.clientSecurityProps(this.linkName()));
        return props;
    }

    private void verifyMirrorAndNonMirrorOffsetMigration(long offset, BidirectionalStaticTestState testState) {
        String westGroupNameOnEast = testState.westGroup;
        this.verifyOffsetMigration(testState.eastPrefix + testState.westTopic, 0, offset, westGroupNameOnEast, testState.eastCluster);
        this.verifyOffsetMigration(testState.eastTopic, 0, offset, westGroupNameOnEast, testState.eastCluster);
        this.verifyOffsetMigration(testState.westNonMirrorTopic, 0, offset, testState.westGroup, testState.westCluster);
        Assertions.assertNotEquals((long)offset, (long)testState.eastCluster.getOffset(testState.eastPrefix + testState.westNonMirrorTopic, 0, westGroupNameOnEast));
        String eastGroupNameOnWest = testState.eastGroup;
        this.verifyOffsetMigration(testState.westPrefix + testState.eastTopic, 0, offset, eastGroupNameOnWest, testState.westCluster);
        this.verifyOffsetMigration(testState.westTopic, 0, offset, eastGroupNameOnWest, testState.westCluster);
        this.verifyOffsetMigration(testState.eastNonMirrorTopic, 0, offset, testState.eastGroup, testState.eastCluster);
        Assertions.assertNotEquals((long)offset, (long)testState.westCluster.getOffset(testState.westPrefix + testState.eastNonMirrorTopic, 0, eastGroupNameOnWest));
    }

    private Properties bidirectionalProps(java.util.Map<String, String> overrides) {
        Properties props = new Properties();
        props.setProperty(ClusterLinkConfig.LinkModeProp(), ClusterLinkConfig.LinkMode.BIDIRECTIONAL.name());
        props.setProperty(ClusterLinkConfig.ConnectionModeProp(), "OUTBOUND");
        props.put("metadata.max.age.ms", "2000");
        props.put("reconnect.backoff.max.ms", "1000");
        props.putAll(overrides);
        return props;
    }

    private void verifyConsumption(ClusterLinkTestHarness cluster, List<TopicPartition> mirrorPartitions, List<TopicPartition> partitions, String prefix, String keyPrefix) {
        Consumer consumer = cluster.createConsumer((Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer(), new Properties(), ClusterLinkTestUtils.convertListToScalaSeq(new ArrayList()).toList());
        consumer.assign(mirrorPartitions);
        this.consumePartitionRecords(consumer, ClusterLinkTestUtils.convertSetToScalaSet(new HashSet<TopicPartition>(partitions)), prefix, partitions.get(0).topic(), keyPrefix);
        consumer.close();
    }

    private static class BidirectionalStaticTestState {
        ClusterLinkTestHarness eastCluster;
        ClusterLinkTestHarness westCluster;
        String eastTopic;
        String westTopic;
        String eastNonMirrorTopic;
        String westNonMirrorTopic;
        String eastGroup;
        String westGroup;
        String eastPrefix;
        String westPrefix;
        String eastRecordKeyPrefix;
        String westRecordKeyPrefix;
        KafkaProducer<byte[], byte[]> eastProducer;
        KafkaProducer<byte[], byte[]> westProducer;
        int numRecords;

        public BidirectionalStaticTestState(ClusterLinkTestHarness eastCluster, ClusterLinkTestHarness westCluster, String eastTopic, String westTopic, String eastNonMirrorTopic, String westNonMirrorTopic, String eastGroup, String westGroup, String eastPrefix, String westPrefix, String eastRecordKeyPrefix, String westRecordKeyPrefix, KafkaProducer<byte[], byte[]> eastProducer, KafkaProducer<byte[], byte[]> westProducer, int numRecords) {
            this.eastCluster = eastCluster;
            this.westCluster = westCluster;
            this.eastTopic = eastTopic;
            this.westTopic = westTopic;
            this.eastNonMirrorTopic = eastNonMirrorTopic;
            this.westNonMirrorTopic = westNonMirrorTopic;
            this.eastGroup = eastGroup;
            this.westGroup = westGroup;
            this.eastPrefix = eastPrefix;
            this.westPrefix = westPrefix;
            this.eastRecordKeyPrefix = eastRecordKeyPrefix;
            this.westRecordKeyPrefix = westRecordKeyPrefix;
            this.eastProducer = eastProducer;
            this.westProducer = westProducer;
            this.numRecords = numRecords;
        }
    }
}

