/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.cluster;

public class UserMetadata {
    private final int userId;
    private final String userResourceId;
    private final String apiKey;
    private final String apiSecret;
    private final boolean isSuperUser;
    private final boolean serviceAccount;

    public UserMetadata(int userId, String apiKey, String apiSecret, boolean isSuperUser) {
        this(userId, apiKey, apiSecret, isSuperUser, !isSuperUser);
    }

    public UserMetadata(int userId, String apiKey, String apiSecret, boolean isSuperUser, boolean serviceAccount) {
        this.userId = userId;
        this.userResourceId = "u-" + userId;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.isSuperUser = isSuperUser;
        this.serviceAccount = serviceAccount;
    }

    public int userId() {
        return this.userId;
    }

    public String userResourceId() {
        return this.userResourceId;
    }

    public String apiKey() {
        return this.apiKey;
    }

    public String apiSecret() {
        return this.apiSecret;
    }

    public boolean isSuperUser() {
        return this.isSuperUser;
    }

    public boolean isServiceAccount() {
        return this.serviceAccount;
    }

    public String toString() {
        String type = this.isSuperUser ? "SuperUser" : "Service";
        return String.format("%s:id=%d,apiKey=%s", type, this.userId, this.apiKey);
    }
}

