/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.oauth.mockserver.common;

import io.confluent.security.auth.oauth.mockserver.common.Config;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtil.class);

    public static int getConnectTimeout(Config config) {
        return ConfigUtil.getTimeoutAppendingWarnings(config, "oauth.connect.timeout.seconds", null);
    }

    public static int getReadTimeout(Config config) {
        return ConfigUtil.getTimeoutAppendingWarnings(config, "oauth.read.timeout.seconds", null);
    }

    public static int getTimeoutAppendingWarnings(Config c, String key, List<String> warnings) {
        int timeout = c.getValueAsInt(key, 60);
        if (timeout <= 0) {
            String msg = "The configured value of `" + key + "` (" + timeout + ") is <= 0 and will be ignored. Default used: 60 seconds";
            if (warnings != null) {
                warnings.add(msg);
            } else {
                log.warn(msg);
            }
            timeout = 60;
        }
        return timeout;
    }
}

