/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.avro.random.generator;

import com.mifmif.common.regex.Generex;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;

public class Generator {
    private final Map<Schema, Generex> generexCache = new HashMap<Schema, Generex>();
    private final Map<Schema, List<Object>> optionsCache = new HashMap<Schema, List<Object>>();
    private final Map<Schema, Iterator<Object>> iteratorCache = new IdentityHashMap<Schema, Iterator<Object>>();
    public static final String ARG_PROPERTIES_PROP = "arg.properties";
    public static final String LENGTH_PROP = "length";
    public static final String LENGTH_PROP_MIN = "min";
    public static final String LENGTH_PROP_MAX = "max";
    public static final String REGEX_PROP = "regex";
    public static final String PREFIX_PROP = "prefix";
    public static final String SUFFIX_PROP = "suffix";
    public static final String OPTIONS_PROP = "options";
    public static final String OPTIONS_PROP_FILE = "file";
    public static final String OPTIONS_PROP_ENCODING = "encoding";
    public static final String KEYS_PROP = "keys";
    public static final String RANGE_PROP = "range";
    public static final String RANGE_PROP_MIN = "min";
    public static final String RANGE_PROP_MAX = "max";
    public static final String ODDS_PROP = "odds";
    public static final String ITERATION_PROP = "iteration";
    public static final String ITERATION_PROP_START = "start";
    public static final String ITERATION_PROP_RESTART = "restart";
    public static final String ITERATION_PROP_STEP = "step";
    private final Schema topLevelSchema;
    private final Random random;

    public Generator(Schema topLevelSchema, Random random) {
        this.topLevelSchema = topLevelSchema;
        this.random = random;
    }

    public Generator(String schemaString, Random random) {
        this(new Schema.Parser().parse(schemaString), random);
    }

    public Generator(InputStream schemaStream, Random random) throws IOException {
        this(new Schema.Parser().parse(schemaStream), random);
    }

    public Generator(File schemaFile, Random random) throws IOException {
        this(new Schema.Parser().parse(schemaFile), random);
    }

    public Schema schema() {
        return this.topLevelSchema;
    }

    public Object generate() {
        return this.generateObject(this.topLevelSchema);
    }

    private Object generateObject(Schema schema) {
        Map propertiesProp = this.getProperties(schema).orElse(Collections.emptyMap());
        if (propertiesProp.containsKey(OPTIONS_PROP)) {
            return this.generateOption(schema, propertiesProp);
        }
        if (propertiesProp.containsKey(ITERATION_PROP)) {
            return this.generateIteration(schema, propertiesProp);
        }
        switch (schema.getType()) {
            case ARRAY: {
                return this.generateArray(schema, propertiesProp);
            }
            case BOOLEAN: {
                return this.generateBoolean(propertiesProp);
            }
            case BYTES: {
                return this.generateBytes(propertiesProp);
            }
            case DOUBLE: {
                return this.generateDouble(propertiesProp);
            }
            case ENUM: {
                return this.generateEnumSymbol(schema);
            }
            case FIXED: {
                return this.generateFixed(schema);
            }
            case FLOAT: {
                return this.generateFloat(propertiesProp);
            }
            case INT: {
                return this.generateInt(propertiesProp);
            }
            case LONG: {
                return this.generateLong(propertiesProp);
            }
            case MAP: {
                return this.generateMap(schema, propertiesProp);
            }
            case NULL: {
                return this.generateNull();
            }
            case RECORD: {
                return this.generateRecord(schema);
            }
            case STRING: {
                return this.generateString(schema, propertiesProp);
            }
            case UNION: {
                return this.generateUnion(schema);
            }
        }
        throw new RuntimeException("Unrecognized schema type: " + schema.getType());
    }

    private Optional<Map> getProperties(Schema schema) {
        Object propertiesProp = schema.getObjectProp(ARG_PROPERTIES_PROP);
        if (propertiesProp == null) {
            return Optional.empty();
        }
        if (propertiesProp instanceof Map) {
            return Optional.of((Map)propertiesProp);
        }
        throw new RuntimeException(String.format("%s property must be given as object, was %s instead", ARG_PROPERTIES_PROP, propertiesProp.getClass().getName()));
    }

    private void enforceMutualExclusion(Map propertiesProp, String includedProp, String ... excludedProps) {
        for (String excludedProp : excludedProps) {
            if (!propertiesProp.containsKey(excludedProp)) continue;
            throw new RuntimeException(String.format("Cannot specify %s prop when %s prop is given", excludedProp, includedProp));
        }
    }

    private Object wrapOption(Schema schema, Object option) {
        if (schema.getType() == Schema.Type.BYTES && option instanceof String) {
            option = ByteBuffer.wrap(((String)option).getBytes(Charset.defaultCharset()));
        } else if (schema.getType() == Schema.Type.FLOAT && option instanceof Double) {
            option = Float.valueOf(((Double)option).floatValue());
        } else if (schema.getType() == Schema.Type.LONG && option instanceof Integer) {
            option = ((Integer)option).longValue();
        } else if (schema.getType() == Schema.Type.ARRAY && option instanceof Collection) {
            option = new GenericData.Array(schema, (Collection)option);
        } else if (schema.getType() == Schema.Type.ENUM && option instanceof String) {
            option = new GenericData.EnumSymbol(schema, (String)option);
        } else if (schema.getType() == Schema.Type.FIXED && option instanceof String) {
            option = new GenericData.Fixed(schema, ((String)option).getBytes(Charset.defaultCharset()));
        } else if (schema.getType() == Schema.Type.RECORD && option instanceof Map) {
            Map optionMap = (Map)option;
            GenericRecordBuilder optionBuilder = new GenericRecordBuilder(schema);
            for (Schema.Field field : schema.getFields()) {
                if (!optionMap.containsKey(field.name())) continue;
                optionBuilder.set(field, optionMap.get(field.name()));
            }
            option = optionBuilder.build();
        }
        return option;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Object> parseOptions(Schema schema, Map propertiesProp) {
        Collection optionsList;
        this.enforceMutualExclusion(propertiesProp, OPTIONS_PROP, LENGTH_PROP, REGEX_PROP, ITERATION_PROP, RANGE_PROP);
        Object optionsProp = propertiesProp.get(OPTIONS_PROP);
        if (optionsProp instanceof Collection) {
            optionsList = (Collection)optionsProp;
            if (optionsList.isEmpty()) {
                throw new RuntimeException(String.format("%s property cannot be empty", OPTIONS_PROP));
            }
        } else {
            if (!(optionsProp instanceof Map)) {
                throw new RuntimeException(String.format("%s prop must be an array or an object, was %s instead", OPTIONS_PROP, optionsProp.getClass().getName()));
            }
            Map optionsProps = (Map)optionsProp;
            Object optionsFile = optionsProps.get(OPTIONS_PROP_FILE);
            if (optionsFile == null) {
                throw new RuntimeException(String.format("%s property must contain '%s' field when given as object", OPTIONS_PROP, OPTIONS_PROP_FILE));
            }
            if (!(optionsFile instanceof String)) {
                throw new RuntimeException(String.format("'%s' field of %s property must be given as string, was %s instead", OPTIONS_PROP_FILE, OPTIONS_PROP, optionsFile.getClass().getName()));
            }
            Object optionsEncoding = optionsProps.get(OPTIONS_PROP_ENCODING);
            if (optionsEncoding == null) {
                throw new RuntimeException(String.format("%s property must contain '%s' field when given as object", OPTIONS_PROP, OPTIONS_PROP_FILE));
            }
            if (!(optionsEncoding instanceof String)) {
                throw new RuntimeException(String.format("'%s' field of %s property must be given as string, was %s instead", OPTIONS_PROP_ENCODING, OPTIONS_PROP, optionsEncoding.getClass().getName()));
            }
            try (FileInputStream optionsStream = new FileInputStream((String)optionsFile);){
                BinaryDecoder decoder;
                GenericDatumReader optionReader = new GenericDatumReader(schema);
                if ("binary".equals(optionsEncoding)) {
                    decoder = DecoderFactory.get().binaryDecoder((InputStream)optionsStream, null);
                } else {
                    if (!"json".equals(optionsEncoding)) {
                        throw new RuntimeException(String.format("'%s' field of %s property only supports two formats: 'binary' and 'json'", OPTIONS_PROP_ENCODING, OPTIONS_PROP));
                    }
                    decoder = DecoderFactory.get().jsonDecoder(schema, (InputStream)optionsStream);
                }
                ArrayList<Object> options = new ArrayList<Object>();
                Object option = optionReader.read(null, (Decoder)decoder);
                while (option != null) {
                    option = this.wrapOption(schema, option);
                    if (!GenericData.get().validate(schema, option)) {
                        throw new RuntimeException(String.format("Invalid option for %s schema: type %s, value '%s'", schema.getType().getName(), option.getClass().getName(), option));
                    }
                    options.add(option);
                    try {
                        option = optionReader.read(null, (Decoder)decoder);
                    }
                    catch (EOFException eofe) {
                        // empty catch block
                        break;
                    }
                }
                ArrayList<Object> arrayList = options;
                return arrayList;
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException(String.format("Unable to locate options file '%s'", optionsFile), fnfe);
            }
            catch (IOException ioe) {
                throw new RuntimeException(String.format("Unable to read options file '%s'", optionsFile), ioe);
            }
        }
        ArrayList<Object> options = new ArrayList<Object>();
        Iterator iterator = optionsList.iterator();
        while (iterator.hasNext()) {
            Object option = iterator.next();
            option = this.wrapOption(schema, option);
            if (!GenericData.get().validate(schema, option)) {
                throw new RuntimeException(String.format("Invalid option for %s schema: type %s, value '%s'", schema.getType().getName(), option.getClass().getName(), option));
            }
            options.add(option);
        }
        return options;
    }

    private <T> T generateOption(Schema schema, Map propertiesProp) {
        if (!this.optionsCache.containsKey(schema)) {
            this.optionsCache.put(schema, this.parseOptions(schema, propertiesProp));
        }
        List<Object> options = this.optionsCache.get(schema);
        return (T)options.get(this.random.nextInt(options.size()));
    }

    private Iterator<Object> getBooleanIterator(Map iterationProps) {
        Object startProp = iterationProps.get(ITERATION_PROP_START);
        if (startProp == null) {
            throw new RuntimeException(String.format("%s property must contain %s field", ITERATION_PROP, ITERATION_PROP_START));
        }
        if (!(startProp instanceof Boolean)) {
            throw new RuntimeException(String.format("%s field of %s property for a boolean schema must be a boolean, was %s instead", ITERATION_PROP_START, ITERATION_PROP, startProp.getClass().getName()));
        }
        if (iterationProps.containsKey(ITERATION_PROP_RESTART)) {
            throw new RuntimeException(String.format("%s property cannot contain %s field for a boolean schema", ITERATION_PROP, ITERATION_PROP_RESTART));
        }
        if (iterationProps.containsKey(ITERATION_PROP_STEP)) {
            throw new RuntimeException(String.format("%s property cannot contain %s field for a boolean schema", ITERATION_PROP, ITERATION_PROP_STEP));
        }
        return new BooleanIterator((Boolean)startProp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Iterator<Object> getIntegralIterator(Long iterationStartField, Long iterationRestartField, Long iterationStepField, IntegralIterator.Type type) {
        long iterationStep;
        long iterationRestart;
        long restartLowDefault;
        long restartHighDefault;
        if (iterationStartField == null) {
            throw new RuntimeException(String.format("%s property must contain %s field", ITERATION_PROP, ITERATION_PROP_START));
        }
        long iterationStart = iterationStartField;
        switch (type) {
            case INTEGER: {
                restartHighDefault = Integer.MAX_VALUE;
                restartLowDefault = Integer.MIN_VALUE;
                break;
            }
            case LONG: {
                restartHighDefault = Long.MAX_VALUE;
                restartLowDefault = Long.MIN_VALUE;
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unexpected IntegralIterator type: %s", new Object[]{type}));
            }
        }
        if (iterationRestartField == null && iterationStepField == null) {
            iterationRestart = restartHighDefault;
            iterationStep = 1L;
            return new IntegralIterator(iterationStart, iterationRestart, iterationStep, type);
        } else if (iterationRestartField == null) {
            iterationStep = iterationStepField;
            if (iterationStep > 0L) {
                iterationRestart = restartHighDefault;
                return new IntegralIterator(iterationStart, iterationRestart, iterationStep, type);
            } else {
                if (iterationStep >= 0L) throw new RuntimeException(String.format("%s field of %s property cannot be zero", ITERATION_PROP_STEP, ITERATION_PROP));
                iterationRestart = -1L * restartLowDefault;
            }
            return new IntegralIterator(iterationStart, iterationRestart, iterationStep, type);
        } else if (iterationStepField == null) {
            iterationRestart = iterationRestartField;
            if (iterationRestart > iterationStart) {
                iterationStep = 1L;
                return new IntegralIterator(iterationStart, iterationRestart, iterationStep, type);
            } else {
                if (iterationRestart >= iterationStart) throw new RuntimeException(String.format("%s and %s fields of %s property cannot be equal", ITERATION_PROP_START, ITERATION_PROP_RESTART, ITERATION_PROP));
                iterationStep = -1L;
            }
            return new IntegralIterator(iterationStart, iterationRestart, iterationStep, type);
        } else {
            iterationRestart = iterationRestartField;
            iterationStep = iterationStepField;
            if (iterationStep == 0L) {
                throw new RuntimeException(String.format("%s field of %s property cannot be zero", ITERATION_PROP_STEP, ITERATION_PROP));
            }
            if (iterationStart == iterationRestart) {
                throw new RuntimeException(String.format("%s and %s fields of %s property cannot be equal", ITERATION_PROP_START, ITERATION_PROP_RESTART, ITERATION_PROP));
            }
            if (iterationRestart > iterationStart && iterationStep < 0L) {
                throw new RuntimeException(String.format("%s field of %s property must be positive when %s field is greater than %s field", ITERATION_PROP_STEP, ITERATION_PROP, ITERATION_PROP_RESTART, ITERATION_PROP_START));
            }
            if (iterationRestart >= iterationStart || iterationStep <= 0L) return new IntegralIterator(iterationStart, iterationRestart, iterationStep, type);
            throw new RuntimeException(String.format("%s field of %s property must be negative when %s field is less than %s field", ITERATION_PROP_STEP, ITERATION_PROP, ITERATION_PROP_RESTART, ITERATION_PROP_START));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Iterator<Object> getDecimalIterator(Double iterationStartField, Double iterationRestartField, Double iterationStepField, DecimalIterator.Type type) {
        double iterationStep;
        double iterationRestart;
        double restartLowDefault;
        double restartHighDefault;
        if (iterationStartField == null) {
            throw new RuntimeException(String.format("%s property must contain %s field", ITERATION_PROP, ITERATION_PROP_START));
        }
        double iterationStart = iterationStartField;
        switch (type) {
            case FLOAT: {
                restartHighDefault = 3.4028234663852886E38;
                restartLowDefault = -3.4028234663852886E38;
                break;
            }
            case DOUBLE: {
                restartHighDefault = Double.MAX_VALUE;
                restartLowDefault = -1.7976931348623157E308;
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unexpected DecimalIterator type: %s", new Object[]{type}));
            }
        }
        if (iterationRestartField == null && iterationStepField == null) {
            iterationRestart = restartHighDefault;
            iterationStep = 1.0;
            return new DecimalIterator(iterationStart, iterationRestart, iterationStep, type);
        } else if (iterationRestartField == null) {
            iterationStep = iterationStepField;
            if (iterationStep > 0.0) {
                iterationRestart = restartHighDefault;
                return new DecimalIterator(iterationStart, iterationRestart, iterationStep, type);
            } else {
                if (!(iterationStep < 0.0)) throw new RuntimeException(String.format("%s field of %s property cannot be zero", ITERATION_PROP_STEP, ITERATION_PROP));
                iterationRestart = -1.0 * restartLowDefault;
            }
            return new DecimalIterator(iterationStart, iterationRestart, iterationStep, type);
        } else if (iterationStepField == null) {
            iterationRestart = iterationRestartField;
            if (iterationRestart > iterationStart) {
                iterationStep = 1.0;
                return new DecimalIterator(iterationStart, iterationRestart, iterationStep, type);
            } else {
                if (!(iterationRestart < iterationStart)) throw new RuntimeException(String.format("%s and %s fields of %s property cannot be equal", ITERATION_PROP_START, ITERATION_PROP_RESTART, ITERATION_PROP));
                iterationStep = -1.0;
            }
            return new DecimalIterator(iterationStart, iterationRestart, iterationStep, type);
        } else {
            iterationRestart = iterationRestartField;
            iterationStep = iterationStepField;
            if (iterationStep == 0.0) {
                throw new RuntimeException(String.format("%s field of %s property cannot be zero", ITERATION_PROP_STEP, ITERATION_PROP));
            }
            if (iterationStart == iterationRestart) {
                throw new RuntimeException(String.format("%s and %s fields of %s property cannot be equal", ITERATION_PROP_START, ITERATION_PROP_RESTART, ITERATION_PROP));
            }
            if (iterationRestart > iterationStart && iterationStep < 0.0) {
                throw new RuntimeException(String.format("%s field of %s property must be positive when %s field is greater than %s field", ITERATION_PROP_STEP, ITERATION_PROP, ITERATION_PROP_RESTART, ITERATION_PROP_START));
            }
            if (!(iterationRestart < iterationStart) || !(iterationStep > 0.0)) return new DecimalIterator(iterationStart, iterationRestart, iterationStep, type);
            throw new RuntimeException(String.format("%s field of %s property must be negative when %s field is less than %s field", ITERATION_PROP_STEP, ITERATION_PROP, ITERATION_PROP_RESTART, ITERATION_PROP_START));
        }
    }

    private Iterator<Object> parseIterations(Schema schema, Map propertiesProp) {
        this.enforceMutualExclusion(propertiesProp, ITERATION_PROP, LENGTH_PROP, REGEX_PROP, OPTIONS_PROP, RANGE_PROP);
        Object iterationProp = propertiesProp.get(ITERATION_PROP);
        if (!(iterationProp instanceof Map)) {
            throw new RuntimeException(String.format("%s prop must be an object, was %s instead", ITERATION_PROP, iterationProp.getClass().getName()));
        }
        Map iterationProps = (Map)iterationProp;
        switch (schema.getType()) {
            case BOOLEAN: {
                return this.getBooleanIterator(iterationProps);
            }
            case INT: {
                return this.getIntegerIterator(iterationProps);
            }
            case LONG: {
                return this.getLongIterator(iterationProps);
            }
            case FLOAT: {
                return this.getFloatIterator(iterationProps);
            }
            case DOUBLE: {
                return this.getDoubleIterator(iterationProps);
            }
            case STRING: {
                return this.createStringIterator(this.getIntegerIterator(iterationProps), propertiesProp);
            }
        }
        throw new UnsupportedOperationException(String.format("%s property can only be specified on numeric, boolean or string schemas, not %s schema", ITERATION_PROP, schema.getType().toString()));
    }

    private Iterator<Object> getDoubleIterator(Map iterationProps) {
        Double iterationStartField = this.getDecimalNumberField(ITERATION_PROP, ITERATION_PROP_START, iterationProps);
        Double iterationRestartField = this.getDecimalNumberField(ITERATION_PROP, ITERATION_PROP_RESTART, iterationProps);
        Double iterationStepField = this.getDecimalNumberField(ITERATION_PROP, ITERATION_PROP_STEP, iterationProps);
        return this.getDecimalIterator(iterationStartField, iterationRestartField, iterationStepField, DecimalIterator.Type.DOUBLE);
    }

    private Iterator<Object> getFloatIterator(Map iterationProps) {
        Float iterationStartField = this.getFloatNumberField(ITERATION_PROP, ITERATION_PROP_START, iterationProps);
        Float iterationRestartField = this.getFloatNumberField(ITERATION_PROP, ITERATION_PROP_RESTART, iterationProps);
        Float iterationStepField = this.getFloatNumberField(ITERATION_PROP, ITERATION_PROP_STEP, iterationProps);
        return this.getDecimalIterator(iterationStartField != null ? Double.valueOf(iterationStartField.doubleValue()) : null, iterationRestartField != null ? Double.valueOf(iterationRestartField.doubleValue()) : null, iterationStepField != null ? Double.valueOf(iterationStepField.doubleValue()) : null, DecimalIterator.Type.FLOAT);
    }

    private Iterator<Object> getLongIterator(Map iterationProps) {
        Long iterationStartField = this.getIntegralNumberField(ITERATION_PROP, ITERATION_PROP_START, iterationProps);
        Long iterationRestartField = this.getIntegralNumberField(ITERATION_PROP, ITERATION_PROP_RESTART, iterationProps);
        Long iterationStepField = this.getIntegralNumberField(ITERATION_PROP, ITERATION_PROP_STEP, iterationProps);
        return this.getIntegralIterator(iterationStartField, iterationRestartField, iterationStepField, IntegralIterator.Type.LONG);
    }

    private Iterator<Object> createStringIterator(final Iterator<Object> inner, final Map propertiesProp) {
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return inner.hasNext();
            }

            @Override
            public Object next() {
                return Generator.this.prefixAndSuffixString(inner.next().toString(), propertiesProp);
            }
        };
    }

    private Iterator<Object> getIntegerIterator(Map iterationProps) {
        Integer iterationStartField = this.getIntegerNumberField(ITERATION_PROP, ITERATION_PROP_START, iterationProps);
        Integer iterationRestartField = this.getIntegerNumberField(ITERATION_PROP, ITERATION_PROP_RESTART, iterationProps);
        Integer iterationStepField = this.getIntegerNumberField(ITERATION_PROP, ITERATION_PROP_STEP, iterationProps);
        return this.getIntegralIterator(iterationStartField != null ? Long.valueOf(iterationStartField.longValue()) : null, iterationRestartField != null ? Long.valueOf(iterationRestartField.longValue()) : null, iterationStepField != null ? Long.valueOf(iterationStepField.longValue()) : null, IntegralIterator.Type.INTEGER);
    }

    private <T> T generateIteration(Schema schema, Map propertiesProp) {
        if (!this.iteratorCache.containsKey(schema)) {
            this.iteratorCache.put(schema, this.parseIterations(schema, propertiesProp));
        }
        return (T)this.iteratorCache.get(schema).next();
    }

    private Collection<Object> generateArray(Schema schema, Map propertiesProp) {
        int length = this.getLengthBounds(propertiesProp).random();
        ArrayList<Object> result = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            result.add(this.generateObject(schema.getElementType()));
        }
        return result;
    }

    private Boolean generateBoolean(Map propertiesProp) {
        Double odds = this.getDecimalNumberField(ARG_PROPERTIES_PROP, ODDS_PROP, propertiesProp);
        if (odds == null) {
            return this.random.nextBoolean();
        }
        if (odds < 0.0 || odds > 1.0) {
            throw new RuntimeException(String.format("%s property must be in the range [0.0, 1.0]", ODDS_PROP));
        }
        return this.random.nextDouble() < odds;
    }

    private ByteBuffer generateBytes(Map propertiesProp) {
        byte[] bytes = new byte[this.getLengthBounds(propertiesProp.get(LENGTH_PROP)).random()];
        this.random.nextBytes(bytes);
        return ByteBuffer.wrap(bytes);
    }

    private Double generateDouble(Map propertiesProp) {
        Object rangeProp = propertiesProp.get(RANGE_PROP);
        if (rangeProp != null) {
            if (rangeProp instanceof Map) {
                double rangeMax;
                Map rangeProps = (Map)rangeProp;
                Double rangeMinField = this.getDecimalNumberField(RANGE_PROP, "min", rangeProps);
                Double rangeMaxField = this.getDecimalNumberField(RANGE_PROP, "max", rangeProps);
                double rangeMin = rangeMinField != null ? rangeMinField : -1.7976931348623157E308;
                double d = rangeMax = rangeMaxField != null ? rangeMaxField : Double.MAX_VALUE;
                if (rangeMin >= rangeMax) {
                    throw new RuntimeException(String.format("'%s' field must be strictly less than '%s' field in %s property", "min", "max", RANGE_PROP));
                }
                return rangeMin + this.random.nextDouble() * (rangeMax - rangeMin);
            }
            throw new RuntimeException(String.format("%s property must be an object", RANGE_PROP));
        }
        return this.random.nextDouble();
    }

    private GenericEnumSymbol generateEnumSymbol(Schema schema) {
        List enums = schema.getEnumSymbols();
        return new GenericData.EnumSymbol(schema, (String)enums.get(this.random.nextInt(enums.size())));
    }

    private GenericFixed generateFixed(Schema schema) {
        byte[] bytes = new byte[schema.getFixedSize()];
        this.random.nextBytes(bytes);
        return new GenericData.Fixed(schema, bytes);
    }

    private Float generateFloat(Map propertiesProp) {
        Object rangeProp = propertiesProp.get(RANGE_PROP);
        if (rangeProp != null && rangeProp instanceof Map) {
            float rangeMax;
            Map rangeProps = (Map)rangeProp;
            Float rangeMinField = this.getFloatNumberField(RANGE_PROP, "min", rangeProps);
            Float rangeMaxField = this.getFloatNumberField(RANGE_PROP, "max", rangeProps);
            float rangeMin = Optional.ofNullable(rangeMinField).orElse(Float.valueOf(-3.4028235E38f)).floatValue();
            if (rangeMin >= (rangeMax = Optional.ofNullable(rangeMaxField).orElse(Float.valueOf(Float.MAX_VALUE)).floatValue())) {
                throw new RuntimeException(String.format("'%s' field must be strictly less than '%s' field in %s property", "min", "max", RANGE_PROP));
            }
            return Float.valueOf(rangeMin + this.random.nextFloat() * (rangeMax - rangeMin));
        }
        return Float.valueOf(this.random.nextFloat());
    }

    private Integer generateInt(Map propertiesProp) {
        Object rangeProp = propertiesProp.get(RANGE_PROP);
        if (rangeProp != null && rangeProp instanceof Map) {
            int rangeMax;
            Map rangeProps = (Map)rangeProp;
            Integer rangeMinField = this.getIntegerNumberField(RANGE_PROP, "min", rangeProps);
            Integer rangeMaxField = this.getIntegerNumberField(RANGE_PROP, "max", rangeProps);
            int rangeMin = Optional.ofNullable(rangeMinField).orElse(Integer.MIN_VALUE);
            if (rangeMin >= (rangeMax = Optional.ofNullable(rangeMaxField).orElse(Integer.MAX_VALUE).intValue())) {
                throw new RuntimeException(String.format("'%s' field must be strictly less than '%s' field in %s property", "min", "max", RANGE_PROP));
            }
            return rangeMin + (int)(this.random.nextDouble() * (double)(rangeMax - rangeMin));
        }
        return this.random.nextInt();
    }

    private Long generateLong(Map propertiesProp) {
        Object rangeProp = propertiesProp.get(RANGE_PROP);
        if (rangeProp != null && rangeProp instanceof Map) {
            long rangeMax;
            Map rangeProps = (Map)rangeProp;
            Long rangeMinField = this.getIntegralNumberField(RANGE_PROP, "min", rangeProps);
            Long rangeMaxField = this.getIntegralNumberField(RANGE_PROP, "max", rangeProps);
            long rangeMin = Optional.ofNullable(rangeMinField).orElse(Long.MIN_VALUE);
            if (rangeMin >= (rangeMax = Optional.ofNullable(rangeMaxField).orElse(Long.MAX_VALUE).longValue())) {
                throw new RuntimeException(String.format("'%s' field must be strictly less than '%s' field in %s property", "min", "max", RANGE_PROP));
            }
            return rangeMin + (long)(this.random.nextDouble() * (double)(rangeMax - rangeMin));
        }
        return this.random.nextLong();
    }

    private Map<String, Object> generateMap(Schema schema, Map propertiesProp) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int length = this.getLengthBounds(propertiesProp).random();
        Object keyProp = propertiesProp.get(KEYS_PROP);
        if (keyProp == null) {
            for (int i = 0; i < length; ++i) {
                result.put(this.generateRandomString(1), this.generateObject(schema.getValueType()));
            }
        } else if (keyProp instanceof Map) {
            Map keyPropMap = (Map)keyProp;
            if (keyPropMap.containsKey(OPTIONS_PROP)) {
                if (!this.optionsCache.containsKey(schema)) {
                    this.optionsCache.put(schema, this.parseOptions(Schema.create((Schema.Type)Schema.Type.STRING), keyPropMap));
                }
                for (int i = 0; i < length; ++i) {
                    result.put((String)this.generateOption(schema, keyPropMap), this.generateObject(schema.getValueType()));
                }
            } else {
                int keyLength = this.getLengthBounds(keyPropMap.get(LENGTH_PROP)).random();
                for (int i = 0; i < length; ++i) {
                    result.put(this.generateRandomString(keyLength), this.generateObject(schema.getValueType()));
                }
            }
        } else {
            throw new RuntimeException(String.format("%s prop must be an object", KEYS_PROP));
        }
        return result;
    }

    private Object generateNull() {
        return null;
    }

    private GenericRecord generateRecord(Schema schema) {
        GenericRecordBuilder builder = new GenericRecordBuilder(schema);
        for (Schema.Field field : schema.getFields()) {
            builder.set(field, this.generateObject(field.schema()));
        }
        return builder.build();
    }

    private String generateRegexString(Schema schema, Object regexProp, LengthBounds lengthBounds) {
        if (!this.generexCache.containsKey(schema)) {
            if (!(regexProp instanceof String)) {
                throw new RuntimeException(String.format("%s property must be a string", REGEX_PROP));
            }
            this.generexCache.put(schema, new Generex((String)regexProp));
        }
        return this.generexCache.get(schema).random(lengthBounds.min(), lengthBounds.max() - 1);
    }

    private String generateRandomString(int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)this.random.nextInt(128);
        }
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    private String generateString(Schema schema, Map propertiesProp) {
        Object regexProp = propertiesProp.get(REGEX_PROP);
        String result = regexProp != null ? this.generateRegexString(schema, regexProp, this.getLengthBounds(propertiesProp)) : this.generateRandomString(this.getLengthBounds(propertiesProp).random());
        return this.prefixAndSuffixString(result, propertiesProp);
    }

    private String prefixAndSuffixString(String result, Map propertiesProp) {
        Object prefixProp = propertiesProp.get(PREFIX_PROP);
        if (prefixProp != null && !(prefixProp instanceof String)) {
            throw new RuntimeException(String.format("%s property must be a string", PREFIX_PROP));
        }
        String prefix = prefixProp != null ? (String)prefixProp : "";
        Object suffixProp = propertiesProp.get(SUFFIX_PROP);
        if (suffixProp != null && !(suffixProp instanceof String)) {
            throw new RuntimeException(String.format("%s property must be a string", SUFFIX_PROP));
        }
        String suffix = suffixProp != null ? (String)suffixProp : "";
        return prefix + result + suffix;
    }

    private Object generateUnion(Schema schema) {
        List schemas = schema.getTypes();
        return this.generateObject((Schema)schemas.get(this.random.nextInt(schemas.size())));
    }

    private LengthBounds getLengthBounds(Map propertiesProp) {
        return this.getLengthBounds(propertiesProp.get(LENGTH_PROP));
    }

    private LengthBounds getLengthBounds(Object lengthProp) {
        if (lengthProp == null) {
            return new LengthBounds();
        }
        if (lengthProp instanceof Integer) {
            Integer length = (Integer)lengthProp;
            if (length < 0) {
                throw new RuntimeException(String.format("when given as integral number, %s property cannot be negative", LENGTH_PROP));
            }
            return new LengthBounds(length);
        }
        if (lengthProp instanceof Map) {
            Map lengthProps = (Map)lengthProp;
            Integer minLength = this.getIntegerNumberField(LENGTH_PROP, "min", lengthProps);
            Integer maxLength = this.getIntegerNumberField(LENGTH_PROP, "max", lengthProps);
            if (minLength == null && maxLength == null) {
                throw new RuntimeException(String.format("%s property must contain at least one of '%s' or '%s' fields when given as object", LENGTH_PROP, "min", "max"));
            }
            minLength = minLength != null ? minLength : 0;
            maxLength = maxLength != null ? maxLength : Integer.MAX_VALUE;
            if (minLength < 0) {
                throw new RuntimeException(String.format("%s field of %s property cannot be negative", "min", LENGTH_PROP));
            }
            if (maxLength <= minLength) {
                throw new RuntimeException(String.format("%s field must be strictly greater than %s field for %s property", "max", "min", LENGTH_PROP));
            }
            return new LengthBounds(minLength, maxLength);
        }
        throw new RuntimeException(String.format("%s property must either be an integral number or an object, was %s instead", LENGTH_PROP, lengthProp.getClass().getName()));
    }

    private Integer getIntegerNumberField(String property, String field, Map propsMap) {
        Long result = this.getIntegralNumberField(property, field, propsMap);
        if (result != null && (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE)) {
            throw new RuntimeException(String.format("'%s' field of %s property must be a valid int for int schemas", field, property));
        }
        return result != null ? Integer.valueOf(result.intValue()) : null;
    }

    private Long getIntegralNumberField(String property, String field, Map propsMap) {
        Object result = propsMap.get(field);
        if (result == null || result instanceof Long) {
            return (Long)result;
        }
        if (result instanceof Integer) {
            return ((Integer)result).longValue();
        }
        throw new RuntimeException(String.format("'%s' field of %s property must be an integral number, was %s instead", field, property, result.getClass().getName()));
    }

    private Float getFloatNumberField(String property, String field, Map propsMap) {
        Double result = this.getDecimalNumberField(property, field, propsMap);
        if (result != null && (result > 3.4028234663852886E38 || result < (double)-1.4E-45f)) {
            throw new RuntimeException(String.format("'%s' field of %s property must be a valid float for float schemas", field, property));
        }
        return result != null ? Float.valueOf(result.floatValue()) : null;
    }

    private Double getDecimalNumberField(String property, String field, Map propsMap) {
        Object result = propsMap.get(field);
        if (result == null || result instanceof Double) {
            return (Double)result;
        }
        if (result instanceof Float) {
            return ((Float)result).doubleValue();
        }
        if (result instanceof Integer) {
            return ((Integer)result).doubleValue();
        }
        if (result instanceof Long) {
            return ((Long)result).doubleValue();
        }
        throw new RuntimeException(String.format("'%s' field of %s property must be a number, was %s instead", field, property, result.getClass().getName()));
    }

    private static class BooleanIterator
    implements Iterator<Object> {
        private boolean current;

        public BooleanIterator(boolean start) {
            this.current = start;
        }

        @Override
        public Boolean next() {
            boolean result = this.current;
            this.current = !this.current;
            return result;
        }

        @Override
        public boolean hasNext() {
            return true;
        }
    }

    private static class DecimalIterator
    implements Iterator<Object> {
        private final double start;
        private final double restart;
        private final double step;
        private final Type type;
        private double current;

        public DecimalIterator(double start, double restart, double step, Type type) {
            this.start = start;
            this.restart = restart;
            this.step = step;
            this.type = type;
            this.current = start;
        }

        @Override
        public Object next() {
            double result = this.current;
            this.current = this.step > 0.0 && this.current >= this.restart - this.step || this.step < 0.0 && this.current <= this.restart - this.step ? this.start + DecimalIterator.modulo(this.step - (this.restart - this.current), this.restart - this.start) : (this.current += this.step);
            switch (this.type) {
                case FLOAT: {
                    return Float.valueOf((float)result);
                }
                case DOUBLE: {
                    return result;
                }
            }
            throw new RuntimeException(String.format("Unexpected Type: %s", new Object[]{this.type}));
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        private static double modulo(double first, double second) {
            return (first % second + second) % second;
        }

        public static enum Type {
            FLOAT,
            DOUBLE;

        }
    }

    private static class IntegralIterator
    implements Iterator<Object> {
        private final long start;
        private final long restart;
        private final long step;
        private final Type type;
        private long current;

        public IntegralIterator(long start, long restart, long step, Type type) {
            this.start = start;
            this.restart = restart;
            this.step = step;
            this.type = type;
            this.current = start;
        }

        @Override
        public Object next() {
            long result = this.current;
            this.current = this.step > 0L && this.current >= this.restart - this.step || this.step < 0L && this.current <= this.restart - this.step ? this.start + IntegralIterator.modulo(this.step - (this.restart - this.current), this.restart - this.start) : (this.current += this.step);
            switch (this.type) {
                case INTEGER: {
                    return (int)result;
                }
                case LONG: {
                    return result;
                }
            }
            throw new RuntimeException(String.format("Unexpected Type: %s", new Object[]{this.type}));
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        private static long modulo(long first, long second) {
            return (first % second + second) % second;
        }

        public static enum Type {
            INTEGER,
            LONG;

        }
    }

    private class LengthBounds {
        public static final int DEFAULT_MIN = 8;
        public static final int DEFAULT_MAX = 16;
        private final int min;
        private final int max;

        public LengthBounds(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public LengthBounds(int exact) {
            this(exact, exact + 1);
        }

        public LengthBounds() {
            this(8, 16);
        }

        public int random() {
            return this.min + Generator.this.random.nextInt(this.max - this.min);
        }

        public int min() {
            return this.min;
        }

        public int max() {
            return this.max;
        }
    }
}

