/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli;

import io.confluent.ksql.cli.KsqlRequestExecutor;
import io.confluent.ksql.cli.console.Console;
import io.confluent.ksql.cli.console.KsqlTerminal;
import io.confluent.ksql.cli.console.OutputFormat;
import io.confluent.ksql.cli.console.cmd.CliCommandRegisterUtil;
import io.confluent.ksql.cli.console.cmd.RemoteServerSpecificCommand;
import io.confluent.ksql.parser.DefaultKsqlParser;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.VariableSubstitutor;
import io.confluent.ksql.reactive.BaseSubscriber;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.client.KsqlRestClient;
import io.confluent.ksql.rest.client.RestResponse;
import io.confluent.ksql.rest.client.StreamPublisher;
import io.confluent.ksql.rest.client.exception.KsqlMissingCredentialsException;
import io.confluent.ksql.rest.client.exception.KsqlRestClientException;
import io.confluent.ksql.rest.client.exception.KsqlUnsupportedServerException;
import io.confluent.ksql.rest.entity.CommandStatus;
import io.confluent.ksql.rest.entity.CommandStatusEntity;
import io.confluent.ksql.rest.entity.ConsistencyToken;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.rest.entity.KsqlEntityList;
import io.confluent.ksql.rest.entity.ServerInfo;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.rest.entity.VariablesList;
import io.confluent.ksql.util.AppInfo;
import io.confluent.ksql.util.ErrorMessageUtil;
import io.confluent.ksql.util.HandlerMaps;
import io.confluent.ksql.util.KsqlVersion;
import io.confluent.ksql.util.ParserUtil;
import io.confluent.ksql.util.WelcomeMsgUtils;
import io.vertx.core.Context;
import io.vertx.core.VertxException;
import java.io.Closeable;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jline.reader.EndOfFileException;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cli
implements KsqlRequestExecutor,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Cli.class);
    private static final int MAX_RETRIES = 10;
    private static final String UNKNOWN_VERSION = "<unknown>";
    private static final String NO_WARNING = "";
    private static final int NO_ERROR = 0;
    private static final int ERROR = -1;
    private static final KsqlParser KSQL_PARSER = new DefaultKsqlParser();
    private static final HandlerMaps.ClassHandlerMapR2<SqlBaseParser.StatementContext, Cli, Void, Optional> STATEMENT_VALIDATORS = HandlerMaps.forClass(SqlBaseParser.StatementContext.class).withArgTypes(Cli.class, Void.class).withReturnType(Optional.class).put(SqlBaseParser.DefineVariableContext.class, Cli::defineVariableFromCtxtSandbox).put(SqlBaseParser.UndefineVariableContext.class, Cli::undefineVariableFromCtxtSandbox).put(SqlBaseParser.CreateConnectorContext.class, Cli::validateConnectorRequest).put(SqlBaseParser.DropConnectorContext.class, Cli::validateConnectorRequest).put(SqlBaseParser.DescribeConnectorContext.class, Cli::validateConnectorRequest).put(SqlBaseParser.ListConnectorsContext.class, Cli::validateConnectorRequest).put(SqlBaseParser.ListConnectorPluginsContext.class, Cli::validateConnectorRequest).build();
    private static final HandlerMaps.ClassHandlerMap2<SqlBaseParser.StatementContext, Cli, String> STATEMENT_HANDLERS = HandlerMaps.forClass(SqlBaseParser.StatementContext.class).withArgTypes(Cli.class, String.class).put(SqlBaseParser.QueryStatementContext.class, Cli::handleQuery).put(SqlBaseParser.PrintTopicContext.class, Cli::handlePrintedTopic).put(SqlBaseParser.SetPropertyContext.class, Cli::setPropertyFromCtxt).put(SqlBaseParser.UnsetPropertyContext.class, Cli::unsetPropertyFromCtxt).put(SqlBaseParser.DefineVariableContext.class, Cli::defineVariableFromCtxt).put(SqlBaseParser.UndefineVariableContext.class, Cli::undefineVariableFromCtxt).put(SqlBaseParser.ListVariablesContext.class, Cli::listVariablesFromCtxt).put(SqlBaseParser.CreateConnectorContext.class, Cli::handleConnectorRequest).put(SqlBaseParser.DropConnectorContext.class, Cli::handleConnectorRequest).put(SqlBaseParser.DescribeConnectorContext.class, Cli::handleConnectorRequest).put(SqlBaseParser.ListConnectorsContext.class, Cli::handleConnectorRequest).put(SqlBaseParser.ListConnectorPluginsContext.class, Cli::handleConnectorRequest).build();
    private final Long streamedQueryRowLimit;
    private final Long streamedQueryTimeoutMs;
    private final KsqlRestClient restClient;
    private final Console terminal;
    private final RemoteServerState remoteServerState;
    private final Map<String, String> sessionVariables;
    private Map<String, String> sandboxedSessionVariables;

    public static Cli build(Long streamedQueryRowLimit, Long streamedQueryTimeoutMs, OutputFormat outputFormat, KsqlRestClient restClient) {
        Console console = Console.build(outputFormat);
        return new Cli(streamedQueryRowLimit, streamedQueryTimeoutMs, restClient, console);
    }

    Cli(Long streamedQueryRowLimit, Long streamedQueryTimeoutMs, KsqlRestClient restClient, Console terminal) {
        Objects.requireNonNull(restClient, "Must provide the CLI with a REST client");
        Objects.requireNonNull(terminal, "Must provide the CLI with a terminal");
        this.streamedQueryRowLimit = streamedQueryRowLimit;
        this.streamedQueryTimeoutMs = streamedQueryTimeoutMs;
        this.restClient = restClient;
        this.terminal = terminal;
        this.remoteServerState = new RemoteServerState();
        this.sessionVariables = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Supplier<String> versionSuppler = () -> ((ServerInfo)restClient.getServerInfo().getResponse()).getVersion();
        CliCommandRegisterUtil.registerDefaultCommands(this, terminal, versionSuppler, restClient, () -> this.remoteServerState.reset(), () -> this.remoteServerState.getRequestPipelining(), x$0 -> this.remoteServerState.setRequestPipelining(x$0));
    }

    public void addSessionVariables(Map<String, String> vars) {
        this.sessionVariables.putAll(vars);
    }

    @Override
    public void makeKsqlRequest(String statements) {
        if (statements.isEmpty()) {
            return;
        }
        this.printKsqlResponse(this.makeKsqlRequest(statements, (arg_0, arg_1) -> ((KsqlRestClient)this.restClient).makeKsqlRequest(arg_0, arg_1)));
    }

    private <R> RestResponse<R> makeKsqlRequest(String ksql, BiFunction<String, Long, RestResponse<R>> requestIssuer) {
        Long commandSequenceNumberToWaitFor = this.remoteServerState.getRequestPipelining() ? null : Long.valueOf(this.remoteServerState.getLastCommandSequenceNumber());
        for (int retries = 0; retries < 10; ++retries) {
            try {
                RestResponse<R> response = requestIssuer.apply(ksql, commandSequenceNumberToWaitFor);
                if (Cli.isSequenceNumberTimeout(response)) {
                    this.terminal.writer().printf("Error: command not executed since the server timed out while waiting for prior commands to finish executing.%nIf you wish to execute new commands without waiting for prior commands to finish, run the command '%s ON'.%n", "request-pipelining");
                } else if (Cli.isKsqlEntityList(response)) {
                    this.updateLastCommandSequenceNumber((KsqlEntityList)response.getResponse());
                }
                return response;
            }
            catch (KsqlRestClientException e) {
                VertxException ve;
                if (e.getCause() instanceof ExecutionException && e.getCause().getCause() instanceof VertxException && (ve = (VertxException)e.getCause().getCause()).getMessage().equals("Connection was closed")) {
                    continue;
                }
                throw e;
            }
        }
        throw new KsqlRestClientException("Failed to execute request " + ksql);
    }

    public int runScript(String scriptFile) {
        int errorCode = 0;
        RemoteServerSpecificCommand.validateClient(this.terminal.writer(), this.restClient);
        try {
            String content = Files.readAllLines(Paths.get(scriptFile, new String[0]), StandardCharsets.UTF_8).stream().collect(Collectors.joining(System.lineSeparator()));
            this.handleLine(content);
        }
        catch (Exception exception) {
            errorCode = -1;
            LOGGER.error("An error occurred while running a script file. Error = " + exception.getMessage(), (Throwable)exception);
            this.terminal.printError(ErrorMessageUtil.buildErrorMessage((Throwable)exception), exception.toString());
        }
        this.terminal.flush();
        return errorCode;
    }

    public int runCommand(String command) {
        int errorCode = 0;
        RemoteServerSpecificCommand.validateClient(this.terminal.writer(), this.restClient);
        try {
            this.handleLine(command);
        }
        catch (EndOfFileException endOfFileException) {
        }
        catch (Exception exception) {
            errorCode = -1;
            LOGGER.error("An error occurred while running a command. Error = " + exception.getMessage(), (Throwable)exception);
            this.terminal.printError(ErrorMessageUtil.buildErrorMessage((Throwable)exception), exception.toString());
        }
        this.terminal.flush();
        return errorCode;
    }

    public int runInteractively() {
        this.displayWelcomeMessage();
        RemoteServerSpecificCommand.validateClient(this.terminal.writer(), this.restClient);
        boolean eof = false;
        while (!eof) {
            try {
                this.handleLine(this.nextNonCliCommand());
            }
            catch (EndOfFileException exception) {
                this.terminal.writer().println("Exiting ksqlDB.");
                eof = true;
            }
            catch (Exception exception) {
                LOGGER.error("An error occurred while running a command. Error = " + exception.getMessage(), (Throwable)exception);
                this.terminal.printError(ErrorMessageUtil.buildErrorMessage((Throwable)exception), exception.toString());
            }
            this.terminal.flush();
        }
        return 0;
    }

    private void displayWelcomeMessage() {
        String serverStatus;
        String serverVersion;
        try {
            ServerInfo serverInfo = (ServerInfo)this.restClient.getServerInfo().getResponse();
            serverVersion = serverInfo.getVersion();
            serverStatus = serverInfo.getServerStatus() == null ? UNKNOWN_VERSION : serverInfo.getServerStatus();
        }
        catch (Exception exception) {
            serverVersion = UNKNOWN_VERSION;
            serverStatus = UNKNOWN_VERSION;
        }
        String cliVersion = AppInfo.getVersion();
        String versionMismatchWarning = Cli.checkServerCompatibility(cliVersion, serverVersion);
        String helpReminderMessage = "Having trouble? Type 'help' (case-insensitive) for a rundown of how things work!";
        PrintWriter writer = this.terminal.writer();
        int consoleWidth = Math.min(this.terminal.getWidth(), "Having trouble? Type 'help' (case-insensitive) for a rundown of how things work!".length());
        WelcomeMsgUtils.displayWelcomeMessage((int)consoleWidth, (PrintWriter)writer);
        writer.printf("CLI v%s, Server v%s located at %s%n%s", cliVersion, serverVersion, this.restClient.getServerAddress(), versionMismatchWarning);
        writer.println("Server Status: " + serverStatus);
        writer.println();
        writer.println("Having trouble? Type 'help' (case-insensitive) for a rundown of how things work!");
        writer.println();
        this.terminal.flush();
    }

    private static String checkServerCompatibility(String cliVersionNumber, String serverVersionNumber) {
        KsqlVersion serverVersion;
        KsqlVersion cliVersion;
        try {
            cliVersion = new KsqlVersion(cliVersionNumber);
        }
        catch (IllegalArgumentException exception) {
            return "\nWARNING: Could not identify CLI version.\n         Non-matching CLI and server versions may lead to unexpected errors.\n\n";
        }
        try {
            serverVersion = new KsqlVersion(serverVersionNumber);
        }
        catch (IllegalArgumentException exception) {
            return "\nWARNING: Could not identify server version.\n         Non-matching CLI and server versions may lead to unexpected errors.\n\n";
        }
        if (!serverVersion.isAtLeast(new KsqlVersion("6.0."))) {
            throw new KsqlUnsupportedServerException(serverVersion.type() == KsqlVersion.VersionType.CONFLUENT_PLATFORM ? "6.0.0" : "0.10.0", cliVersionNumber, serverVersionNumber);
        }
        if (!cliVersion.same(serverVersion)) {
            return "\nWARNING: CLI and server version don't match. This may lead to unexpected errors.\n         It is recommended to use a CLI that matches the server version.\n\n";
        }
        return NO_WARNING;
    }

    @Override
    public void close() {
        this.terminal.close();
    }

    void handleLine(String line) {
        String trimmedLine = Optional.ofNullable(line).orElse(NO_WARNING).trim();
        if (trimmedLine.isEmpty()) {
            return;
        }
        this.handleStatements(trimmedLine);
    }

    private String nextNonCliCommand() {
        while (true) {
            try {
                String line = this.terminal.nextNonCliCommand();
                if (line == null) {
                    throw new EndOfFileException();
                }
                return line.trim();
            }
            catch (UserInterruptException exception) {
                this.terminal.writer().println("^C");
                this.terminal.flush();
                continue;
            }
            break;
        }
    }

    private boolean isVariableSubstitutionEnabled() {
        Object substitutionEnabled = this.restClient.getProperty("ksql.variable.substitution.enable");
        if (substitutionEnabled instanceof Boolean) {
            return (Boolean)substitutionEnabled;
        }
        return true;
    }

    private KsqlParser.ParsedStatement substituteVariables(KsqlParser.ParsedStatement statement, boolean isSandbox) {
        if (this.isVariableSubstitutionEnabled()) {
            String replacedStmt = isSandbox ? VariableSubstitutor.substitute((KsqlParser.ParsedStatement)statement, this.sandboxedSessionVariables) : VariableSubstitutor.substitute((KsqlParser.ParsedStatement)statement, this.sessionVariables);
            return (KsqlParser.ParsedStatement)KSQL_PARSER.parse(replacedStmt).get(0);
        }
        return statement;
    }

    private void handleStatements(String line) {
        List statements = KSQL_PARSER.parse(line);
        this.sandboxedSessionVariables = new HashMap<String, String>(this.sessionVariables);
        statements.stream().map(stmt -> this.substituteVariables((KsqlParser.ParsedStatement)stmt, true)).forEach(parsed -> {
            SqlBaseParser.StatementContext statementContext = parsed.getStatement().statement();
            HandlerMaps.HandlerR2 validator = STATEMENT_VALIDATORS.get(statementContext.getClass());
            if (validator != null) {
                Optional validationError = (Optional)validator.handle((Object)this, null, (Object)statementContext);
                validationError.map(o -> (RuntimeException)o).ifPresent(error -> {
                    throw error;
                });
            }
        });
        StringBuilder consecutiveStatements = new StringBuilder();
        statements.stream().map(stmt -> this.substituteVariables((KsqlParser.ParsedStatement)stmt, false)).forEach(parsed -> {
            SqlBaseParser.StatementContext statementContext = parsed.getStatement().statement();
            String statementText = parsed.getUnMaskedStatementText();
            HandlerMaps.Handler2 handler = STATEMENT_HANDLERS.get(statementContext.getClass());
            if (handler == null) {
                consecutiveStatements.append(statementText);
            } else {
                this.makeKsqlRequest(consecutiveStatements.toString());
                consecutiveStatements.setLength(0);
                handler.handle((Object)this, (Object)statementText, (Object)statementContext);
            }
        });
        if (consecutiveStatements.length() != 0) {
            this.makeKsqlRequest(consecutiveStatements.toString());
        }
    }

    private void printKsqlResponse(RestResponse<KsqlEntityList> response) {
        if (response.isSuccessful()) {
            KsqlEntityList ksqlEntities = (KsqlEntityList)response.getResponse();
            boolean noErrorFromServer = true;
            for (KsqlEntity entity : ksqlEntities) {
                if (!(entity instanceof CommandStatusEntity) || ((CommandStatusEntity)entity).getCommandStatus().getStatus() != CommandStatus.Status.ERROR) continue;
                String fullMessage = ((CommandStatusEntity)entity).getCommandStatus().getMessage();
                this.terminal.printError(fullMessage.split("\n")[0], fullMessage);
                noErrorFromServer = false;
            }
            if (noErrorFromServer) {
                this.terminal.printKsqlEntityList((List)response.getResponse());
            }
        } else {
            this.terminal.printErrorMessage(response.getErrorMessage());
        }
    }

    private <C extends SqlBaseParser.StatementContext> Optional<RuntimeException> validateConnectorRequest(C context) {
        if (this.restClient.getIsCCloudServer() && !this.restClient.getHasCCloudApiKey()) {
            return Optional.of(new KsqlMissingCredentialsException("In order to use ksqlDB's connector management capabilities with a Confluent Cloud ksqlDB server, launch the ksqlDB command line with the additional flags '--confluent-api-key' and '--confluent-api-secret' to pass a Confluent Cloud API key."));
        }
        return Optional.empty();
    }

    private <C extends SqlBaseParser.StatementContext> void handleConnectorRequest(String statement, C context) {
        this.printKsqlResponse(this.makeKsqlRequest(statement, (arg_0, arg_1) -> ((KsqlRestClient)this.restClient).makeConnectorRequest(arg_0, arg_1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQuery(String statement, SqlBaseParser.QueryStatementContext query) {
        RestResponse queryResponse = this.makeKsqlRequest(statement, (arg_0, arg_1) -> ((KsqlRestClient)this.restClient).makeQueryRequestStreamed(arg_0, arg_1));
        if (!queryResponse.isSuccessful()) {
            this.terminal.printErrorMessage(queryResponse.getErrorMessage());
            this.terminal.flush();
        } else {
            try (KsqlTerminal.StatusClosable toClose = this.terminal.setStatusMessage("Press CTRL-C to interrupt");){
                StreamPublisher publisher = (StreamPublisher)queryResponse.getResponse();
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                QueryStreamSubscriber subscriber = new QueryStreamSubscriber(publisher.getContext(), future);
                publisher.subscribe((Subscriber)subscriber);
                this.terminal.handle(Terminal.Signal.INT, signal -> {
                    this.terminal.handle(Terminal.Signal.INT, Terminal.SignalHandler.SIG_IGN);
                    subscriber.close();
                    future.complete(null);
                });
                try {
                    if (this.streamedQueryTimeoutMs != null) {
                        future.get(this.streamedQueryTimeoutMs, TimeUnit.MILLISECONDS);
                    } else {
                        future.get();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected exception in waiting for query", (Throwable)e);
                }
                finally {
                    this.terminal.writer().println("Query terminated");
                    this.terminal.flush();
                    publisher.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePrintedTopic(String printTopic, SqlBaseParser.PrintTopicContext ignored) {
        RestResponse topicResponse = this.makeKsqlRequest(printTopic, (arg_0, arg_1) -> ((KsqlRestClient)this.restClient).makePrintTopicRequest(arg_0, arg_1));
        if (topicResponse.isSuccessful()) {
            try (KsqlTerminal.StatusClosable toClose = this.terminal.setStatusMessage("Press CTRL-C to interrupt");){
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                StreamPublisher publisher = (StreamPublisher)topicResponse.getResponse();
                PrintTopicSubscriber subscriber = new PrintTopicSubscriber(publisher.getContext(), future);
                publisher.subscribe((Subscriber)subscriber);
                this.terminal.handle(Terminal.Signal.INT, signal -> {
                    this.terminal.handle(Terminal.Signal.INT, Terminal.SignalHandler.SIG_IGN);
                    subscriber.close();
                    future.complete(null);
                });
                try {
                    future.get();
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected exception in waiting for print topic completion", (Throwable)e);
                }
                finally {
                    publisher.close();
                }
                this.terminal.writer().println("Topic printing ceased");
            }
        }
        this.terminal.writer().println(topicResponse.getErrorMessage().getMessage());
        this.terminal.flush();
    }

    private void setPropertyFromCtxt(String ignored, SqlBaseParser.SetPropertyContext setPropertyContext) {
        String property = ParserUtil.unquote((String)setPropertyContext.STRING(0).getText(), (String)"'");
        String value = ParserUtil.unquote((String)setPropertyContext.STRING(1).getText(), (String)"'");
        this.setProperty(property, value);
    }

    private void setProperty(String property, String value) {
        RestResponse response = this.restClient.makeIsValidRequest(property);
        if (response.isErroneous()) {
            throw new IllegalArgumentException(String.valueOf(response.getErrorMessage()));
        }
        Object priorValue = this.restClient.setProperty(property, (Object)value);
        this.terminal.writer().printf("Successfully changed local property '%s'%s to '%s'.%s%n", property, priorValue == null ? NO_WARNING : " from '" + priorValue + "'", value, priorValue == null ? " Use the UNSET command to revert your change." : NO_WARNING);
        this.terminal.flush();
    }

    private void unsetPropertyFromCtxt(String ignored, SqlBaseParser.UnsetPropertyContext unsetPropertyContext) {
        String property = ParserUtil.unquote((String)unsetPropertyContext.STRING().getText(), (String)"'");
        this.unsetProperty(property);
    }

    private void unsetProperty(String property) {
        Object oldValue = this.restClient.unsetProperty(property);
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Cannot unset local property '%s' which was never set in the first place", property));
        }
        this.terminal.writer().printf("Successfully unset local property '%s' (value was '%s').%n", property, oldValue);
        this.terminal.flush();
    }

    private void defineVariableFromCtxt(String ignored, SqlBaseParser.DefineVariableContext context) {
        String variableName = context.variableName().getText();
        String variableValue = ParserUtil.unquote((String)context.variableValue().getText(), (String)"'");
        this.sessionVariables.put(variableName, variableValue);
    }

    private Optional<RuntimeException> defineVariableFromCtxtSandbox(SqlBaseParser.DefineVariableContext context) {
        String variableName = context.variableName().getText();
        String variableValue = ParserUtil.unquote((String)context.variableValue().getText(), (String)"'");
        this.sandboxedSessionVariables.put(variableName, variableValue);
        return Optional.empty();
    }

    private void undefineVariableFromCtxt(String ignored, SqlBaseParser.UndefineVariableContext context) {
        String variableName = context.variableName().getText();
        if (this.sessionVariables.remove(variableName) == null) {
            this.terminal.writer().printf("Cannot undefine variable '%s' which was never defined.%n", variableName);
            this.terminal.flush();
        }
    }

    private Optional<RuntimeException> undefineVariableFromCtxtSandbox(SqlBaseParser.UndefineVariableContext context) {
        String variableName = context.variableName().getText();
        this.sandboxedSessionVariables.remove(variableName);
        return Optional.empty();
    }

    private void listVariablesFromCtxt(String ignored, SqlBaseParser.ListVariablesContext listVariablesContext) {
        List variables = this.sessionVariables.entrySet().stream().map(e -> new VariablesList.Variable((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        this.terminal.printKsqlEntityList(Collections.singletonList(new VariablesList(listVariablesContext.getText(), variables)));
    }

    private static boolean isSequenceNumberTimeout(RestResponse<?> response) {
        return response.isErroneous() && response.getErrorMessage().getErrorCode() == Errors.ERROR_CODE_COMMAND_QUEUE_CATCHUP_TIMEOUT;
    }

    private static boolean isKsqlEntityList(RestResponse<?> response) {
        return response.isSuccessful() && response.getResponse() instanceof KsqlEntityList;
    }

    private void updateLastCommandSequenceNumber(KsqlEntityList entities) {
        entities.stream().filter(entity -> entity instanceof CommandStatusEntity).map(entity -> (CommandStatusEntity)entity).mapToLong(CommandStatusEntity::getCommandSequenceNumber).max().ifPresent(x$0 -> this.remoteServerState.setLastCommandSequenceNumber(x$0));
    }

    private class PrintTopicSubscriber
    extends BaseSubscriber<String> {
        private final CompletableFuture<Void> future;
        private boolean closed;

        PrintTopicSubscriber(Context context, CompletableFuture<Void> future) {
            super(context);
            this.future = Objects.requireNonNull(future);
        }

        protected void afterSubscribe(Subscription subscription) {
            this.makeRequest(1L);
        }

        protected synchronized void handleValue(String line) {
            if (this.closed) {
                return;
            }
            if (!line.isEmpty()) {
                Cli.this.terminal.writer().println(line);
                Cli.this.terminal.flush();
                this.makeRequest(1L);
            }
        }

        protected void handleComplete() {
            this.future.complete(null);
        }

        protected void handleError(Throwable t) {
            this.future.completeExceptionally(t);
        }

        synchronized void close() {
            this.closed = true;
            this.context.runOnContext(v -> this.cancel());
        }
    }

    private class QueryStreamSubscriber
    extends BaseSubscriber<StreamedRow> {
        private final CompletableFuture<Void> future;
        private boolean closed;
        private long rowsRead;

        QueryStreamSubscriber(Context context, CompletableFuture<Void> future) {
            super(context);
            this.future = Objects.requireNonNull(future);
        }

        protected void afterSubscribe(Subscription subscription) {
            this.makeRequest(1L);
        }

        protected synchronized void handleValue(StreamedRow row) {
            if (row.getConsistencyToken().isPresent()) {
                Cli.this.restClient.getSerializedConsistencyVector().set(((ConsistencyToken)row.getConsistencyToken().get()).getConsistencyToken());
                return;
            }
            if (this.closed) {
                return;
            }
            Cli.this.terminal.printStreamedRow(row);
            Cli.this.terminal.flush();
            if (row.isTerminal()) {
                this.future.complete(null);
                this.close();
                return;
            }
            if (row.getRow().isPresent()) {
                ++this.rowsRead;
                if (Cli.this.streamedQueryRowLimit != null && Cli.this.streamedQueryRowLimit == this.rowsRead) {
                    this.future.complete(null);
                    this.close();
                    return;
                }
            }
            this.makeRequest(1L);
        }

        protected void handleComplete() {
            this.future.complete(null);
        }

        protected void handleError(Throwable t) {
            this.future.completeExceptionally(t);
        }

        synchronized void close() {
            this.closed = true;
            this.context.runOnContext(v -> this.cancel());
        }
    }

    private static final class RemoteServerState {
        private long lastCommandSequenceNumber;
        private boolean requestPipelining;

        private RemoteServerState() {
            this.reset();
        }

        private void reset() {
            this.lastCommandSequenceNumber = -1L;
            this.requestPipelining = false;
        }

        private long getLastCommandSequenceNumber() {
            return this.lastCommandSequenceNumber;
        }

        private boolean getRequestPipelining() {
            return this.requestPipelining;
        }

        private void setLastCommandSequenceNumber(long seqNum) {
            this.lastCommandSequenceNumber = seqNum;
        }

        private void setRequestPipelining(boolean newSetting) {
            this.requestPipelining = newSetting;
        }
    }
}

