/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console;

final class CommentStripper {
    private static final char NONE = 'x';

    private CommentStripper() {
    }

    static String strip(String line) {
        return new Parser(line).parse();
    }

    private static final class Parser {
        private final String line;
        private int pos;

        private Parser(String line) {
            this.line = line;
            this.pos = 0;
        }

        private String parse() {
            String firstPart = this.strip();
            if (this.done()) {
                return firstPart;
            }
            StringBuilder builder = new StringBuilder(this.line.length());
            builder.append(firstPart);
            while (!this.done()) {
                builder.append(this.strip());
            }
            return builder.toString();
        }

        private boolean done() {
            return this.pos == this.line.length();
        }

        private String strip() {
            int start = this.pos;
            int lastChar = 120;
            int lastQuote = 120;
            while (this.pos != this.line.length()) {
                int c = this.line.charAt(this.pos);
                switch (c) {
                    case 34: 
                    case 39: 
                    case 96: {
                        if (lastQuote == c) {
                            lastQuote = 120;
                            break;
                        }
                        if (lastQuote != 120) break;
                        lastQuote = c;
                        break;
                    }
                    case 45: {
                        if (lastChar != 45 || lastQuote != 120) break;
                        return this.trimComment(start);
                    }
                }
                lastChar = c;
                ++this.pos;
            }
            return this.line.substring(start);
        }

        private String trimComment(int partStart) {
            String part = this.line.substring(partStart, this.pos - 1).trim();
            int newLine = this.line.indexOf("\n", this.pos + 1);
            this.pos = newLine == -1 ? this.line.length() : newLine;
            return part;
        }
    }
}

