/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.cli.console.KsqlLineParser;
import io.confluent.ksql.cli.console.LineReader;
import io.confluent.ksql.cli.console.TrimmingParser;
import io.confluent.ksql.util.CliUtils;
import io.confluent.ksql.util.ErrorMessageUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jline.reader.Expander;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultExpander;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JLineReader
implements LineReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JLineReader.class);
    private static final String DEFAULT_PROMPT = "ksql> ";
    private final DefaultHistory history;
    private final org.jline.reader.LineReader lineReader;
    private final String prompt;
    private final Terminal terminal;

    JLineReader(Terminal terminal, Path historyFilePath, Predicate<String> cliLinePredicate) {
        this.terminal = Objects.requireNonNull(terminal, "terminal");
        this.lineReader = JLineReader.build(terminal, historyFilePath, cliLinePredicate);
        this.history = new DefaultHistory(this.lineReader);
        this.prompt = DEFAULT_PROMPT;
    }

    @Override
    public Iterable<? extends History.Entry> getHistory() {
        return this.lineReader.getHistory();
    }

    @Override
    public String readLine() {
        String line = this.lineReader.readLine(this.prompt);
        this.addToHistory(line);
        return line;
    }

    private void addToHistory(String line) {
        try {
            this.history.add(line);
            this.history.save();
        }
        catch (IOException e) {
            LOGGER.error("Error saving history file", (Throwable)e);
            this.terminal.writer().println("Error saving history file:" + ErrorMessageUtil.buildErrorMessage((Throwable)e));
        }
    }

    private static org.jline.reader.LineReader build(Terminal terminal, Path historyFilePath, Predicate<String> cliLinePredicate) {
        DefaultParser parser = new DefaultParser();
        parser.setEofOnEscapedNewLine(true);
        parser.setQuoteChars(new char[]{'\''});
        parser.setEscapeChars(new char[]{'\\'});
        org.jline.reader.LineReader lineReader = LineReaderBuilder.builder().appName("KSQL").variable("secondary-prompt-pattern", (Object)">").option(LineReader.Option.HISTORY_IGNORE_DUPS, true).option(LineReader.Option.HISTORY_IGNORE_SPACE, false).option(LineReader.Option.HISTORY_INCREMENTAL, false).option(LineReader.Option.DISABLE_EVENT_EXPANSION, false).expander((Expander)new KsqlExpander()).parser((Parser)new TrimmingParser(new KsqlLineParser((Parser)parser, cliLinePredicate))).terminal(terminal).build();
        if (Files.exists(historyFilePath, new LinkOption[0]) || CliUtils.createFile(historyFilePath)) {
            lineReader.setVariable("history-file", (Object)historyFilePath);
            LOGGER.info("Command history saved at: " + historyFilePath);
        } else {
            terminal.writer().println(String.format("WARNING: Unable to create command history file '%s', command history will not be saved.", historyFilePath));
        }
        return lineReader;
    }

    private static class KsqlExpander
    extends DefaultExpander {
        private static final String EXPANDED_CS = "CREATE STREAM s (field1 type1 KEY, field2 type2) WITH (KAFKA_TOPIC='topic-name', FORMAT='json');";
        private static final String EXPANDED_CT = "CREATE TABLE t (field1 type1 PRIMARY KEY, field2 type2) WITH (KAFKA_TOPIC='topic-name', FORMAT='json');";
        private static final Map<String, String> shortcuts = ImmutableMap.of((Object)"cs", (Object)"CREATE STREAM s (field1 type1 KEY, field2 type2) WITH (KAFKA_TOPIC='topic-name', FORMAT='json');", (Object)"ct", (Object)"CREATE TABLE t (field1 type1 PRIMARY KEY, field2 type2) WITH (KAFKA_TOPIC='topic-name', FORMAT='json');", (Object)"csas", (Object)"CREATE STREAM s AS SELECT ", (Object)"ctas", (Object)"CREATE TABLE t AS SELECT ", (Object)"ii", (Object)"INSERT INTO x SELECT ");

        private KsqlExpander() {
        }

        public String expandHistory(History history, String line) {
            if (line.startsWith("!") || line.startsWith("^")) {
                return super.expandHistory(history, line);
            }
            return line;
        }

        public String expandVar(String word) {
            return shortcuts.getOrDefault(word.toLowerCase(), word);
        }
    }
}

