/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console;

public final class UnclosedQuoteChecker {
    private static final String COMMENT = "--";

    private UnclosedQuoteChecker() {
    }

    public static boolean isUnclosedQuote(String line) {
        int quoteStart = -1;
        for (int i = 0; i < line.length(); ++i) {
            if (quoteStart < 0 && UnclosedQuoteChecker.isQuoteChar(line, i)) {
                quoteStart = i;
                continue;
            }
            if (quoteStart >= 0 && UnclosedQuoteChecker.isTwoQuoteStart(line, i) && !UnclosedQuoteChecker.isEscaped(line, i)) {
                ++i;
                continue;
            }
            if (quoteStart < 0 || !UnclosedQuoteChecker.isQuoteChar(line, i) || UnclosedQuoteChecker.isEscaped(line, i)) continue;
            quoteStart = -1;
        }
        int commentInd = line.indexOf(COMMENT);
        if (commentInd < 0) {
            return quoteStart >= 0;
        }
        if (quoteStart < 0) {
            return false;
        }
        return commentInd > quoteStart;
    }

    private static boolean isQuoteChar(String line, int ind) {
        char c = line.charAt(ind);
        return c == '\'';
    }

    private static boolean isEscaped(String line, int ind) {
        if (ind == 0) {
            return false;
        }
        char c = line.charAt(ind - 1);
        return c == '\\' && !UnclosedQuoteChecker.isEscaped(line, ind - 1);
    }

    private static boolean isTwoQuoteStart(String line, int ind) {
        if (ind + 1 >= line.length()) {
            return false;
        }
        return UnclosedQuoteChecker.isQuoteChar(line, ind) && UnclosedQuoteChecker.isQuoteChar(line, ind + 1);
    }
}

