/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.cmd;

import io.confluent.ksql.cli.console.cmd.CliCmdUtil;
import io.confluent.ksql.cli.console.cmd.CliSpecificCommand;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;

final class SetCliProperty
implements CliSpecificCommand {
    private static final String HELP = "set cli <property> <value>:" + System.lineSeparator() + "\tSets a CLI local property. NOTE that this differs from setting a KSQL property with \"SET 'property'='value'\" in that it does not affect the server.";
    private final BiConsumer<String, String> setProperty;

    public static SetCliProperty create(BiConsumer<String, String> setProperty) {
        return new SetCliProperty(setProperty);
    }

    private SetCliProperty(BiConsumer<String, String> setProperty) {
        this.setProperty = Objects.requireNonNull(setProperty, "setProperty");
    }

    @Override
    public String getName() {
        return "set cli";
    }

    @Override
    public String getHelpMessage() {
        return HELP;
    }

    @Override
    public void execute(List<String> args, PrintWriter terminal) {
        CliCmdUtil.ensureArgCountBounds(args, 2, 2, this.getHelpMessage());
        this.setProperty.accept(args.get(0), args.get(1));
    }
}

