/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.table.builder;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.cli.console.table.Table;
import io.confluent.ksql.cli.console.table.builder.TableBuilder;
import io.confluent.ksql.rest.entity.VariablesList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ListVariablesTableBuilder
implements TableBuilder<VariablesList> {
    private static final List<String> HEADERS = ImmutableList.of((Object)"Variable Name", (Object)"Value");

    @Override
    public Table buildTable(VariablesList entity) {
        return new Table.Builder().withColumnHeaders(HEADERS).withRows(ListVariablesTableBuilder.defRowValues(entity.getVariables())).build();
    }

    private static List<List<String>> defRowValues(List<VariablesList.Variable> variables) {
        return variables.stream().sorted(Comparator.comparing(var -> var.getName())).map(var -> ImmutableList.of((Object)var.getName(), (Object)var.getValue())).collect(Collectors.toList());
    }
}

