/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CliUtils {
    private static final Logger log = LoggerFactory.getLogger(CliUtils.class);

    private CliUtils() {
    }

    public static boolean createFile(Path path) {
        try {
            Path parent = path.getParent();
            if (parent == null) {
                log.warn("Failed to create file as the parent was null. path: {}", (Object)path);
                return false;
            }
            Files.createDirectories(parent, new FileAttribute[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            return true;
        }
        catch (Exception e) {
            log.warn("createFile failed, path: {}", (Object)path, (Object)e);
            return false;
        }
    }
}

