/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.client;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.confluent.dekregistry.client.DekRegistryClient;
import io.confluent.dekregistry.client.rest.DekRegistryRestService;
import io.confluent.dekregistry.client.rest.entities.CreateDekRequest;
import io.confluent.dekregistry.client.rest.entities.CreateKekRequest;
import io.confluent.dekregistry.client.rest.entities.Dek;
import io.confluent.dekregistry.client.rest.entities.Kek;
import io.confluent.dekregistry.client.rest.entities.UpdateKekRequest;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;

public class CachedDekRegistryClient
extends CachedSchemaRegistryClient
implements DekRegistryClient {
    private final DekRegistryRestService restService;
    private final Cache<KekId, Kek> kekCache;
    private final Cache<DekId, Dek> dekCache;
    private final Ticker ticker;

    public CachedDekRegistryClient(List<String> baseUrls, int cacheCapacity, int cacheExpirySecs, Map<String, ?> configs, Map<String, String> httpHeaders) {
        this(new DekRegistryRestService(baseUrls), cacheCapacity, cacheExpirySecs, configs, httpHeaders, Ticker.systemTicker());
    }

    public CachedDekRegistryClient(DekRegistryRestService restService, int cacheCapacity, int cacheExpirySecs, Map<String, ?> configs, Map<String, String> httpHeaders) {
        this(restService, cacheCapacity, cacheExpirySecs, configs, httpHeaders, Ticker.systemTicker());
    }

    public CachedDekRegistryClient(DekRegistryRestService restService, int cacheCapacity, int cacheExpirySecs, Map<String, ?> configs, Map<String, String> httpHeaders, Ticker ticker) {
        super((RestService)restService, cacheCapacity, Collections.emptyList(), configs, httpHeaders, ticker);
        this.restService = restService;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize((long)cacheCapacity).ticker(ticker);
        if (cacheExpirySecs >= 0) {
            cacheBuilder = cacheBuilder.expireAfterWrite(Duration.ofSeconds(cacheExpirySecs));
        }
        this.kekCache = cacheBuilder.build();
        cacheBuilder = CacheBuilder.newBuilder().maximumSize((long)cacheCapacity).ticker(ticker);
        if (cacheExpirySecs >= 0) {
            cacheBuilder = cacheBuilder.expireAfterWrite(Duration.ofSeconds(cacheExpirySecs));
        }
        this.dekCache = cacheBuilder.build();
        this.ticker = ticker;
    }

    @Override
    public Ticker ticker() {
        return this.ticker;
    }

    @Override
    public List<String> listKeks(boolean lookupDeleted) throws IOException, RestClientException {
        return this.restService.listKeks(lookupDeleted);
    }

    @Override
    public List<String> listKeks(List<String> subjectPrefix, boolean lookupDeleted) throws IOException, RestClientException {
        return this.restService.listKeks(subjectPrefix, lookupDeleted);
    }

    public List<String> listKeksWithPagination(List<String> subjectPrefix, boolean lookupDeleted, int offset, int limit) throws IOException, RestClientException {
        return this.restService.listKeksWithPagination(subjectPrefix, lookupDeleted, offset, limit);
    }

    @Override
    public Kek getKek(String name, boolean lookupDeleted) throws IOException, RestClientException {
        try {
            return (Kek)this.kekCache.get((Object)new KekId(name, lookupDeleted), () -> this.restService.getKek(name, lookupDeleted));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof RestClientException) {
                throw (RestClientException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public List<String> listDeks(String kekName, boolean lookupDeleted) throws IOException, RestClientException {
        return this.restService.listDeks(kekName, lookupDeleted);
    }

    public List<String> listDeksWithPagination(String kekName, boolean lookupDeleted, int offset, int limit) throws IOException, RestClientException {
        return this.restService.listDeksWithPagination(kekName, lookupDeleted, offset, limit);
    }

    @Override
    public List<Integer> listDekVersions(String kekName, String subject, DekFormat algorithm, boolean lookupDeleted) throws IOException, RestClientException {
        return this.restService.listDekVersions(kekName, subject, algorithm, lookupDeleted);
    }

    public List<Integer> listDekVersionsWithPagination(String kekName, String subject, DekFormat algorithm, boolean lookupDeleted, int offset, int limit) throws IOException, RestClientException {
        return this.restService.listDekVersionsWithPagination(kekName, subject, algorithm, lookupDeleted, offset, limit);
    }

    @Override
    public Dek getDek(String kekName, String subject, DekFormat algorithm, boolean lookupDeleted) throws IOException, RestClientException {
        try {
            return (Dek)this.dekCache.get((Object)new DekId(kekName, subject, null, algorithm, lookupDeleted), () -> this.restService.getDek(kekName, subject, algorithm, lookupDeleted));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof RestClientException) {
                throw (RestClientException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public Dek getDekVersion(String kekName, String subject, int version, DekFormat algorithm, boolean lookupDeleted) throws IOException, RestClientException {
        try {
            return (Dek)this.dekCache.get((Object)new DekId(kekName, subject, version, algorithm, lookupDeleted), () -> this.restService.getDekVersion(kekName, subject, version, algorithm, lookupDeleted));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof RestClientException) {
                throw (RestClientException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public Dek getDekLatestVersion(String kekName, String subject, DekFormat algorithm, boolean lookupDeleted) throws IOException, RestClientException {
        try {
            return (Dek)this.dekCache.get((Object)new DekId(kekName, subject, -1, algorithm, lookupDeleted), () -> this.restService.getDekVersion(kekName, subject, -1, algorithm, lookupDeleted));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof RestClientException) {
                throw (RestClientException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public Kek createKek(String name, String kmsType, String kmsKeyId, Map<String, String> kmsProps, String doc, boolean shared) throws IOException, RestClientException {
        return this.createKek(DEFAULT_REQUEST_PROPERTIES, name, kmsType, kmsKeyId, kmsProps, doc, shared, false);
    }

    @Override
    public Kek createKek(String name, String kmsType, String kmsKeyId, Map<String, String> kmsProps, String doc, boolean shared, boolean deleted) throws IOException, RestClientException {
        return this.createKek(DEFAULT_REQUEST_PROPERTIES, name, kmsType, kmsKeyId, kmsProps, doc, shared, deleted);
    }

    public Kek createKek(Map<String, String> requestProperties, String name, String kmsType, String kmsKeyId, Map<String, String> kmsProps, String doc, boolean shared, boolean deleted) throws IOException, RestClientException {
        CreateKekRequest request = new CreateKekRequest();
        request.setName(name);
        request.setKmsType(kmsType);
        request.setKmsKeyId(kmsKeyId);
        request.setKmsProps(kmsProps);
        request.setDoc(doc);
        request.setShared(shared);
        request.setDeleted(deleted);
        Kek kek = this.restService.createKek(requestProperties, request);
        this.kekCache.put((Object)new KekId(name, deleted), (Object)kek);
        return kek;
    }

    @Override
    public Dek createDek(String kekName, String subject, DekFormat algorithm, String encryptedKeyMaterial) throws IOException, RestClientException {
        return this.createDek(DEFAULT_REQUEST_PROPERTIES, kekName, subject, null, algorithm, encryptedKeyMaterial, false);
    }

    @Override
    public Dek createDek(String kekName, String subject, int version, DekFormat algorithm, String encryptedKeyMaterial) throws IOException, RestClientException {
        return this.createDek(DEFAULT_REQUEST_PROPERTIES, kekName, subject, version, algorithm, encryptedKeyMaterial, false);
    }

    @Override
    public Dek createDek(String kekName, String subject, int version, DekFormat algorithm, String encryptedKeyMaterial, boolean deleted) throws IOException, RestClientException {
        return this.createDek(DEFAULT_REQUEST_PROPERTIES, kekName, subject, version, algorithm, encryptedKeyMaterial, deleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dek createDek(Map<String, String> requestProperties, String kekName, String subject, Integer version, DekFormat algorithm, String encryptedKeyMaterial, boolean deleted) throws IOException, RestClientException {
        CreateDekRequest request = new CreateDekRequest();
        request.setSubject(subject);
        request.setVersion(version);
        request.setAlgorithm(algorithm);
        request.setEncryptedKeyMaterial(encryptedKeyMaterial);
        request.setDeleted(deleted);
        try {
            Dek dek = this.restService.createDek(requestProperties, kekName, request);
            this.dekCache.put((Object)new DekId(kekName, subject, version, algorithm, deleted), (Object)dek);
            Dek dek2 = dek;
            return dek2;
        }
        finally {
            this.dekCache.invalidate((Object)new DekId(kekName, subject, -1, algorithm, false));
            this.dekCache.invalidate((Object)new DekId(kekName, subject, -1, algorithm, true));
        }
    }

    @Override
    public Kek updateKek(String name, Map<String, String> kmsProps, String doc, Boolean shared) throws IOException, RestClientException {
        return this.updateKek(DEFAULT_REQUEST_PROPERTIES, name, kmsProps, doc, shared);
    }

    public Kek updateKek(Map<String, String> requestProperties, String name, Map<String, String> kmsProps, String doc, Boolean shared) throws IOException, RestClientException {
        UpdateKekRequest request = new UpdateKekRequest();
        request.setKmsProps(kmsProps);
        request.setDoc(doc);
        request.setShared(shared);
        Kek kek = this.restService.updateKek(requestProperties, name, request);
        this.kekCache.put((Object)new KekId(name, false), (Object)kek);
        return kek;
    }

    @Override
    public void deleteKek(String kekName, boolean permanentDelete) throws IOException, RestClientException {
        this.deleteKek(DEFAULT_REQUEST_PROPERTIES, kekName, permanentDelete);
    }

    public void deleteKek(Map<String, String> requestProperties, String kekName, boolean permanentDelete) throws IOException, RestClientException {
        this.restService.deleteKek(requestProperties, kekName, permanentDelete);
        this.kekCache.invalidate((Object)new KekId(kekName, false));
        this.kekCache.invalidate((Object)new KekId(kekName, true));
    }

    @Override
    public void deleteDek(String kekName, String subject, DekFormat algorithm, boolean permanentDelete) throws IOException, RestClientException {
        this.deleteDek(DEFAULT_REQUEST_PROPERTIES, kekName, subject, algorithm, permanentDelete);
    }

    public void deleteDek(Map<String, String> requestProperties, String kekName, String subject, DekFormat algorithm, boolean permanentDelete) throws IOException, RestClientException {
        this.restService.deleteDek(requestProperties, kekName, subject, algorithm, permanentDelete);
        this.dekCache.invalidateAll();
    }

    @Override
    public void deleteDekVersion(String kekName, String subject, int version, DekFormat algorithm, boolean permanentDelete) throws IOException, RestClientException {
        this.deleteDekVersion(DEFAULT_REQUEST_PROPERTIES, kekName, subject, version, algorithm, permanentDelete);
    }

    public void deleteDekVersion(Map<String, String> requestProperties, String kekName, String subject, int version, DekFormat algorithm, boolean permanentDelete) throws IOException, RestClientException {
        this.restService.deleteDekVersion(requestProperties, kekName, subject, version, algorithm, permanentDelete);
        this.dekCache.invalidateAll();
    }

    @Override
    public void undeleteKek(String kekName) throws IOException, RestClientException {
        this.undeleteKek(DEFAULT_REQUEST_PROPERTIES, kekName);
    }

    public void undeleteKek(Map<String, String> requestProperties, String kekName) throws IOException, RestClientException {
        this.restService.undeleteKek(requestProperties, kekName);
        this.kekCache.invalidate((Object)new KekId(kekName, false));
        this.kekCache.invalidate((Object)new KekId(kekName, true));
    }

    @Override
    public void undeleteDek(String kekName, String subject, DekFormat algorithm) throws IOException, RestClientException {
        this.undeleteDek(DEFAULT_REQUEST_PROPERTIES, kekName, subject, algorithm);
    }

    public void undeleteDek(Map<String, String> requestProperties, String kekName, String subject, DekFormat algorithm) throws IOException, RestClientException {
        this.restService.undeleteDek(requestProperties, kekName, subject, algorithm);
        this.dekCache.invalidateAll();
    }

    @Override
    public void undeleteDekVersion(String kekName, String subject, int version, DekFormat algorithm) throws IOException, RestClientException {
        this.undeleteDekVersion(DEFAULT_REQUEST_PROPERTIES, kekName, subject, version, algorithm);
    }

    public void undeleteDekVersion(Map<String, String> requestProperties, String kekName, String subject, int version, DekFormat algorithm) throws IOException, RestClientException {
        this.restService.undeleteDekVersion(requestProperties, kekName, subject, version, algorithm);
        this.dekCache.invalidateAll();
    }

    @Override
    public void reset() {
        this.kekCache.invalidateAll();
        this.dekCache.invalidateAll();
    }

    public static class DekId {
        private final String kekName;
        private final String subject;
        private final Integer version;
        private final DekFormat dekFormat;
        private final boolean lookupDeleted;

        public DekId(String kekName, String subject, Integer version, DekFormat dekFormat, boolean lookupDeleted) {
            this.kekName = kekName;
            this.subject = subject;
            this.version = version;
            this.dekFormat = dekFormat;
            this.lookupDeleted = lookupDeleted;
        }

        public String getKekName() {
            return this.kekName;
        }

        public String getSubject() {
            return this.subject;
        }

        public Integer getVersion() {
            return this.version;
        }

        public DekFormat getDekFormat() {
            return this.dekFormat;
        }

        public boolean isLookupDeleted() {
            return this.lookupDeleted;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DekId dekId = (DekId)o;
            return this.lookupDeleted == dekId.lookupDeleted && Objects.equals(this.kekName, dekId.kekName) && Objects.equals(this.subject, dekId.subject) && Objects.equals(this.version, dekId.version) && this.dekFormat == dekId.dekFormat;
        }

        public int hashCode() {
            return Objects.hash(this.kekName, this.subject, this.version, this.dekFormat, this.lookupDeleted);
        }
    }

    public static class KekId {
        private final String name;
        private final boolean lookupDeleted;

        public KekId(String name, boolean lookupDeleted) {
            this.name = name;
            this.lookupDeleted = lookupDeleted;
        }

        public String getName() {
            return this.name;
        }

        public boolean isLookupDeleted() {
            return this.lookupDeleted;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KekId kekId = (KekId)o;
            return this.lookupDeleted == kekId.lookupDeleted && Objects.equals(this.name, kekId.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.lookupDeleted);
        }
    }
}

