/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.client;

import com.google.crypto.tink.Aead;
import io.confluent.dekregistry.client.DekRegistryClient;
import io.confluent.dekregistry.client.rest.entities.Dek;
import io.confluent.dekregistry.client.rest.entities.Kek;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.encryption.tink.Cryptor;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class MockDekRegistryClient
implements DekRegistryClient {
    public static final byte[] EMPTY_AAD = new byte[0];
    private final Map<String, ?> configs;
    private final Map<KekId, Kek> keks;
    private final Map<DekId, Dek> deks;
    private final Map<DekFormat, Cryptor> cryptors;

    public MockDekRegistryClient(Map<String, ?> configs) {
        this.configs = configs;
        this.keks = new ConcurrentHashMap<KekId, Kek>();
        this.deks = new ConcurrentHashMap<DekId, Dek>();
        this.cryptors = new ConcurrentHashMap<DekFormat, Cryptor>();
    }

    protected Cryptor getCryptor(DekFormat dekFormat) {
        return this.cryptors.computeIfAbsent(dekFormat, k -> {
            try {
                return new Cryptor(dekFormat);
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException("Invalid format " + dekFormat, e);
            }
        });
    }

    @Override
    public List<String> listKeks(boolean lookupDeleted) throws IOException, RestClientException {
        return this.listKeks(null, lookupDeleted);
    }

    @Override
    public List<String> listKeks(List<String> subjectPrefix, boolean lookupDeleted) throws IOException, RestClientException {
        if (subjectPrefix == null || subjectPrefix.isEmpty()) {
            return this.keks.entrySet().stream().filter(kv -> !((Kek)kv.getValue()).isDeleted() || lookupDeleted).map(kv -> ((KekId)kv.getKey()).getName()).collect(Collectors.toList());
        }
        return this.deks.entrySet().stream().filter(kv -> subjectPrefix.stream().anyMatch(prefix -> ((DekId)kv.getKey()).getSubject().startsWith((String)prefix)) && (!((Dek)kv.getValue()).isDeleted() || lookupDeleted)).map(kv -> ((DekId)kv.getKey()).getKekName()).sorted().distinct().collect(Collectors.toList());
    }

    @Override
    public List<Integer> listDekVersions(String kekName, String subject, DekFormat algorithm, boolean lookupDeleted) throws IOException, RestClientException {
        if (algorithm == null) {
            algorithm = DekFormat.AES256_GCM;
        }
        DekFormat algo = algorithm;
        return this.deks.entrySet().stream().filter(kv -> ((DekId)kv.getKey()).getKekName().equals(kekName) && ((DekId)kv.getKey()).getSubject().equals(subject) && ((Dek)kv.getValue()).getAlgorithm().equals((Object)algo) && (!((Dek)kv.getValue()).isDeleted() || lookupDeleted)).map(kv -> ((DekId)kv.getKey()).getVersion()).collect(Collectors.toList());
    }

    @Override
    public Kek getKek(String name, boolean lookupDeleted) throws IOException, RestClientException {
        KekId keyId = new KekId(name);
        Kek key = this.keks.get(keyId);
        if (key != null && (!key.isDeleted() || lookupDeleted)) {
            return key;
        }
        throw new RestClientException("Key not found", 404, 40470);
    }

    @Override
    public List<String> listDeks(String kekName, boolean lookupDeleted) throws IOException, RestClientException {
        return this.deks.entrySet().stream().filter(kv -> !((Dek)kv.getValue()).isDeleted() || lookupDeleted).map(kv -> ((DekId)kv.getKey()).getSubject()).collect(Collectors.toList());
    }

    @Override
    public Dek getDek(String kekName, String subject, DekFormat algorithm, boolean lookupDeleted) throws IOException, RestClientException {
        return this.getDekVersion(kekName, subject, 1, algorithm, lookupDeleted);
    }

    @Override
    public Dek getDekVersion(String kekName, String subject, int version, DekFormat algorithm, boolean lookupDeleted) throws IOException, RestClientException {
        DekId keyId;
        Dek key;
        if (version == -1) {
            return this.getDekLatestVersion(kekName, subject, algorithm, lookupDeleted);
        }
        if (algorithm == null) {
            algorithm = DekFormat.AES256_GCM;
        }
        if ((key = this.deks.get(keyId = new DekId(kekName, subject, version, algorithm))) != null && (!key.isDeleted() || lookupDeleted)) {
            key = this.maybeGenerateRawDek(key);
            return key;
        }
        throw new RestClientException("Key not found", 404, 40470);
    }

    @Override
    public Dek getDekLatestVersion(String kekName, String subject, DekFormat algorithm, boolean lookupDeleted) throws IOException, RestClientException {
        if (algorithm == null) {
            algorithm = DekFormat.AES256_GCM;
        }
        DekFormat algo = algorithm;
        List versions = this.deks.entrySet().stream().filter(kv -> ((DekId)kv.getKey()).getKekName().equals(kekName) && ((DekId)kv.getKey()).getSubject().equals(subject) && ((Dek)kv.getValue()).getAlgorithm().equals((Object)algo) && (!((Dek)kv.getValue()).isDeleted() || lookupDeleted)).map(kv -> ((DekId)kv.getKey()).getVersion()).sorted().collect(Collectors.toList());
        return versions.isEmpty() ? null : this.getDekVersion(kekName, subject, (Integer)versions.get(versions.size() - 1), algorithm, lookupDeleted);
    }

    @Override
    public Kek createKek(String name, String kmsType, String kmsKeyId, Map<String, String> kmsProps, String doc, boolean shared) throws IOException, RestClientException {
        return this.createKek(name, kmsType, kmsKeyId, kmsProps, doc, shared, false);
    }

    @Override
    public Kek createKek(String name, String kmsType, String kmsKeyId, Map<String, String> kmsProps, String doc, boolean shared, boolean deleted) throws IOException, RestClientException {
        KekId keyId = new KekId(name);
        Kek oldKey = this.keks.get(keyId);
        Kek key = new Kek(name, kmsType, kmsKeyId, kmsProps, doc, shared, System.currentTimeMillis(), deleted);
        if (!(oldKey == null || deleted != oldKey.isDeleted() && oldKey.equals(key))) {
            throw new RestClientException("Key " + name + " already exists", 409, 40972);
        }
        this.keks.put(keyId, key);
        return key;
    }

    @Override
    public Dek createDek(String kekName, String subject, DekFormat algorithm, String encryptedKeyMaterial) throws IOException, RestClientException {
        return this.createDek(kekName, subject, 1, algorithm, encryptedKeyMaterial, false);
    }

    @Override
    public Dek createDek(String kekName, String subject, int version, DekFormat algorithm, String encryptedKeyMaterial) throws IOException, RestClientException {
        return this.createDek(kekName, subject, version, algorithm, encryptedKeyMaterial, false);
    }

    @Override
    public Dek createDek(String kekName, String subject, int version, DekFormat algorithm, String encryptedKeyMaterial, boolean deleted) throws IOException, RestClientException {
        DekId keyId = new DekId(kekName, subject, version, algorithm);
        Dek oldKey = this.deks.get(keyId);
        Dek key = new Dek(kekName, subject, version, algorithm, encryptedKeyMaterial, null, System.currentTimeMillis(), deleted);
        if ((key = this.maybeGenerateEncryptedDek(key)).getEncryptedKeyMaterial() == null) {
            throw new RestClientException("Could not generate dek for " + subject, 500, 50070);
        }
        if (!(oldKey == null || deleted != oldKey.isDeleted() && oldKey.equals(key))) {
            throw new RestClientException("Key " + subject + " already exists", 409, 40972);
        }
        this.deks.put(keyId, key);
        key = this.maybeGenerateRawDek(key);
        return key;
    }

    protected Dek maybeGenerateEncryptedDek(Dek key) throws IOException, RestClientException {
        try {
            if (key.getEncryptedKeyMaterial() == null) {
                Kek kek = this.getKek(key.getKekName(), true);
                Aead aead = kek.toAead(this.configs);
                byte[] rawDek = this.getCryptor(key.getAlgorithm()).generateKey();
                byte[] encryptedDek = aead.encrypt(rawDek, EMPTY_AAD);
                String encryptedDekStr = new String(Base64.getEncoder().encode(encryptedDek), StandardCharsets.UTF_8);
                key = new Dek(key.getKekName(), key.getSubject(), key.getVersion(), key.getAlgorithm(), encryptedDekStr, null, key.getTimestamp(), key.isDeleted());
            }
            return key;
        }
        catch (GeneralSecurityException e) {
            return key;
        }
    }

    protected Dek maybeGenerateRawDek(Dek key) throws IOException, RestClientException {
        try {
            Kek kek = this.getKek(key.getKekName(), true);
            if (kek.isShared()) {
                Aead aead = kek.toAead(this.configs);
                byte[] encryptedDek = Base64.getDecoder().decode(key.getEncryptedKeyMaterial().getBytes(StandardCharsets.UTF_8));
                byte[] rawDek = aead.decrypt(encryptedDek, EMPTY_AAD);
                String rawDekStr = new String(Base64.getEncoder().encode(rawDek), StandardCharsets.UTF_8);
                key = new Dek(key.getKekName(), key.getSubject(), key.getVersion(), key.getAlgorithm(), key.getEncryptedKeyMaterial(), rawDekStr, key.getTimestamp(), key.isDeleted());
            }
            return key;
        }
        catch (GeneralSecurityException e) {
            return key;
        }
    }

    @Override
    public Kek updateKek(String name, Map<String, String> kmsProps, String doc, Boolean shared) throws IOException, RestClientException {
        KekId keyId = new KekId(name);
        Kek key = this.keks.get(keyId);
        if (key == null) {
            throw new RestClientException("Key not found", 404, 40470);
        }
        if (kmsProps == null) {
            kmsProps = key.getKmsProps();
        }
        if (doc == null) {
            doc = key.getDoc();
        }
        if (shared == null) {
            shared = key.isShared();
        }
        Kek newKey = new Kek(name, key.getKmsType(), key.getKmsKeyId(), kmsProps, doc, shared, System.currentTimeMillis(), false);
        this.keks.put(keyId, newKey);
        return key;
    }

    @Override
    public void deleteKek(String kekName, boolean permanentDelete) throws IOException, RestClientException {
        KekId keyId = new KekId(kekName);
        Kek key = this.keks.get(keyId);
        if (key == null) {
            return;
        }
        if (permanentDelete) {
            if (!key.isDeleted()) {
                throw new RestClientException("Key " + kekName + " was not deleted first before being permanently deleted", 404, 40471);
            }
            this.keks.remove(keyId);
        } else if (!key.isDeleted()) {
            Kek newKey = new Kek(kekName, key.getKmsType(), key.getKmsKeyId(), key.getKmsProps(), key.getDoc(), key.isShared(), System.currentTimeMillis(), true);
            this.keks.put(keyId, newKey);
        }
    }

    @Override
    public void deleteDek(String kekName, String subject, DekFormat algorithm, boolean permanentDelete) throws IOException, RestClientException {
        if (algorithm == null) {
            algorithm = DekFormat.AES256_GCM;
        }
        if (permanentDelete) {
            Dek dekInfo;
            DekId dekId;
            for (Map.Entry<DekId, Dek> entry : this.deks.entrySet()) {
                dekId = entry.getKey();
                dekInfo = entry.getValue();
                if (!dekId.getKekName().equals(kekName) || !dekId.getSubject().equals(subject) || !dekInfo.getAlgorithm().equals((Object)algorithm) || dekInfo.isDeleted()) continue;
                throw new RestClientException("Key " + dekId.getKekName() + " was not deleted first before being permanently deleted", 404, 40471);
            }
            Iterator<Map.Entry<DekId, Dek>> iter = this.deks.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<DekId, Dek> entry;
                entry = iter.next();
                dekId = entry.getKey();
                dekInfo = entry.getValue();
                if (!dekId.getKekName().equals(kekName) || !dekId.getSubject().equals(subject) || !dekInfo.getAlgorithm().equals((Object)algorithm)) continue;
                iter.remove();
            }
        } else {
            for (Map.Entry<DekId, Dek> entry : this.deks.entrySet()) {
                DekId dekId = entry.getKey();
                Dek dekInfo = entry.getValue();
                if (!dekId.getKekName().equals(kekName) || !dekId.getSubject().equals(subject) || !dekInfo.getAlgorithm().equals((Object)algorithm) || dekInfo.isDeleted()) continue;
                Dek newKey = new Dek(kekName, dekInfo.getSubject(), dekInfo.getVersion(), dekInfo.getAlgorithm(), dekInfo.getEncryptedKeyMaterial(), dekInfo.getKeyMaterial(), dekInfo.getTimestamp(), true);
                entry.setValue(newKey);
            }
        }
    }

    @Override
    public void deleteDekVersion(String kekName, String subject, int version, DekFormat algorithm, boolean permanentDelete) throws IOException, RestClientException {
        DekId keyId;
        Dek key;
        if (algorithm == null) {
            algorithm = DekFormat.AES256_GCM;
        }
        if ((key = this.deks.get(keyId = new DekId(kekName, subject, version, algorithm))) == null) {
            return;
        }
        if (permanentDelete) {
            if (!key.isDeleted()) {
                throw new RestClientException("Key " + key.getKekName() + " was not deleted first before being permanently deleted", 404, 40471);
            }
            this.deks.remove(keyId);
        } else if (!key.isDeleted()) {
            Dek newKey = new Dek(kekName, key.getSubject(), key.getVersion(), key.getAlgorithm(), key.getEncryptedKeyMaterial(), key.getKeyMaterial(), System.currentTimeMillis(), true);
            this.deks.put(keyId, newKey);
        }
    }

    @Override
    public void undeleteKek(String kekName) throws IOException, RestClientException {
        KekId keyId = new KekId(kekName);
        Kek key = this.keks.get(keyId);
        if (key == null) {
            return;
        }
        if (key.isDeleted()) {
            Kek newKey = new Kek(kekName, key.getKmsType(), key.getKmsKeyId(), key.getKmsProps(), key.getDoc(), key.isShared(), System.currentTimeMillis(), false);
            this.keks.put(keyId, newKey);
        }
    }

    @Override
    public void undeleteDek(String kekName, String subject, DekFormat algorithm) throws IOException, RestClientException {
        KekId keyId;
        Kek key;
        if (algorithm == null) {
            algorithm = DekFormat.AES256_GCM;
        }
        if ((key = this.keks.get(keyId = new KekId(kekName))) == null) {
            return;
        }
        if (key.isDeleted()) {
            throw new RestClientException("Key " + kekName + " must be undeleted first", 404, 40472);
        }
        for (Map.Entry<DekId, Dek> entry : this.deks.entrySet()) {
            DekId dekId = entry.getKey();
            Dek dekInfo = entry.getValue();
            if (!dekId.getKekName().equals(kekName) || !dekId.getSubject().equals(subject) || !dekInfo.getAlgorithm().equals((Object)algorithm) || dekInfo.isDeleted()) continue;
            Dek newKey = new Dek(kekName, dekInfo.getSubject(), dekInfo.getVersion(), dekInfo.getAlgorithm(), dekInfo.getEncryptedKeyMaterial(), dekInfo.getKeyMaterial(), dekInfo.getTimestamp(), false);
            entry.setValue(newKey);
        }
    }

    @Override
    public void undeleteDekVersion(String kekName, String subject, int version, DekFormat algorithm) throws IOException, RestClientException {
        KekId keyId;
        Kek key;
        if (algorithm == null) {
            algorithm = DekFormat.AES256_GCM;
        }
        if ((key = this.keks.get(keyId = new KekId(kekName))) == null) {
            return;
        }
        if (key.isDeleted()) {
            throw new RestClientException("Key " + kekName + " must be undeleted first", 404, 40472);
        }
        DekId id = new DekId(kekName, subject, version, algorithm);
        Dek oldKey = this.deks.get(id);
        if (oldKey == null) {
            return;
        }
        if (oldKey.isDeleted()) {
            Dek newKey = new Dek(kekName, oldKey.getSubject(), oldKey.getVersion(), oldKey.getAlgorithm(), oldKey.getEncryptedKeyMaterial(), oldKey.getKeyMaterial(), System.currentTimeMillis(), false);
            this.deks.put(id, newKey);
        }
    }

    @Override
    public void reset() {
        this.keks.clear();
        this.deks.clear();
        this.cryptors.clear();
    }

    static class DekId {
        private final String kekName;
        private final String subject;
        private final Integer version;
        private final DekFormat dekFormat;

        public DekId(String kekName, String subject, Integer version, DekFormat dekFormat) {
            this.kekName = kekName;
            this.subject = subject;
            this.version = version;
            this.dekFormat = dekFormat;
        }

        public String getKekName() {
            return this.kekName;
        }

        public String getSubject() {
            return this.subject;
        }

        public Integer getVersion() {
            return this.version;
        }

        public DekFormat getDekFormat() {
            return this.dekFormat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DekId that = (DekId)o;
            return Objects.equals(this.kekName, that.kekName) && Objects.equals(this.subject, that.subject) && Objects.equals(this.version, that.version) && this.dekFormat == that.dekFormat;
        }

        public int hashCode() {
            return Objects.hash(this.kekName, this.subject, this.version, this.dekFormat);
        }
    }

    static class KekId {
        private final String name;

        public KekId(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KekId that = (KekId)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

