/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Dek")
public class Dek {
    private final String kekName;
    private final String subject;
    private final int version;
    private final DekFormat algorithm;
    private final String encryptedKeyMaterial;
    private volatile String keyMaterial;
    private final Long timestamp;
    private final Boolean deleted;
    private volatile byte[] encryptedKeyMaterialBytes;
    private volatile byte[] keyMaterialBytes;

    @JsonCreator
    public Dek(@JsonProperty(value="kekName") String kekName, @JsonProperty(value="subject") String subject, @JsonProperty(value="version") int version, @JsonProperty(value="algorithm") DekFormat algorithm, @JsonProperty(value="encryptedKeyMaterial") String encryptedKeyMaterial, @JsonProperty(value="keyMaterial") String keyMaterial, @JsonProperty(value="ts") Long timestamp, @JsonProperty(value="deleted") Boolean deleted) {
        this.kekName = kekName;
        this.subject = subject;
        this.version = version;
        this.algorithm = algorithm;
        this.encryptedKeyMaterial = encryptedKeyMaterial;
        this.keyMaterial = keyMaterial;
        this.timestamp = timestamp;
        this.deleted = deleted;
    }

    @Schema(description="Kek name of the dek")
    @JsonProperty(value="kekName")
    public String getKekName() {
        return this.kekName;
    }

    @Schema(description="Subject of the dek")
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @Schema(description="Version of the dek")
    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    @Schema(description="Algorithm of the dek")
    @JsonProperty(value="algorithm")
    public DekFormat getAlgorithm() {
        return this.algorithm;
    }

    @Schema(description="Encrypted key material of the dek")
    @JsonProperty(value="encryptedKeyMaterial")
    public String getEncryptedKeyMaterial() {
        return this.encryptedKeyMaterial;
    }

    @Schema(description="Raw key material of the dek")
    @JsonProperty(value="keyMaterial")
    public String getKeyMaterial() {
        return this.keyMaterial;
    }

    @JsonProperty(value="keyMaterial")
    public void setKeyMaterial(byte[] keyMaterialBytes) {
        this.keyMaterial = keyMaterialBytes != null ? new String(Base64.getEncoder().encode(keyMaterialBytes), StandardCharsets.UTF_8) : null;
    }

    @Schema(description="Timestamp of the dek")
    @JsonProperty(value="ts")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Schema(description="Whether the dek is deleted")
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonIgnore
    public boolean isDeleted() {
        return Boolean.TRUE.equals(this.deleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public byte[] getEncryptedKeyMaterialBytes() {
        if (this.encryptedKeyMaterial == null) {
            return null;
        }
        if (this.encryptedKeyMaterialBytes == null) {
            Dek dek = this;
            synchronized (dek) {
                if (this.encryptedKeyMaterialBytes == null) {
                    this.encryptedKeyMaterialBytes = Base64.getDecoder().decode(this.encryptedKeyMaterial.getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        return this.encryptedKeyMaterialBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public byte[] getKeyMaterialBytes() {
        if (this.keyMaterial == null) {
            return null;
        }
        if (this.keyMaterialBytes == null) {
            Dek dek = this;
            synchronized (dek) {
                if (this.keyMaterialBytes == null) {
                    this.keyMaterialBytes = Base64.getDecoder().decode(this.keyMaterial.getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        return this.keyMaterialBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dek dek = (Dek)o;
        return this.version == dek.version && Objects.equals(this.kekName, dek.kekName) && Objects.equals(this.subject, dek.subject) && this.algorithm == dek.algorithm && Objects.equals(this.encryptedKeyMaterial, dek.encryptedKeyMaterial) && Objects.equals(this.keyMaterial, dek.keyMaterial);
    }

    public int hashCode() {
        return Objects.hash(this.kekName, this.subject, this.version, this.algorithm, this.encryptedKeyMaterial, this.keyMaterial);
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }
}

