/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.loader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.ksql.test.TestFrameworkException;
import io.confluent.ksql.test.loader.TestFile;
import io.confluent.ksql.test.tools.TestJsonMapper;
import io.confluent.ksql.tools.test.TestLoader;
import io.confluent.ksql.tools.test.model.Test;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JsonTestLoader<T extends Test>
implements TestLoader<T> {
    public static final ObjectMapper OBJECT_MAPPER = TestJsonMapper.INSTANCE.get();
    private final Path testDir;
    private final Class<? extends TestFile<T>> testFileType;

    public static <T extends Test> JsonTestLoader<T> of(Path testDir, Class<? extends TestFile<T>> testFileType) {
        return new JsonTestLoader<T>(testDir, testFileType);
    }

    private JsonTestLoader(Path testDir, Class<? extends TestFile<T>> testFileType) {
        this.testDir = Objects.requireNonNull(testDir, "testDir");
        this.testFileType = Objects.requireNonNull(testFileType, "testFileType");
    }

    public Stream<T> load() {
        List whiteList = TestLoader.getWhiteList();
        List<Path> testPaths = whiteList.isEmpty() ? this.loadTestPathsFromDirectory() : this.getTestPathsFromWhiteList(whiteList);
        String testRegex = System.getProperty("ksql.functional.test.regex");
        List testCases = testPaths.stream().flatMap(testPath -> JsonTestLoader.buildTests(testPath, this.testFileType)).filter(testCase -> testRegex == null || testCase.getName().matches(testRegex)).collect(Collectors.toList());
        JsonTestLoader.throwOnDuplicateNames(testCases);
        return testCases.stream();
    }

    private List<Path> getTestPathsFromWhiteList(List<String> whiteList) {
        return whiteList.stream().map(name -> this.testDir.resolve(name.trim())).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Path> loadTestPathsFromDirectory() {
        InputStream s = JsonTestLoader.class.getClassLoader().getResourceAsStream(this.testDir.toString());
        if (s == null) {
            throw new TestFrameworkException("Test directory not found: " + this.testDir);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(s, StandardCharsets.UTF_8));){
            String test;
            ArrayList<Path> tests = new ArrayList<Path>();
            while ((test = reader.readLine()) != null) {
                if (!test.endsWith(".json")) continue;
                tests.add(this.testDir.resolve(test));
            }
            ArrayList<Path> arrayList = tests;
            return arrayList;
        }
        catch (IOException e) {
            throw new TestFrameworkException("Failed to read test dir: " + this.testDir, e);
        }
    }

    /*
     * Exception decompiling
     */
    private static <TFT extends TestFile<T>, T extends Test> Stream<T> buildTests(Path testPath, Class<TFT> testFileType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputStream throwNotFoundIfNull(InputStream stream, Path testPath) {
        if (stream == null) {
            throw new TestFrameworkException("File not found: " + testPath);
        }
        return stream;
    }

    private static void throwOnDuplicateNames(List<? extends Test> testCases) {
        String duplicates = testCases.stream().collect(Collectors.groupingBy(Test::getName)).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(e -> "test name: '" + (String)e.getKey() + "' found in file: " + ((Test)((List)e.getValue()).get(0)).getTestLocation().toString()).collect(Collectors.joining(System.lineSeparator()));
        if (!duplicates.isEmpty()) {
            throw new IllegalStateException("There are tests with duplicate names: " + System.lineSeparator() + duplicates);
        }
    }
}

