/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.metastore.model.KsqlStream;
import io.confluent.ksql.metastore.model.KsqlTable;
import io.confluent.ksql.parser.SchemaParser;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.test.model.KeyFormatNode;
import io.confluent.ksql.test.model.matchers.MetaStoreMatchers;
import io.confluent.ksql.test.tools.exceptions.InvalidFieldException;
import io.confluent.ksql.test.utils.JsonParsingUtil;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;

@JsonDeserialize(using=Deserializer.class)
public final class SourceNode {
    private final String name;
    private final String type;
    private final Optional<String> schema;
    private final Optional<KeyFormatNode> keyFormat;
    private final Optional<String> valueFormat;
    private final Optional<Set<SerdeFeature>> keyFeatures;
    private final Optional<Set<SerdeFeature>> valueFeatures;
    private final Optional<Boolean> isSource;

    public SourceNode(String name, String type, Optional<String> schema, Optional<KeyFormatNode> keyFormat, Optional<String> valueFormat, Optional<Set<SerdeFeature>> keyFeatures, Optional<Set<SerdeFeature>> valueFeatures, Optional<Boolean> isSource) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        this.schema = Objects.requireNonNull(schema, "schema");
        this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
        this.valueFormat = Objects.requireNonNull(valueFormat, "valueFormat");
        this.keyFeatures = Objects.requireNonNull(keyFeatures, "keyFeatures");
        this.valueFeatures = Objects.requireNonNull(valueFeatures, "valueFeatures");
        this.isSource = Objects.requireNonNull(isSource, "isSource");
        if (this.name.isEmpty()) {
            throw new InvalidFieldException("name", "missing or empty");
        }
        this.build();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Optional<KeyFormatNode> getKeyFormat() {
        return this.keyFormat;
    }

    public Optional<String> getValueFormat() {
        return this.valueFormat;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Optional<Set<SerdeFeature>> getKeyFeatures() {
        return this.keyFeatures;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Optional<Set<SerdeFeature>> getValueFeatures() {
        return this.valueFeatures;
    }

    public Optional<Boolean> getIsSource() {
        return this.isSource;
    }

    Matcher<? super DataSource> build() {
        if (this.name.isEmpty()) {
            throw new InvalidFieldException("name", "missing or empty");
        }
        Matcher<DataSource> nameMatcher = MetaStoreMatchers.hasName(this.name);
        Matcher typeMatcher = IsInstanceOf.instanceOf(SourceNode.toType(this.type));
        Matcher schemaMatcher = this.schema.map(SourceNode::parseSchema).map(Matchers::is).map(MetaStoreMatchers::hasSchema).orElse(null);
        Matcher keyFmtMatcher = this.keyFormat.map(KeyFormatNode::build).map(MetaStoreMatchers::hasKeyFormat).orElse(null);
        Matcher valueFmtMatcher = this.valueFormat.map(Matchers::is).map(MetaStoreMatchers::hasValueFormat).orElse(null);
        Matcher keyFeatsMatcher = this.keyFeatures.map(features -> Matchers.containsInAnyOrder((Object[])features.toArray())).map(MetaStoreMatchers::hasKeySerdeFeatures).orElse(null);
        Matcher valFeatsMatcher = this.valueFeatures.map(features -> Matchers.containsInAnyOrder((Object[])features.toArray())).map(MetaStoreMatchers::hasValueSerdeFeatures).orElse(null);
        Matcher isSourceMatcher = this.isSource.map(Matchers::is).map(MetaStoreMatchers::isSourceMatches).orElse(null);
        Matcher[] matchers = (Matcher[])Stream.of(nameMatcher, typeMatcher, schemaMatcher, keyFmtMatcher, valueFmtMatcher, keyFeatsMatcher, valFeatsMatcher, isSourceMatcher).filter(Objects::nonNull).toArray(Matcher[]::new);
        return Matchers.allOf((Matcher[])matchers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceNode that = (SourceNode)o;
        return this.name.equals(that.name) && this.type.equals(that.type) && this.schema.equals(that.schema) && this.keyFormat.equals(that.keyFormat) && this.keyFeatures.equals(that.keyFeatures) && this.valueFormat.equals(that.valueFormat) && this.valueFeatures.equals(that.valueFeatures) && this.isSource.equals(that.isSource);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.schema, this.keyFormat, this.valueFormat, this.keyFeatures, this.valueFeatures, this.isSource);
    }

    private static Class<? extends DataSource> toType(String type) {
        switch (type.toUpperCase()) {
            case "STREAM": {
                return KsqlStream.class;
            }
            case "TABLE": {
                return KsqlTable.class;
            }
        }
        throw new InvalidFieldException("type", "must be either STREAM or TABLE");
    }

    private static LogicalSchema parseSchema(String text) {
        return SchemaParser.parse((String)text, (TypeRegistry)TypeRegistry.EMPTY).toLogicalSchema();
    }

    public static SourceNode fromDataSource(DataSource dataSource) {
        return new SourceNode(dataSource.getName().text(), dataSource.getDataSourceType().getKsqlType(), Optional.of(dataSource.getSchema().toString()), Optional.of(KeyFormatNode.fromKeyFormat(dataSource.getKsqlTopic().getKeyFormat())), Optional.of(dataSource.getKsqlTopic().getValueFormat().getFormatInfo().getFormat()), Optional.of(dataSource.getKsqlTopic().getKeyFormat().getFeatures().all()), Optional.of(dataSource.getKsqlTopic().getValueFormat().getFeatures().all()), Optional.of(dataSource.isSource()));
    }

    public static class Deserializer
    extends JsonDeserializer<SourceNode> {
        public SourceNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            String name = JsonParsingUtil.getRequired("name", node, jp, String.class);
            String type = JsonParsingUtil.getRequired("type", node, jp, String.class);
            Optional<String> rawSchema = JsonParsingUtil.getOptional("schema", node, jp, String.class);
            Optional<KeyFormatNode> keyFormat = JsonParsingUtil.getOptional("keyFormat", node, jp, KeyFormatNode.class);
            Optional<String> valueFormat = JsonParsingUtil.getOptional("valueFormat", node, jp, String.class);
            Optional<Set<SerdeFeature>> keyFeatures = JsonParsingUtil.getOptional("keyFeatures", node, jp, new TypeReference<Set<SerdeFeature>>(){});
            Optional<Set<SerdeFeature>> valueFeatures = JsonParsingUtil.getOptional("valueFeatures", node, jp, new TypeReference<Set<SerdeFeature>>(){});
            Optional<Boolean> isSource = JsonParsingUtil.getOptional("isSource", node, jp, Boolean.class);
            return new SourceNode(name, type, rawSchema, keyFormat, valueFormat, keyFeatures, valueFeatures, isSource);
        }
    }
}

