/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;

public final class WindowData {
    public final long start;
    public final long end;
    public final Type type;

    public WindowData(@JsonProperty(value="start") long start, @JsonProperty(value="end") long end, @JsonProperty(value="type") String type) {
        this.start = start;
        this.end = end;
        this.type = Type.valueOf(Objects.requireNonNull(type, "type").toUpperCase());
    }

    public WindowData(Windowed<?> windowed) {
        this(windowed.window().start(), windowed.window().end(), windowed.window() instanceof SessionWindow ? Type.SESSION.toString() : Type.TIME.toString());
    }

    public long size() {
        return this.end - this.start;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowData that = (WindowData)o;
        return this.start == that.start && this.end == that.end && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.start, this.end, this.type});
    }

    public static enum Type {
        SESSION,
        TIME;

    }
}

