/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model.matchers;

import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.SerdeFeature;
import java.util.Set;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class MetaStoreMatchers {
    private MetaStoreMatchers() {
    }

    public static Matcher<DataSource> hasName(String name) {
        return new FeatureMatcher<DataSource, SourceName>(Matchers.is((Object)SourceName.of((String)name)), "source with name", "name"){

            protected SourceName featureValueOf(DataSource actual) {
                return actual.getName();
            }
        };
    }

    public static Matcher<DataSource> hasSchema(Matcher<LogicalSchema> schemaMatcher) {
        return new FeatureMatcher<DataSource, LogicalSchema>(schemaMatcher, "source with schema", "schema"){

            protected LogicalSchema featureValueOf(DataSource actual) {
                return actual.getSchema();
            }
        };
    }

    public static Matcher<DataSource> hasKeyFormat(Matcher<? super KeyFormat> matcher) {
        return new FeatureMatcher<DataSource, KeyFormat>(matcher, "source with key format", "key format"){

            protected KeyFormat featureValueOf(DataSource actual) {
                return actual.getKsqlTopic().getKeyFormat();
            }
        };
    }

    public static Matcher<DataSource> hasValueFormat(Matcher<? super String> matcher) {
        return new FeatureMatcher<DataSource, String>(matcher, "source with value format", "value format"){

            protected String featureValueOf(DataSource actual) {
                return actual.getKsqlTopic().getValueFormat().getFormatInfo().getFormat();
            }
        };
    }

    public static Matcher<DataSource> hasKeySerdeFeatures(Matcher<? super Iterable<? super SerdeFeature>> expected) {
        return new FeatureMatcher<DataSource, Set<SerdeFeature>>(expected, "source with key serde features", "key serde features"){

            protected Set<SerdeFeature> featureValueOf(DataSource actual) {
                return actual.getKsqlTopic().getKeyFormat().getFeatures().all();
            }
        };
    }

    public static Matcher<DataSource> hasValueSerdeFeatures(Matcher<? super Iterable<? super SerdeFeature>> expected) {
        return new FeatureMatcher<DataSource, Set<SerdeFeature>>(expected, "source with value serde features", "value serde features"){

            protected Set<SerdeFeature> featureValueOf(DataSource actual) {
                return actual.getKsqlTopic().getValueFormat().getFeatures().all();
            }
        };
    }

    public static Matcher<DataSource> isSourceMatches(Matcher<? super Boolean> matcher) {
        return new FeatureMatcher<DataSource, Boolean>(matcher, "source type", "isSource"){

            protected Boolean featureValueOf(DataSource actual) {
                return actual.isSource();
            }
        };
    }
}

