/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.schema.query.QuerySchemas;
import io.confluent.ksql.test.model.KsqlVersion;
import io.confluent.ksql.test.tools.Record;
import io.confluent.ksql.test.tools.TopologyAndConfigs;
import io.confluent.ksql.test.tools.VersionBounds;
import io.confluent.ksql.test.tools.VersionedTest;
import io.confluent.ksql.test.tools.conditions.PostConditions;
import io.confluent.ksql.test.utils.ImmutableCollections;
import io.confluent.ksql.tools.test.model.TestLocation;
import io.confluent.ksql.tools.test.model.Topic;
import io.confluent.ksql.util.KsqlConfig;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hamcrest.Matcher;

public class TestCase
implements VersionedTest {
    private final TestLocation location;
    private final Path originalFileName;
    private final String name;
    private final VersionBounds versionBounds;
    private final Map<String, Object> properties;
    private final Collection<Topic> topics;
    private final List<Record> inputRecords;
    private final List<Record> outputRecords;
    private final List<String> statements;
    private final Optional<Matcher<Throwable>> expectedException;
    private List<String> generatedTopologies;
    private Map<String, QuerySchemas.SchemaInfo> generatedSchemas;
    private final Optional<TopologyAndConfigs> expectedTopology;
    private final PostConditions postConditions;

    public TestCase(TestLocation location, Path originalFileName, String name, VersionBounds versionBounds, Map<String, Object> properties, Collection<Topic> topics, List<Record> inputRecords, List<Record> outputRecords, List<String> statements, Optional<Matcher<Throwable>> expectedException, PostConditions postConditions) {
        this(location, originalFileName, name, versionBounds, properties, topics, inputRecords, outputRecords, statements, expectedException, postConditions, Optional.empty());
    }

    private TestCase(TestLocation location, Path originalFileName, String name, VersionBounds versionBounds, Map<String, Object> properties, Collection<Topic> topics, List<Record> inputRecords, List<Record> outputRecords, List<String> statements, Optional<Matcher<Throwable>> expectedException, PostConditions postConditions, Optional<TopologyAndConfigs> expectedTopology) {
        this.topics = ImmutableCollections.immutableCopyOf(topics);
        this.originalFileName = Objects.requireNonNull(originalFileName, "originalFileName");
        this.inputRecords = ImmutableList.copyOf(inputRecords);
        this.outputRecords = ImmutableList.copyOf(outputRecords);
        this.location = Objects.requireNonNull(location, "location");
        this.name = name;
        this.versionBounds = Objects.requireNonNull(versionBounds, "versionBounds");
        this.properties = ImmutableMap.copyOf(properties);
        this.statements = ImmutableList.copyOf(statements);
        this.expectedException = Objects.requireNonNull(expectedException, "expectedException");
        this.expectedTopology = Objects.requireNonNull(expectedTopology, "expectedTopology");
        this.postConditions = Objects.requireNonNull(postConditions, "postConditions");
    }

    @Override
    public VersionBounds getVersionBounds() {
        return this.versionBounds;
    }

    @Override
    public TestCase withExpectedTopology(KsqlVersion version, TopologyAndConfigs expectedTopology) {
        if (!this.versionBounds.contains(version)) {
            throw new IllegalArgumentException("Test does not support supplied version: " + version);
        }
        String newName = this.name + "-" + version.getName() + (version.getTimestamp().isPresent() ? "-" + version.getTimestamp().getAsLong() : "");
        TestCase copy = new TestCase(this.location, this.originalFileName, newName, this.versionBounds, this.properties, this.topics, this.inputRecords, this.outputRecords, this.statements, this.expectedException, this.postConditions, Optional.of(expectedTopology));
        copy.generatedTopologies = this.generatedTopologies;
        copy.generatedSchemas = this.generatedSchemas;
        return copy;
    }

    public String getName() {
        return this.name;
    }

    public TestLocation getTestLocation() {
        return this.location;
    }

    public Path getOriginalFileName() {
        return this.originalFileName;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="topics is ImmutableCollection")
    public Collection<Topic> getTopics() {
        return this.topics;
    }

    public void setGeneratedTopologies(List<String> generatedTopology) {
        this.generatedTopologies = ImmutableList.copyOf((Collection)Objects.requireNonNull(generatedTopology, "generatedTopology"));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="generatedTopologies is ImmutableList")
    public List<String> getGeneratedTopologies() {
        return this.generatedTopologies;
    }

    public Optional<TopologyAndConfigs> getExpectedTopology() {
        return this.expectedTopology;
    }

    public void setGeneratedSchemas(Map<String, QuerySchemas.SchemaInfo> generatedSchemas) {
        this.generatedSchemas = ImmutableMap.copyOf(Objects.requireNonNull(generatedSchemas, "generatedSchemas"));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="generatedSchemas is ImmutableMap")
    public Map<String, QuerySchemas.SchemaInfo> getGeneratedSchemas() {
        return this.generatedSchemas;
    }

    public KsqlConfig applyPersistedProperties(KsqlConfig systemConfig) {
        Map persistedConfigs = this.expectedTopology.map(TopologyAndConfigs::getConfigs).orElseGet(HashMap::new);
        return persistedConfigs.isEmpty() ? systemConfig : systemConfig.overrideBreakingConfigsWithOriginalValues(persistedConfigs);
    }

    private KsqlConfig applyPropertyOverrides(KsqlConfig sourceConfig) {
        return sourceConfig.cloneWithPropertyOverwrite(this.properties);
    }

    public KsqlConfig applyProperties(KsqlConfig systemConfig) {
        return this.applyPropertyOverrides(this.applyPersistedProperties(systemConfig));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="properties is ImmutableMap")
    public Map<String, Object> properties() {
        return this.properties;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="statements is ImmutableList")
    public List<String> statements() {
        return this.statements;
    }

    public PostConditions getPostConditions() {
        return this.postConditions;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="inputRecords is ImmutableList")
    public List<Record> getInputRecords() {
        return this.inputRecords;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="outputRecords is ImmutableList")
    public List<Record> getOutputRecords() {
        return this.outputRecords;
    }

    public Optional<Matcher<Throwable>> expectedException() {
        return this.expectedException;
    }
}

