/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.InternalFunctionRegistry;
import io.confluent.ksql.function.MutableFunctionRegistry;
import io.confluent.ksql.function.UdfLoaderUtil;
import io.confluent.ksql.internal.KsqlEngineMetrics;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.metastore.MetaStoreImpl;
import io.confluent.ksql.metastore.MutableMetaStore;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.query.id.QueryIdGenerator;
import io.confluent.ksql.query.id.SequentialQueryIdGenerator;
import io.confluent.ksql.schema.query.QuerySchemas;
import io.confluent.ksql.schema.registry.SchemaRegistryUtil;
import io.confluent.ksql.services.DefaultConnectClient;
import io.confluent.ksql.services.DefaultServiceContext;
import io.confluent.ksql.services.DisabledKsqlClient;
import io.confluent.ksql.services.KafkaConsumerGroupClient;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.test.model.PostConditionsNode;
import io.confluent.ksql.test.model.SchemaNode;
import io.confluent.ksql.test.model.SourceNode;
import io.confluent.ksql.test.model.TestHeader;
import io.confluent.ksql.test.model.WindowData;
import io.confluent.ksql.test.tools.ExpectedRecordComparator;
import io.confluent.ksql.test.tools.Record;
import io.confluent.ksql.test.tools.TestCase;
import io.confluent.ksql.test.tools.TestExecutionListener;
import io.confluent.ksql.test.tools.TestExecutorUtil;
import io.confluent.ksql.test.tools.TestJsonMapper;
import io.confluent.ksql.test.tools.TopicInfoCache;
import io.confluent.ksql.test.tools.TopologyTestDriverContainer;
import io.confluent.ksql.test.tools.stubs.StubKafkaService;
import io.confluent.ksql.test.utils.TestUtils;
import io.confluent.ksql.tools.test.TestFunctionRegistry;
import io.confluent.ksql.tools.test.model.Topic;
import io.confluent.ksql.tools.test.stubs.StubKafkaClientSupplier;
import io.confluent.ksql.tools.test.stubs.StubKafkaConsumerGroupClient;
import io.confluent.ksql.tools.test.stubs.StubKafkaTopicClient;
import io.confluent.ksql.util.BytesUtils;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlServerException;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.test.TestRecord;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;
import org.junit.matchers.JUnitMatchers;

public class TestExecutor
implements Closeable {
    private static final ImmutableMap<String, Object> BASE_CONFIG = ImmutableMap.builder().put((Object)"bootstrap.servers", (Object)"localhost:0").put((Object)"auto.commit.interval.ms", (Object)0).put((Object)"auto.offset.reset", (Object)"earliest").put((Object)"cache.max.bytes.buffering", (Object)0).put((Object)"ksql.service.id", (Object)"some.ksql.service.id").put((Object)"ksql.headers.columns.enabled", (Object)true).put((Object)"ksql.schema.registry.url", (Object)"schema_registry.url:0").build();
    private final ServiceContext serviceContext;
    private final KsqlEngine ksqlEngine;
    private final Map<String, ?> config = TestExecutor.baseConfig();
    private final StubKafkaService kafka;
    private final TopologyBuilder topologyBuilder;
    private final boolean validateResults;
    private final TopicInfoCache topicInfoCache;

    public static TestExecutor create(boolean validateResults, Optional<String> extensionDir) {
        StubKafkaService kafkaService = StubKafkaService.create();
        StubKafkaClientSupplier kafkaClientSupplier = new StubKafkaClientSupplier();
        ServiceContext serviceContext = TestExecutor.getServiceContext(kafkaClientSupplier);
        return new TestExecutor(kafkaService, serviceContext, TestExecutor.getKsqlEngine(serviceContext, extensionDir), TestExecutorUtil::buildStreamsTopologyTestDrivers, validateResults);
    }

    @VisibleForTesting
    TestExecutor(StubKafkaService kafka, ServiceContext serviceContext, KsqlEngine ksqlEngine, TopologyBuilder topologyBuilder, boolean validateResults) {
        this.kafka = Objects.requireNonNull(kafka, "stubKafkaService");
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.ksqlEngine = Objects.requireNonNull(ksqlEngine, "ksqlEngine");
        this.topologyBuilder = Objects.requireNonNull(topologyBuilder, "topologyBuilder");
        this.validateResults = validateResults;
        this.topicInfoCache = new TopicInfoCache((KsqlExecutionContext)ksqlEngine, serviceContext.getSchemaRegistryClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildAndExecuteQuery(TestCase testCase, TestExecutionListener listener) {
        this.topicInfoCache.clear();
        KsqlConfig ksqlConfig = testCase.applyPersistedProperties(new KsqlConfig(this.config));
        List<TopologyTestDriverContainer> topologyTestDrivers = null;
        try {
            System.setProperty("ksql.test.track.serde.topics", "true");
            this.maybeRegisterTopicSchemas(testCase.getTopics());
            topologyTestDrivers = this.topologyBuilder.buildStreamsTopologyTestDrivers(testCase, this.serviceContext, this.ksqlEngine, ksqlConfig, this.kafka, listener);
            this.writeInputIntoTopics(testCase, this.kafka);
            Set inputTopics = testCase.getInputRecords().stream().map(Record::getTopicName).collect(Collectors.toSet());
            for (TopologyTestDriverContainer topologyTestDriverContainer : topologyTestDrivers) {
                if (this.validateResults) {
                    TestExecutor.verifyTopology(testCase);
                }
                Set topicsFromInput = topologyTestDriverContainer.getSourceTopicNames().stream().filter(inputTopics::contains).collect(Collectors.toSet());
                Set topicsFromKafka = topologyTestDriverContainer.getSourceTopicNames().stream().filter(topicName -> !inputTopics.contains(topicName)).collect(Collectors.toSet());
                if (!topicsFromInput.isEmpty()) {
                    this.pipeRecordsFromProvidedInput(testCase, topologyTestDriverContainer);
                }
                for (String kafkaTopic : topicsFromKafka) {
                    this.pipeRecordsFromKafka(kafkaTopic, topologyTestDriverContainer);
                }
                topologyTestDriverContainer.getTopologyTestDriver().producedTopicNames().forEach(this.topicInfoCache::get);
            }
            this.verifyOutput(testCase);
            testCase.expectedException().map(ee -> {
                throw new AssertionError((Object)("Expected test to throw" + StringDescription.toString((SelfDescribing)ee)));
            });
            this.kafka.getAllTopics().stream().map(Topic::getName).forEach(this.topicInfoCache::get);
            List<PostConditionsNode.PostTopicNode> knownTopics = this.topicInfoCache.all().stream().map(ti -> {
                Topic topic = this.kafka.getTopic(ti.getTopicName());
                OptionalInt partitions = topic == null ? OptionalInt.empty() : OptionalInt.of(topic.getNumPartitions());
                Optional keyMetadata = SchemaRegistryUtil.getLatestSchema((SchemaRegistryClient)this.serviceContext.getSchemaRegistryClient(), (String)ti.getTopicName(), (boolean)true);
                Optional valueMetadata = SchemaRegistryUtil.getLatestSchema((SchemaRegistryClient)this.serviceContext.getSchemaRegistryClient(), (String)ti.getTopicName(), (boolean)false);
                return new PostConditionsNode.PostTopicNode(ti.getTopicName(), ti.getKeyFormat(), ti.getValueFormat(), partitions, Optional.ofNullable(topic).flatMap(Topic::getKeySchemaId), Optional.ofNullable(topic).flatMap(Topic::getValueSchemaId), TestExecutor.fromSchemaMetadata(keyMetadata), TestExecutor.fromSchemaMetadata(valueMetadata));
            }).collect(Collectors.toList());
            List<SourceNode> knownSources = this.ksqlEngine.getMetaStore().getAllDataSources().values().stream().map(SourceNode::fromDataSource).collect(Collectors.toList());
            if (this.validateResults) {
                testCase.getPostConditions().verify(this.ksqlEngine.getMetaStore(), knownTopics);
            }
            listener.runComplete(knownTopics, knownSources);
        }
        catch (RuntimeException e) {
            try {
                Optional<Matcher<Throwable>> expectedExceptionMatcher = testCase.expectedException();
                if (!expectedExceptionMatcher.isPresent()) {
                    throw e;
                }
                MatcherAssert.assertThat((Object)e, (Matcher)JUnitMatchers.isThrowable(expectedExceptionMatcher.get()));
            }
            catch (Throwable throwable) {
                System.clearProperty("ksql.test.track.serde.topics");
                if (topologyTestDrivers != null) {
                    for (TopologyTestDriverContainer topologyTestDriverContainer : topologyTestDrivers) {
                        topologyTestDriverContainer.close();
                    }
                }
                throw throwable;
            }
            System.clearProperty("ksql.test.track.serde.topics");
            if (topologyTestDrivers != null) {
                for (TopologyTestDriverContainer topologyTestDriverContainer : topologyTestDrivers) {
                    topologyTestDriverContainer.close();
                }
            }
        }
        System.clearProperty("ksql.test.track.serde.topics");
        if (topologyTestDrivers != null) {
            for (TopologyTestDriverContainer topologyTestDriverContainer : topologyTestDrivers) {
                topologyTestDriverContainer.close();
            }
        }
    }

    private void maybeRegisterTopicSchemas(Collection<Topic> topics) {
        SchemaRegistryClient schemaRegistryClient = this.serviceContext.getSchemaRegistryClient();
        boolean firstVersion = true;
        for (Topic topic : topics) {
            try {
                if (topic.getKeySchemaId().isPresent() && topic.getKeySchema().isPresent()) {
                    schemaRegistryClient.register(KsqlConstants.getSRSubject((String)topic.getName(), (boolean)true), (ParsedSchema)topic.getKeySchema().get(), 1, ((Integer)topic.getKeySchemaId().get()).intValue());
                }
                if (!topic.getValueSchemaId().isPresent() || !topic.getValueSchema().isPresent()) continue;
                schemaRegistryClient.register(KsqlConstants.getSRSubject((String)topic.getName(), (boolean)false), (ParsedSchema)topic.getValueSchema().get(), 1, ((Integer)topic.getValueSchemaId().get()).intValue());
            }
            catch (Exception e) {
                throw new KsqlException((Throwable)e);
            }
        }
    }

    private static JsonNode fromSchemaMetadata(Optional<SchemaMetadata> metadata) {
        if (!metadata.isPresent()) {
            return NullNode.getInstance();
        }
        if ("PROTOBUF".equals(metadata.get().getSchemaType())) {
            return JsonNodeFactory.instance.textNode(metadata.get().getSchema());
        }
        try {
            return TestJsonMapper.INSTANCE.get().readTree(metadata.get().getSchema());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.serviceContext.close();
        this.ksqlEngine.close();
    }

    private void verifyOutput(TestCase testCase) {
        boolean ranWithInsertStatements = testCase.getInputRecords().size() == 0;
        Map<String, List<Record>> expectedByTopic = testCase.getOutputRecords().stream().collect(Collectors.groupingBy(Record::getTopicName));
        Map actualByTopic = expectedByTopic.keySet().stream().collect(Collectors.toMap(Function.identity(), this.kafka::readRecords));
        expectedByTopic.forEach((kafkaTopic, expectedRecords) -> {
            TopicInfoCache.TopicInfo topicInfo = this.topicInfoCache.get((String)kafkaTopic).orElseThrow(() -> new KsqlException("No information found for topic: " + kafkaTopic));
            List<ProducerRecord<?, ?>> actualRecords = ((List)actualByTopic.getOrDefault(kafkaTopic, (List)ImmutableList.of())).stream().map(rec -> this.deserialize((ProducerRecord<byte[], byte[]>)rec, topicInfo, testCase.properties())).collect(Collectors.toList());
            if (this.validateResults) {
                TestExecutor.validateTopicData(kafkaTopic, expectedRecords, actualRecords, ranWithInsertStatements);
            }
        });
    }

    private ProducerRecord<?, ?> deserialize(ProducerRecord<byte[], byte[]> rec, TopicInfoCache.TopicInfo topicInfo, Map<String, Object> properties) {
        Object value;
        Object key;
        try {
            key = topicInfo.getKeyDeserializer(properties).deserialize(rec.topic(), (byte[])rec.key());
        }
        catch (Exception e) {
            throw new AssertionError("Failed to deserialize key: " + e.getMessage() + System.lineSeparator() + "rec: " + rec, e);
        }
        try {
            value = topicInfo.getValueDeserializer(properties).deserialize(rec.topic(), (byte[])rec.value());
        }
        catch (Exception e) {
            throw new AssertionError("Failed to deserialize value: " + e.getMessage() + System.lineSeparator() + "rec: " + rec, e);
        }
        return new ProducerRecord(rec.topic(), rec.partition(), rec.timestamp(), key, value, (Iterable)rec.headers());
    }

    private ProducerRecord<byte[], byte[]> serialize(Map<String, Object> properties, ProducerRecord<?, ?> rec) {
        byte[] value;
        byte[] key;
        TopicInfoCache.TopicInfo topicInfo = this.topicInfoCache.get(rec.topic()).orElseThrow(() -> new KsqlException("No information found for topic: " + rec.topic()));
        try {
            key = topicInfo.getKeySerializer(properties).serialize(rec.topic(), rec.key());
        }
        catch (Exception e) {
            throw new AssertionError("Failed to serialize key: " + e.getMessage() + System.lineSeparator() + "rec: " + rec, e);
        }
        try {
            value = topicInfo.getValueSerializer(properties).serialize(rec.topic(), rec.value());
        }
        catch (Exception e) {
            throw new AssertionError("Failed to serialize value: " + e.getMessage() + System.lineSeparator() + "rec: " + rec, e);
        }
        return new ProducerRecord(rec.topic(), rec.partition(), rec.timestamp(), (Object)key, (Object)value, (Iterable)rec.headers());
    }

    private static void validateTopicData(String topicName, List<Record> expected, Collection<ProducerRecord<?, ?>> actual, boolean ranWithInsertStatements) {
        if (actual.size() != expected.size()) {
            throw new KsqlException("Topic " + topicName + ". Expected <" + expected.size() + "> records but it was <" + actual.size() + ">\n" + TestExecutor.getActualsForErrorMessage(actual));
        }
        Iterator<Record> expectedIt = expected.iterator();
        Iterator<ProducerRecord<?, ?>> actualIt = actual.iterator();
        int i = 0;
        while (actualIt.hasNext() && expectedIt.hasNext()) {
            Record expectedRecord = expectedIt.next();
            ProducerRecord<?, ?> actualProducerRecord = actualIt.next();
            TestExecutor.validateCreatedMessage(topicName, expectedRecord, actualProducerRecord, ranWithInsertStatements, i);
            ++i;
        }
    }

    private static String getActualsForErrorMessage(Collection<ProducerRecord<?, ?>> actual) {
        return actual.stream().map(TestExecutor::getProducerRecordInString).collect(Collectors.joining(System.lineSeparator(), "Actual records: \n", ""));
    }

    private static String getProducerRecordInString(ProducerRecord<?, ?> producerRecord) {
        Object value = producerRecord.value() instanceof String ? "\"" + producerRecord.value() + "\"" : producerRecord.value();
        return "<" + producerRecord.key() + ", " + value + "> with timestamp=" + producerRecord.timestamp() + " and headers=[" + TestExecutor.printHeaders((Iterable<? extends Header>)producerRecord.headers()) + "]";
    }

    private static String printHeaders(Iterable<? extends Header> headers) {
        return Streams.stream(headers).map(TestExecutor::printHeader).collect(Collectors.joining(", "));
    }

    private static String printHeader(Header header) {
        return String.format("{KEY=%s,VALUE=%s}", header.key(), BytesUtils.encode((byte[])header.value(), (BytesUtils.Encoding)BytesUtils.Encoding.BASE64));
    }

    private static void verifyTopology(TestCase testCase) {
        testCase.getExpectedTopology().ifPresent(expected -> {
            String expectedTopology = expected.getTopology();
            String actualTopology = testCase.getGeneratedTopologies().get(0);
            MatcherAssert.assertThat((String)"Generated topology differs from that built by previous versions of KSQL - this likely means there is a non-backwards compatible change.\nTHIS IS BAD!", (Object)actualTopology, (Matcher)Matchers.is((Object)expectedTopology));
            Map<String, SchemaNode> generatedSchemas = testCase.getGeneratedSchemas().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SchemaNode.fromSchemaInfo((QuerySchemas.SchemaInfo)e.getValue())));
            for (Map.Entry<String, SchemaNode> e2 : expected.getSchemas().entrySet()) {
                MatcherAssert.assertThat((String)"Schemas used by topology differ from those used by previous versions of KSQL - this is likely to mean there is a non-backwards compatible change.\nTHIS IS BAD!", generatedSchemas, (Matcher)Matchers.hasEntry((Object)e2.getKey(), (Object)e2.getValue()));
            }
            MatcherAssert.assertThat((String)"Number of schemas generated from topology does not match that from previous versions of KSQL - this likely means there is a non-backwards compatible change.\nTHIS IS BAD!", generatedSchemas.entrySet(), (Matcher)Matchers.hasSize((int)expected.getSchemas().size()));
        });
    }

    private void pipeRecordsFromProvidedInput(TestCase testCase, TopologyTestDriverContainer testDriver) {
        for (Record record : testCase.getInputRecords()) {
            if (!testDriver.getSourceTopicNames().contains(record.getTopicName())) continue;
            this.processSingleRecord(this.serialize(testCase.properties(), record.asProducerRecord()), testDriver, (Set<Topic>)ImmutableSet.copyOf(this.kafka.getAllTopics()));
        }
    }

    private void pipeRecordsFromKafka(String kafkaTopicName, TopologyTestDriverContainer topologyTestDriverContainer) {
        this.kafka.readRecords(kafkaTopicName).forEach(rec -> this.processSingleRecord((ProducerRecord<byte[], byte[]>)rec, topologyTestDriverContainer, (Set<Topic>)ImmutableSet.of()));
    }

    private void processSingleRecord(ProducerRecord<byte[], byte[]> producedRecord, TopologyTestDriverContainer testDriver, Set<Topic> possibleSinkTopics) {
        testDriver.getSourceTopic(producedRecord.topic()).pipeInput(new TestRecord(producedRecord));
        testDriver.getSinkTopicName().ifPresent(sinkTopicName -> {
            TestOutputTopic<byte[], byte[]> sinkTopic = testDriver.getSinkTopic((String)sinkTopicName);
            this.processRecordsForTopic(sinkTopic, (String)sinkTopicName);
            for (Topic possibleSinkTopic : possibleSinkTopics) {
                if (possibleSinkTopic.getName().equals(sinkTopicName)) continue;
                this.processRecordsForTopic(testDriver.getSinkTopic(possibleSinkTopic.getName()), possibleSinkTopic.getName());
            }
        });
    }

    private void processRecordsForTopic(TestOutputTopic<byte[], byte[]> sinkTopic, String sinkTopicName) {
        sinkTopic.readRecordsToList().forEach(testRecord -> this.kafka.writeRecord((ProducerRecord<byte[], byte[]>)new ProducerRecord(sinkTopicName, null, testRecord.timestamp(), testRecord.getKey(), testRecord.getValue(), (Iterable)testRecord.getHeaders())));
    }

    static ServiceContext getServiceContext() {
        StubKafkaClientSupplier kafkaClientSupplier = new StubKafkaClientSupplier();
        return TestExecutor.getServiceContext(kafkaClientSupplier);
    }

    private static ServiceContext getServiceContext(StubKafkaClientSupplier kafkaClientSupplier) {
        MockSchemaRegistryClient schemaRegistryClient = new MockSchemaRegistryClient();
        return new DefaultServiceContext((KafkaClientSupplier)kafkaClientSupplier, () -> kafkaClientSupplier.getAdmin(Collections.emptyMap()), () -> kafkaClientSupplier.getAdmin(Collections.emptyMap()), (KafkaTopicClient)new StubKafkaTopicClient(), () -> TestExecutor.lambda$getServiceContext$14((SchemaRegistryClient)schemaRegistryClient), () -> new DefaultConnectClient("http://localhost:8083", Optional.empty(), Collections.emptyMap(), Optional.empty(), false, KsqlConfig.CONNECT_REQUEST_TIMEOUT_DEFAULT.longValue()), DisabledKsqlClient::instance, (KafkaConsumerGroupClient)new StubKafkaConsumerGroupClient());
    }

    static KsqlEngine getKsqlEngine(ServiceContext serviceContext, Optional<String> extensionDir) {
        FunctionRegistry functionRegistry;
        if (extensionDir.isPresent()) {
            InternalFunctionRegistry mutable = new InternalFunctionRegistry();
            UdfLoaderUtil.load((MutableFunctionRegistry)mutable, (String)extensionDir.get());
            functionRegistry = mutable;
        } else {
            functionRegistry = TestFunctionRegistry.INSTANCE.get();
        }
        MetaStoreImpl metaStore = new MetaStoreImpl(functionRegistry);
        MetricCollectors metricCollectors = new MetricCollectors();
        return new KsqlEngine(serviceContext, ProcessingLogContext.create(), "test_instance_", (MutableMetaStore)metaStore, engine -> new KsqlEngineMetrics("", engine, Collections.emptyMap(), Optional.empty(), metricCollectors), (QueryIdGenerator)new SequentialQueryIdGenerator(), KsqlConfig.empty(), Collections.emptyList(), metricCollectors);
    }

    public static Map<String, ?> baseConfig() {
        return ImmutableMap.builder().putAll(BASE_CONFIG).put((Object)"state.dir", (Object)TestUtils.tempDirectory().toAbsolutePath().toString()).build();
    }

    private void writeInputIntoTopics(TestCase testCase, StubKafkaService kafka) {
        testCase.getInputRecords().stream().map(Record::asProducerRecord).map(rec -> this.serialize(testCase.properties(), (ProducerRecord<?, ?>)rec)).forEach(kafka::writeRecord);
    }

    private static Object coerceRecordFields(Object record) {
        if (!(record instanceof Map)) {
            return record;
        }
        Map recordMap = (Map)record;
        recordMap.forEach((k, v) -> {
            if (v instanceof ByteBuffer) {
                byte[] fieldBytes = BytesUtils.getByteArray((ByteBuffer)((ByteBuffer)v));
                recordMap.put(k, fieldBytes != null && fieldBytes.length > 0 ? BytesUtils.encode((byte[])fieldBytes, (BytesUtils.Encoding)BytesUtils.Encoding.BASE64) : null);
            }
        });
        return recordMap;
    }

    private static void validateCreatedMessage(String topicName, Record expectedRecord, ProducerRecord<?, ?> actualProducerRecord, boolean ranWithInsertStatements, int messageIndex) {
        Windowed windowed;
        Object actualKey = TestExecutor.coerceRecordFields(actualProducerRecord.key());
        Object actualValue = TestExecutor.coerceRecordFields(actualProducerRecord.value());
        long actualTimestamp = actualProducerRecord.timestamp();
        Headers actualHeaders = actualProducerRecord.headers();
        JsonNode expectedKey = expectedRecord.getJsonKey().orElse((JsonNode)NullNode.getInstance());
        JsonNode expectedValue = expectedRecord.getJsonValue().orElseThrow(() -> new KsqlServerException("could not get expected value from test record: " + expectedRecord));
        long expectedTimestamp = expectedRecord.timestamp().orElse(actualTimestamp);
        List<TestHeader> expectedHeaders = expectedRecord.headers().orElse((List<TestHeader>)ImmutableList.of());
        AssertionError error = new AssertionError((Object)("Topic '" + topicName + "', message " + messageIndex + ": Expected <" + expectedKey + ", " + expectedValue + "> with timestamp=" + expectedTimestamp + " and headers=[" + TestExecutor.printHeaders(expectedHeaders) + "] but was " + TestExecutor.getProducerRecordInString(actualProducerRecord)));
        if (expectedRecord.getWindow() != null ? !new WindowData(windowed = (Windowed)actualKey).equals(expectedRecord.getWindow()) || !ExpectedRecordComparator.matches(((Windowed)actualKey).key(), expectedKey) : !ExpectedRecordComparator.matches(actualKey, expectedKey)) {
            throw error;
        }
        if (!ExpectedRecordComparator.matches(actualValue, expectedValue)) {
            throw error;
        }
        if (!ExpectedRecordComparator.matches(actualHeaders.toArray(), expectedHeaders)) {
            throw error;
        }
        if (!(actualTimestamp == expectedTimestamp || ranWithInsertStatements && expectedTimestamp == 0L)) {
            throw error;
        }
    }

    private static /* synthetic */ SchemaRegistryClient lambda$getServiceContext$14(SchemaRegistryClient schemaRegistryClient) {
        return schemaRegistryClient;
    }

    static interface TopologyBuilder {
        public List<TopologyTestDriverContainer> buildStreamsTopologyTestDrivers(TestCase var1, ServiceContext var2, KsqlEngine var3, KsqlConfig var4, StubKafkaService var5, TestExecutionListener var6);
    }
}

