/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools;

import com.google.common.collect.Range;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.test.model.KsqlVersion;
import java.util.Optional;

@Immutable
public final class VersionBounds {
    private final Range<KsqlVersion> range;

    public static VersionBounds of(Optional<KsqlVersion> min, Optional<KsqlVersion> max) {
        return new VersionBounds(min, max);
    }

    public static VersionBounds allVersions() {
        return VersionBounds.of(Optional.empty(), Optional.empty());
    }

    private VersionBounds(Optional<KsqlVersion> min, Optional<KsqlVersion> max) {
        this.range = min.isPresent() && max.isPresent() ? Range.closed((Comparable)min.get(), (Comparable)max.get()) : (!min.isPresent() && !max.isPresent() ? Range.all() : min.map(Range::atLeast).orElseGet(() -> Range.atMost((Comparable)((Comparable)max.get()))));
    }

    public boolean contains(KsqlVersion version) {
        return this.range.contains((Comparable)version);
    }

    public String toString() {
        return this.range.toString();
    }
}

