/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.utils;

import io.confluent.common.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public enum TestUtils {
    INSTANCE;

    private final Path root = TestUtils.createRoot();

    public static Path tempDirectory() {
        return INSTANCE.createTempDirectory();
    }

    private Path createTempDirectory() {
        try {
            return Files.createTempDirectory(this.root, null, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to create a temp dir", ex);
        }
    }

    private static Path createRoot() {
        try {
            final Path path = Files.createTempDirectory("confluent-ksqldb", new FileAttribute[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        Utils.delete((File)path.toFile());
                    }
                    catch (IOException e) {
                        System.err.println("Error deleting " + path.toAbsolutePath());
                    }
                }
            });
            return path;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to create a temp dir", ex);
        }
    }
}

