/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.credential;

import io.confluent.security.authentication.credential.HttpCredential;
import io.confluent.security.authentication.credential.UsernamePasswordCredential;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Supplier;

public final class HttpBasicCredential
extends HttpCredential {
    private final UsernamePasswordCredential credential;

    public HttpBasicCredential(String user, String password) {
        this(() -> new UsernamePasswordCredential(user, password));
    }

    public HttpBasicCredential(Supplier<UsernamePasswordCredential> credential) {
        this.credential = credential.get();
    }

    public HttpBasicCredential(String authInfo) {
        this(() -> HttpBasicCredential.readValue(authInfo));
    }

    private static UsernamePasswordCredential readValue(String authInfo) {
        return HttpBasicCredential.decodeAuthInfo(Base64.getUrlDecoder().decode(authInfo));
    }

    private static String encodeAuthInfo(UsernamePasswordCredential credential) {
        String authInfo = String.join((CharSequence)":", credential.username(), credential.password());
        return HttpBasicCredential.encodeAuthInfo(authInfo.getBytes(StandardCharsets.ISO_8859_1));
    }

    private static String encodeAuthInfo(byte[] authInfo) {
        return Base64.getUrlEncoder().encodeToString(authInfo);
    }

    private static UsernamePasswordCredential decodeAuthInfo(byte[] authInfo) {
        String[] userPassword = new String(authInfo, StandardCharsets.ISO_8859_1).split(":", 2);
        if (userPassword.length != 2) {
            throw new IllegalArgumentException("Unable to parse credentials; Basic credentials must be in the form of %s:%s");
        }
        return new UsernamePasswordCredential(userPassword[0], userPassword[1]);
    }

    @Override
    public HttpCredential.Scheme scheme() {
        return HttpCredential.Scheme.BASIC;
    }

    @Override
    public UsernamePasswordCredential credential() {
        return this.credential;
    }

    @Override
    public String authParams() {
        return HttpBasicCredential.encodeAuthInfo(this.credential);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpBasicCredential)) {
            return false;
        }
        HttpBasicCredential that = (HttpBasicCredential)o;
        return Objects.equals((Object)this.scheme(), (Object)that.scheme()) && Objects.equals(this.credential, that.credential);
    }

    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(new Object[]{this.scheme(), this.credential});
    }
}

