/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.http;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import io.confluent.security.authentication.credential.HttpCredential;
import io.confluent.security.authentication.http.HttpClientAuthFilter;
import io.confluent.security.authentication.utils.JacksonSerde;
import io.confluent.security.config.Duration;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    private final Client client;
    private final HttpClientAuthFilter defaultAuthFilter;

    public HttpClient(Client client) {
        this.defaultAuthFilter = new HttpClientAuthFilter(null);
        this.client = client;
    }

    private HttpClient(Duration connectTimeout, Duration readTimeout, HttpCredential credential, SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        ClientBuilder builder = (ClientBuilder)ClientBuilder.newBuilder().connectTimeout(connectTimeout.value(), connectTimeout.unit()).readTimeout(readTimeout.value(), readTimeout.unit()).register((Object)new JacksonJaxbJsonProvider(JacksonSerde.jsonMapper(), JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS));
        this.defaultAuthFilter = new HttpClientAuthFilter(credential);
        this.maybeConfigureSsl(builder, sslContext, hostnameVerifier);
        this.client = builder.build();
    }

    public WebTarget target(URI targetUri) {
        return (WebTarget)this.client.target(targetUri).register((Object)this.defaultAuthFilter);
    }

    public WebTarget target(URI targetUri, HttpCredential credential) {
        return (WebTarget)this.client.target(targetUri).register((Object)new HttpClientAuthFilter(credential));
    }

    private void maybeConfigureSsl(ClientBuilder builder, SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        if (sslContext != null) {
            builder.sslContext(sslContext).hostnameVerifier(hostnameVerifier);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() {
        this.client.close();
    }

    public static class Builder {
        private Duration connectTimeout;
        private Duration readTimeout;
        private HttpCredential credential;
        private HostnameVerifier hostnameVerifier;
        private SSLContext sslContext;

        private Builder() {
        }

        public Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder authentication(HttpCredential credential) {
            this.credential = credential;
            return this;
        }

        public Builder hostNameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public HttpClient build() {
            this.connectTimeout = this.connectTimeout == null ? new Duration(18L, TimeUnit.SECONDS) : this.connectTimeout;
            this.readTimeout = this.readTimeout == null ? new Duration(30L, TimeUnit.SECONDS) : this.readTimeout;
            return new HttpClient(this.connectTimeout, this.readTimeout, this.credential, this.sslContext, this.hostnameVerifier);
        }
    }
}

