/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import io.confluent.security.authentication.AuthenticationErrorInfo;
import io.confluent.security.authentication.AuthenticationException;
import io.confluent.security.authentication.Authenticator;
import io.confluent.security.authentication.credential.BearerCredential;
import io.confluent.security.authentication.oauthbearer.Constraint;
import io.confluent.security.authentication.oauthbearer.IssuerExtractor;
import io.confluent.security.authentication.oauthbearer.JwtIssuer;
import io.confluent.security.authentication.oauthbearer.JwtPrincipal;
import io.confluent.security.util.JwtUtils;
import io.confluent.security.util.SecurityContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JwtAuthenticator
implements Authenticator<BearerCredential, JwtPrincipal> {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticator.class);
    private final Map<String, DecoratedJwtConsumer> jwtConsumers = new ConcurrentHashMap<String, DecoratedJwtConsumer>();

    public JwtAuthenticator(List<JwtIssuer> issuers, Collection<Constraint> constraints) {
        for (JwtIssuer issuer : issuers) {
            boolean requireSubjectClaim = "Confluent".equalsIgnoreCase(issuer.name());
            this.jwtConsumers.put(issuer.name(), context -> issuer.createConsumer(constraints, requireSubjectClaim, (SecurityContext)context));
        }
    }

    @Override
    public JwtPrincipal authenticate(BearerCredential credential) {
        return this.authenticate(credential, null);
    }

    Map<String, DecoratedJwtConsumer> getJwtConsumers() {
        return this.jwtConsumers;
    }

    public JwtPrincipal authenticate(BearerCredential credential, SecurityContext context) {
        try {
            String issuerName = IssuerExtractor.getIssuer(credential.bearerToken());
            if (issuerName == null) {
                throw new IllegalArgumentException("Bearer token missing required issuer claim");
            }
            DecoratedJwtConsumer decoratedJwtConsumer = this.jwtConsumers.getOrDefault(issuerName, this.jwtConsumers.get("*"));
            if (decoratedJwtConsumer == null) {
                throw new AuthenticationException("Unrecognized issuer " + issuerName, "TOKEN_ISSUER_UNRECOGNIZED");
            }
            JwtConsumer jwtConsumer = (JwtConsumer)decoratedJwtConsumer.apply(context);
            JwtClaims claims = jwtConsumer.processToClaims(credential.bearerToken());
            return new JwtPrincipal(claims);
        }
        catch (Throwable t) {
            log.trace("Failed to process token", t);
            String reasonCode = "AUTHENTICATION_EXCEPTION_OCCURRED";
            AuthenticationErrorInfo.JwtClaimsInfo errorInfo = null;
            if (t instanceof IllegalArgumentException) {
                reasonCode = "TOKEN_ISSUER_CLAIM_ABSENT";
            } else if (t instanceof AuthenticationException) {
                reasonCode = ((AuthenticationException)t).reasonCode();
            } else if (t instanceof InvalidJwtException) {
                reasonCode = "TOKEN_PROCESSING_FAILURE";
                JwtClaims claims = ((InvalidJwtException)t).getJwtContext().getJwtClaims();
                if (claims != null) {
                    errorInfo = new AuthenticationErrorInfo.JwtClaimsInfo();
                    errorInfo.claims(claims.getClaimsMap());
                }
            }
            JwtUtils.Error error = JwtUtils.errorDetails(t, context);
            if (t instanceof InvalidJwtException && error.errors() != null && error.errors().size() > 0) {
                reasonCode = error.errors().get(0).reasonCode().name();
            }
            log.error("Failed to process token: {}, reasonCode: {}", (Object)error, (Object)reasonCode);
            AuthenticationException exe = new AuthenticationException("Failed to authenticate bearer credentials : " + error.message(), reasonCode);
            if (errorInfo != null) {
                exe.errorInfo(errorInfo);
            }
            throw exe;
        }
    }

    private static interface DecoratedJwtConsumer
    extends Function<SecurityContext, JwtConsumer> {
    }
}

