/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import io.confluent.security.authentication.credential.BearerCredential;
import io.spiffe.bundle.jwtbundle.JwtBundle;
import io.spiffe.bundle.jwtbundle.JwtBundleSet;
import io.spiffe.exception.BundleNotFoundException;
import io.spiffe.spiffeid.SpiffeId;
import io.spiffe.spiffeid.TrustDomain;
import io.spiffe.svid.jwtsvid.JwtSvid;
import io.spiffe.workloadapi.JwtSource;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jose4j.jwk.EcJwkGenerator;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.keys.EllipticCurves;
import org.jose4j.lang.JoseException;

public class MockJwtSource
implements JwtSource {
    private final JwtBundleSet bundles = JWT_BUNDLE_SET;
    public static final String SPIRE_ISSUER = "test.prefix.spire.internal.confluent.cloud";
    public static final TrustDomain SPIRE_TRUST_DOMAIN_1 = TrustDomain.parse((String)"spire.test.domain.one");
    public static final TrustDomain SPIRE_TRUST_DOMAIN_2 = TrustDomain.parse((String)"spire.test.domain.two");
    public static final List<String> VALID_AUD = Collections.singletonList("mockAud");
    public static final JwtBundleSet JWT_BUNDLE_SET;
    public static RsaJsonWebKey rsaSpire1;
    public static RsaJsonWebKey rsaSpire2;
    public static RsaJsonWebKey rsa512Spire1;
    public static RsaJsonWebKey rsa512Spire2;
    public static EllipticCurveJsonWebKey ecSpire1;
    public static EllipticCurveJsonWebKey ecSpire2;
    private static final JsonWebKeySet JWKS;

    public JwtBundle getBundleForTrustDomain(TrustDomain trustDomain) throws BundleNotFoundException {
        return this.bundles.getBundleForTrustDomain(trustDomain);
    }

    public JwtSvid fetchJwtSvid(String audience, String ... extraAudiences) {
        return null;
    }

    public JwtSvid fetchJwtSvid(SpiffeId subject, String audience, String ... extraAudiences) {
        return null;
    }

    public List<JwtSvid> fetchJwtSvids(String audience, String ... extraAudience) {
        return null;
    }

    public List<JwtSvid> fetchJwtSvids(SpiffeId subject, String audience, String ... extraAudience) {
        return null;
    }

    public void close() throws IOException {
    }

    public static BearerCredential createEncodedJws(Kid kid, JwtClaims claims) throws JoseException {
        return new BearerCredential(MockJwtSource.createJws(kid, claims).getCompactSerialization());
    }

    public static JsonWebSignature createJws(Kid kid, JwtClaims claims) {
        PublicJsonWebKey jwk = (PublicJsonWebKey)JWKS.findJsonWebKey(kid.name(), null, null, null);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setKey((Key)jwk.getPrivateKey());
        if (!kid.name().endsWith("PEM")) {
            jws.setKeyIdHeaderValue(kid.name());
        }
        jws.setAlgorithmHeaderValue(jwk.getAlgorithm());
        jws.setPayload(claims.toJson());
        return jws;
    }

    public static JsonWebSignature createJwsWithInvalidKid(JwtClaims claims) {
        PublicJsonWebKey jwk = (PublicJsonWebKey)JWKS.findJsonWebKey(Kid.RSA_SPIRE_1.name(), null, null, null);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setKey((Key)jwk.getPrivateKey());
        jws.setKeyIdHeaderValue(Kid.INVALID_KID.name());
        jws.setAlgorithmHeaderValue(jwk.getAlgorithm());
        jws.setPayload(claims.toJson());
        return jws;
    }

    static {
        try {
            rsaSpire1 = RsaJwkGenerator.generateJwk((int)2048);
            rsaSpire1.setKeyId(Kid.RSA_SPIRE_1.name());
            rsaSpire1.setAlgorithm("RS256");
            rsaSpire2 = RsaJwkGenerator.generateJwk((int)2048);
            rsaSpire2.setKeyId(Kid.RSA_SPIRE_2.name());
            rsaSpire2.setAlgorithm("RS256");
            rsa512Spire1 = RsaJwkGenerator.generateJwk((int)2048);
            rsa512Spire1.setKeyId(Kid.RSA_EXCLUDE_SPIRE_1.name());
            rsa512Spire1.setAlgorithm("RS512");
            rsa512Spire2 = RsaJwkGenerator.generateJwk((int)2048);
            rsa512Spire2.setKeyId(Kid.RSA_EXCLUDE_SPIRE_2.name());
            rsa512Spire2.setAlgorithm("RS512");
            ecSpire1 = EcJwkGenerator.generateJwk((ECParameterSpec)EllipticCurves.P256);
            ecSpire1.setKeyId(Kid.EU_SPIRE_1.name());
            ecSpire1.setAlgorithm("ES256");
            ecSpire2 = EcJwkGenerator.generateJwk((ECParameterSpec)EllipticCurves.P256);
            ecSpire2.setKeyId(Kid.EU_SPIRE_2.name());
            ecSpire2.setAlgorithm("ES256");
            JwtBundle jwtBundleTrustDomain1 = new JwtBundle(SPIRE_TRUST_DOMAIN_1, (Map)new HashMap<String, PublicKey>(){
                {
                    this.put(rsaSpire1.getKeyId(), rsaSpire1.getPublicKey());
                    this.put(rsa512Spire1.getKeyId(), rsa512Spire1.getPublicKey());
                    this.put(ecSpire1.getKeyId(), ecSpire1.getPublicKey());
                }
            });
            JwtBundle jwtBundleTrustDomain2 = new JwtBundle(SPIRE_TRUST_DOMAIN_2, (Map)new HashMap<String, PublicKey>(){
                {
                    this.put(rsaSpire2.getKeyId(), rsaSpire2.getPublicKey());
                    this.put(rsa512Spire2.getKeyId(), rsa512Spire2.getPublicKey());
                    this.put(ecSpire2.getKeyId(), ecSpire2.getPublicKey());
                }
            });
            JWT_BUNDLE_SET = JwtBundleSet.of(Arrays.asList(jwtBundleTrustDomain1, jwtBundleTrustDomain2));
            JWKS = new JsonWebKeySet(new JsonWebKey[0]){
                {
                    this.addJsonWebKey((JsonWebKey)rsaSpire1);
                    this.addJsonWebKey((JsonWebKey)rsa512Spire1);
                    this.addJsonWebKey((JsonWebKey)ecSpire1);
                    this.addJsonWebKey((JsonWebKey)rsaSpire2);
                    this.addJsonWebKey((JsonWebKey)rsa512Spire2);
                    this.addJsonWebKey((JsonWebKey)ecSpire2);
                }
            };
        }
        catch (JoseException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Kid {
        RSA_SPIRE_1,
        RSA_EXCLUDE_SPIRE_1,
        EU_SPIRE_1,
        RSA_SPIRE_2,
        RSA_EXCLUDE_SPIRE_2,
        EU_SPIRE_2,
        INVALID_KID;

    }
}

