/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oidc;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@JsonDeserialize(builder=Builder.class)
public final class MetadataResponse {
    @JsonProperty(value="issuer")
    private final String issuer;
    @JsonProperty(value="authorization_endpoint")
    private final URI authorizationEndpoint;
    @JsonProperty(value="token_endpoint")
    private final URI tokenEndpoint;
    @JsonProperty(value="userInfoURI")
    private final URI userInfoEndpoint;
    @JsonProperty(value="jwks_uri")
    private final URI jwksEndpoint;
    private URI registrationEndpoint;
    private String[] scopesSupported;
    private final String[] responseTypesSupported;
    private String[] responseModesSupported;
    private String[] grantTypesSupported;
    private String[] acrValuesSupported;
    private final String[] subjectTypesSupported;
    private final String[] idTokenSigningAlgValuesSupported;
    private String[] idTokenEncryptionAlgValuesSupported;
    private String[] idTokenEncryptionEncValuesSupported;
    private String[] userInfoSigningAlgValuesSupported;
    private String[] userInfoEncryptionAlgValuesSupported;
    private String[] userInfoEncryptionEncValuesSupported;
    private String[] requestObjectSigningAlgValuesSupported;
    private String[] requestObjectEncryptionAlgValuesSupported;
    private String[] requestObjectEncryptionEncValuesSupported;
    private String[] tokenEndpointAuthMethodsSupported;
    private String[] tokenEndpointAuthSigningAlgValuesSupported;
    private String[] displayValuesSupported;
    private String[] claimTypesSupported;
    private String[] claimsSupported;
    private URI serviceDocumentation;
    private String[] claimsLocalesSupported;
    private String[] uiLocalesSupported;
    private boolean claimsParameterSupported;
    private boolean requestParameterSupported;
    private boolean requestUriParameterSupported;
    private boolean requireRequestUriRegistration;
    private URI opPolicyUri;
    private URI opTosUri;

    public static Builder builder() {
        return new Builder();
    }

    private MetadataResponse(String issuer, URI authorizationEndpoint, URI tokenEndpoint, URI userInfoEndpoint, URI jwksEndpoint, URI registrationEndpoint, String[] scopesSupported, String[] responseTypesSupported, String[] responseModesSupported, String[] grantTypesSupported, String[] acrValuesSupported, String[] subjectTypesSupported, String[] idTokenSigningAlgValuesSupported, String[] idTokenEncryptionAlgValuesSupported, String[] idTokenEncryptionEncValuesSupported, String[] userInfoSigningAlgValuesSupported, String[] userInfoEncryptionAlgValuesSupported, String[] userInfoEncryptionEncValuesSupported, String[] requestObjectSigningAlgValuesSupported, String[] requestObjectEncryptionAlgValuesSupported, String[] requestObjectEncryptionEncValuesSupported, String[] tokenEndpointAuthMethodsSupported, String[] tokenEndpointAuthSigningAlgValuesSupported, String[] displayValuesSupported, String[] claimTypesSupported, String[] claimsSupported, URI serviceDocumentation, String[] claimsLocalesSupported, String[] uiLocalesSupported, boolean claimsParameterSupported, boolean requestParameterSupported, boolean requestUriParameterSupported, boolean requireRequestUriRegistration, URI opPolicyUri, URI opTosUri) {
        this.issuer = issuer;
        this.authorizationEndpoint = authorizationEndpoint;
        this.tokenEndpoint = tokenEndpoint;
        this.userInfoEndpoint = userInfoEndpoint;
        this.jwksEndpoint = jwksEndpoint;
        this.registrationEndpoint = registrationEndpoint;
        this.scopesSupported = scopesSupported;
        this.responseTypesSupported = responseTypesSupported;
        this.responseModesSupported = responseModesSupported;
        this.grantTypesSupported = grantTypesSupported;
        this.acrValuesSupported = acrValuesSupported;
        this.subjectTypesSupported = subjectTypesSupported;
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
        this.idTokenEncryptionAlgValuesSupported = idTokenEncryptionAlgValuesSupported;
        this.idTokenEncryptionEncValuesSupported = idTokenEncryptionEncValuesSupported;
        this.userInfoSigningAlgValuesSupported = userInfoSigningAlgValuesSupported;
        this.userInfoEncryptionAlgValuesSupported = userInfoEncryptionAlgValuesSupported;
        this.userInfoEncryptionEncValuesSupported = userInfoEncryptionEncValuesSupported;
        this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
        this.requestObjectEncryptionAlgValuesSupported = requestObjectEncryptionAlgValuesSupported;
        this.requestObjectEncryptionEncValuesSupported = requestObjectEncryptionEncValuesSupported;
        this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
        this.tokenEndpointAuthSigningAlgValuesSupported = tokenEndpointAuthSigningAlgValuesSupported;
        this.displayValuesSupported = displayValuesSupported;
        this.claimTypesSupported = claimTypesSupported;
        this.claimsSupported = claimsSupported;
        this.serviceDocumentation = serviceDocumentation;
        this.claimsLocalesSupported = claimsLocalesSupported;
        this.uiLocalesSupported = uiLocalesSupported;
        this.claimsParameterSupported = claimsParameterSupported;
        this.requestParameterSupported = requestParameterSupported;
        this.requestUriParameterSupported = requestUriParameterSupported;
        this.requireRequestUriRegistration = requireRequestUriRegistration;
        this.opPolicyUri = opPolicyUri;
        this.opTosUri = opTosUri;
    }

    public String issuer() {
        return this.issuer;
    }

    public URI authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public URI tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public URI jwksEndpoint() {
        return this.jwksEndpoint;
    }

    public List<String> responseTypesSupported() {
        return Collections.unmodifiableList(Arrays.asList(this.responseTypesSupported));
    }

    public List<String> subjectTypesSupported() {
        return Collections.unmodifiableList(Arrays.asList(this.subjectTypesSupported));
    }

    public List<String> IdTokenSigningAlgValuesSupported() {
        return Collections.unmodifiableList(Arrays.asList(this.idTokenSigningAlgValuesSupported));
    }

    public URI registrationEndpoint() {
        return this.registrationEndpoint;
    }

    @JsonPOJOBuilder
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Builder {
        private String issuer;
        private URI authorizationEndpoint;
        private URI tokenEndpoint;
        private URI userInfoEndpoint;
        private URI jwksEndpoint;
        private URI registrationEndpoint;
        private String[] scopesSupported;
        private String[] responseTypesSupported;
        private String[] responseModesSupported;
        private String[] grantTypesSupported;
        private String[] acrValuesSupported;
        private String[] subjectTypesSupported;
        private String[] idTokenSigningAlgValuesSupported;
        private String[] idTokenEncryptionAlgValuesSupported;
        private String[] idTokenEncryptionEncValuesSupported;
        private String[] userInfoSigningAlgValuesSupported;
        private String[] userInfoEncryptionAlgValuesSupported;
        private String[] userInfoEncryptionEncValuesSupported;
        private String[] requestObjectSigningAlgValuesSupported;
        private String[] requestObjectEncryptionAlgValuesSupported;
        private String[] requestObjectEncryptionEncValuesSupported;
        private String[] tokenEndpointAuthMethodsSupported;
        private String[] tokenEndpointAuthSigningAlgValuesSupported;
        private String[] displayValuesSupported;
        private String[] claimTypesSupported;
        private String[] claimsSupported;
        private URI serviceDocumentation;
        private String[] claimsLocalesSupported;
        private String[] uiLocalesSupported;
        private boolean claimsParameterSupported;
        private boolean requestParameterSupported;
        private boolean requestUriParameterSupported;
        private boolean requireRequestUriRegistration;
        private URI opPolicyUri;
        private URI opTosUri;

        public Builder Issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        @JsonSetter(value="issuer")
        public Builder Issuer(URI issuer) {
            return this.Issuer(issuer.toString().replaceFirst("/*$", ""));
        }

        @JsonSetter(value="authorization_endpoint")
        public Builder authorizationEndpoint(URI authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        @JsonSetter(value="token_endpoint")
        public Builder tokenEndpoint(URI tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        @JsonSetter(value="userinfo_endpoint")
        public Builder userInfoEndpoint(URI userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
            return this;
        }

        @JsonSetter(value="jwks_uri")
        public Builder jwksEndpoint(URI jwksEndpoint) {
            this.jwksEndpoint = jwksEndpoint;
            return this;
        }

        @JsonSetter(value="registration_endpoint")
        public Builder registrationEndpoint(URI registrationEndpoint) {
            this.registrationEndpoint = registrationEndpoint;
            return this;
        }

        @JsonSetter(value="scopes_supported")
        public Builder scopesSupported(String[] scopesSupported) {
            this.scopesSupported = scopesSupported;
            return this;
        }

        @JsonSetter(value="response_types_supported")
        public Builder responseTypesSupported(String[] responseTypesSupported) {
            this.responseTypesSupported = responseTypesSupported;
            return this;
        }

        @JsonSetter(value="response_modes_supported")
        public Builder responseModesSupported(String[] responseModesSupported) {
            this.responseModesSupported = responseModesSupported;
            return this;
        }

        @JsonSetter(value="grant_types_supported")
        public Builder grantTypesSupported(String[] grantTypesSupported) {
            this.grantTypesSupported = grantTypesSupported;
            return this;
        }

        @JsonSetter(value="acr_values_supported")
        public Builder acrValuesSupported(String[] acrValuesSupported) {
            this.acrValuesSupported = acrValuesSupported;
            return this;
        }

        @JsonSetter(value="subject_types_supported")
        public Builder subjectTypesSupported(String[] subjectTypesSupported) {
            this.subjectTypesSupported = subjectTypesSupported;
            return this;
        }

        @JsonSetter(value="id_token_signing_alg_values_supported")
        public Builder idTokenSigningAlgValuesSupported(String[] idTokenSigningAlgValuesSupported) {
            this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
            return this;
        }

        @JsonSetter(value="id_token_encryption_alg_values_supported")
        public Builder idTokenEncryptionAlgValuesSupported(String[] idTokenEncryptionAlgValuesSupported) {
            this.idTokenEncryptionAlgValuesSupported = idTokenEncryptionAlgValuesSupported;
            return this;
        }

        @JsonSetter(value="id_token_encryption_enc_values_supported")
        public Builder idTokenEncryptionEncValuesSupported(String[] idTokenEncryptionEncValuesSupported) {
            this.idTokenEncryptionEncValuesSupported = idTokenEncryptionEncValuesSupported;
            return this;
        }

        @JsonSetter(value="userInfo_signing_alg_values_supported")
        public Builder userInfoSigningAlgValuesSupported(String[] userInfoSigningAlgValuesSupported) {
            this.userInfoSigningAlgValuesSupported = userInfoSigningAlgValuesSupported;
            return this;
        }

        @JsonSetter(value="userinfo_encryption_alg_values_supported")
        public Builder userInfoEncryptionAlgValuesSupported(String[] userInfoEncryptionAlgValuesSupported) {
            this.userInfoEncryptionAlgValuesSupported = userInfoEncryptionAlgValuesSupported;
            return this;
        }

        @JsonSetter(value="userinfo_encryption_enc_values_supported")
        public Builder userInfoEncryptionEncValuesSupported(String[] userInfoEncryptionEncValuesSupported) {
            this.userInfoEncryptionEncValuesSupported = userInfoEncryptionEncValuesSupported;
            return this;
        }

        @JsonSetter(value="request_object_signing_alg_values_supported")
        public Builder requestObjectSigningAlgValuesSupported(String[] requestObjectSigningAlgValuesSupported) {
            this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
            return this;
        }

        @JsonSetter(value="request_object_encryption_alg_values_supported")
        public Builder requestObjectEncryptionAlgValuesSupported(String[] requestObjectEncryptionAlgValuesSupported) {
            this.requestObjectEncryptionAlgValuesSupported = requestObjectEncryptionAlgValuesSupported;
            return this;
        }

        @JsonSetter(value="request_object_encryption_enc_values_supported")
        public Builder requestObjectEncryptionEncValuesSupported(String[] requestObjectEncryptionEncValuesSupported) {
            this.requestObjectEncryptionEncValuesSupported = requestObjectEncryptionEncValuesSupported;
            return this;
        }

        @JsonSetter(value="token_endpoint_auth_methods_supported")
        public Builder tokenEndpointAuthMethodsSupported(String[] tokenEndpointAuthMethodsSupported) {
            this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
            return this;
        }

        @JsonSetter(value="token_endpoint_auth_signing_alg_values_supported")
        public Builder tokenEndpointAuthSigningAlgValuesSupported(String[] tokenEndpointAuthSigningAlgValuesSupported) {
            this.tokenEndpointAuthSigningAlgValuesSupported = tokenEndpointAuthSigningAlgValuesSupported;
            return this;
        }

        @JsonSetter(value="display_values_supported")
        public Builder displayValuesSupported(String[] displayValuesSupported) {
            this.displayValuesSupported = displayValuesSupported;
            return this;
        }

        @JsonSetter(value="claim_types_supported")
        public Builder claimTypesSupported(String[] claimTypesSupported) {
            this.claimTypesSupported = claimTypesSupported;
            return this;
        }

        @JsonSetter(value="claims_supported")
        public Builder claimsSupported(String[] claimsSupported) {
            this.claimsSupported = claimsSupported;
            return this;
        }

        @JsonSetter(value="service_documentation")
        public Builder serviceDocumentation(URI serviceDocumentation) {
            this.serviceDocumentation = serviceDocumentation;
            return this;
        }

        @JsonSetter(value="claims_locales_supported")
        public Builder claimsLocalesSupported(String[] claimsLocalesSupported) {
            this.claimsLocalesSupported = claimsLocalesSupported;
            return this;
        }

        @JsonSetter(value="ui_locales_supported")
        public Builder uiLocalesSupported(String[] uiLocalesSupported) {
            this.uiLocalesSupported = uiLocalesSupported;
            return this;
        }

        @JsonSetter(value="claims_parameter_supported")
        public Builder claimsParameterSupported(boolean claimsParameterSupported) {
            this.claimsParameterSupported = claimsParameterSupported;
            return this;
        }

        @JsonSetter(value="request_parameter_supported")
        public Builder requestParameterSupported(boolean requestParameterSupported) {
            this.requestParameterSupported = requestParameterSupported;
            return this;
        }

        @JsonSetter(value="request_uri_parameter_supported")
        public Builder requestUriParameterSupported(boolean requestUriParameterSupported) {
            this.requestUriParameterSupported = requestUriParameterSupported;
            return this;
        }

        @JsonSetter(value="require_request_uri_registration")
        public Builder requireRequestUriRegistration(boolean requireRequestUriRegistration) {
            this.requireRequestUriRegistration = requireRequestUriRegistration;
            return this;
        }

        @JsonSetter(value="op_policy_uri")
        public Builder opPolicyUri(URI opPolicyUri) {
            this.opPolicyUri = opPolicyUri;
            return this;
        }

        @JsonSetter(value="op_tos_uri")
        public Builder opTosUri(URI opTosUri) {
            this.opTosUri = opTosUri;
            return this;
        }

        public MetadataResponse build() {
            return new MetadataResponse(this.issuer, this.authorizationEndpoint, this.tokenEndpoint, this.userInfoEndpoint, this.jwksEndpoint, this.registrationEndpoint, this.scopesSupported, this.responseTypesSupported, this.responseModesSupported, this.grantTypesSupported, this.acrValuesSupported, this.subjectTypesSupported, this.idTokenSigningAlgValuesSupported, this.idTokenEncryptionAlgValuesSupported, this.idTokenEncryptionEncValuesSupported, this.userInfoSigningAlgValuesSupported, this.userInfoEncryptionAlgValuesSupported, this.userInfoEncryptionEncValuesSupported, this.requestObjectSigningAlgValuesSupported, this.requestObjectEncryptionAlgValuesSupported, this.requestObjectEncryptionEncValuesSupported, this.tokenEndpointAuthMethodsSupported, this.tokenEndpointAuthSigningAlgValuesSupported, this.displayValuesSupported, this.claimTypesSupported, this.claimsSupported, this.serviceDocumentation, this.claimsLocalesSupported, this.uiLocalesSupported, this.claimsParameterSupported, this.requestParameterSupported, this.requestUriParameterSupported, this.requireRequestUriRegistration, this.opPolicyUri, this.opTosUri);
        }
    }
}

