/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.version.metrics;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.version.metrics.KsqlVersionChecker;
import io.confluent.support.metrics.submitters.ResponseHandler;
import java.io.IOException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlVersionCheckerResponseHandler
implements ResponseHandler {
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(KsqlVersionChecker.class);
    private final Logger log;

    KsqlVersionCheckerResponseHandler() {
        this(DEFAULT_LOGGER);
    }

    @VisibleForTesting
    KsqlVersionCheckerResponseHandler(Logger log) {
        this.log = log;
    }

    @Override
    public void handle(ClassicHttpResponse response) {
        int statusCode = response.getCode();
        try {
            String content;
            if (statusCode == 200 && response.getEntity().getContent() != null && (content = EntityUtils.toString((HttpEntity)response.getEntity())).length() > 0) {
                this.log.warn(content);
            }
        }
        catch (IOException | ParseException e) {
            this.log.error("Error while parsing the Version check response ", e);
        }
    }
}

