/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.version.metrics.collector;

import io.confluent.ksql.util.AppInfo;
import io.confluent.ksql.version.metrics.KsqlVersionMetrics;
import io.confluent.ksql.version.metrics.collector.KsqlModuleType;
import io.confluent.support.metrics.common.Collector;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class BasicCollector
extends Collector {
    private final KsqlModuleType moduleType;
    private final Supplier<Boolean> activenessSupplier;
    private final Clock clock;

    public BasicCollector(KsqlModuleType moduleType, Supplier<Boolean> activenessStatusSupplier) {
        this(moduleType, activenessStatusSupplier, Clock.systemDefaultZone());
    }

    BasicCollector(KsqlModuleType moduleType, Supplier<Boolean> activenessSupplier, Clock clock) {
        this.moduleType = moduleType;
        this.activenessSupplier = Objects.requireNonNull(activenessSupplier, "activenessSupplier");
        this.clock = Objects.requireNonNull(clock, "clock");
    }

    public KsqlVersionMetrics collectMetrics() {
        KsqlVersionMetrics metricsRecord = new KsqlVersionMetrics();
        metricsRecord.setTimestamp(TimeUnit.MILLISECONDS.toSeconds(this.clock.millis()));
        metricsRecord.setConfluentPlatformVersion(AppInfo.getVersion());
        metricsRecord.setKsqlComponentType(this.moduleType.name());
        metricsRecord.setIsActive(this.activenessSupplier.get());
        return metricsRecord;
    }
}

