/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics;

import io.confluent.support.metrics.BaseSupportConfig;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoneHomeConfig
extends BaseSupportConfig {
    private static final Logger log = LoggerFactory.getLogger(PhoneHomeConfig.class);
    private static final boolean CONFLUENT_SUPPORT_CUSTOMER_ID_ENABLED_DEFAULT = false;

    public PhoneHomeConfig(Properties originals, String componentId) {
        this(originals, componentId, false);
    }

    private PhoneHomeConfig(Properties originals, String componentId, boolean supportCustomerIdEnabled) {
        super(PhoneHomeConfig.setupProperties(originals, supportCustomerIdEnabled), PhoneHomeConfig.getEndpointPath(componentId));
    }

    private static Properties setupProperties(Properties originals, boolean supportCustomerIdEnabled) {
        if (!supportCustomerIdEnabled) {
            if (originals == null) {
                originals = new Properties();
            }
            if (!PhoneHomeConfig.isTestUser(PhoneHomeConfig.getCustomerId(originals))) {
                log.warn("Enforcing customer ID '{}'", (Object)"anonymous");
                originals.setProperty("confluent.support.customer.id", "anonymous");
            }
        }
        return originals;
    }

    private static String getEndpointPath(String componentId) {
        return componentId;
    }
}

