/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics.common.time;

import io.confluent.support.metrics.common.time.Clock;

public class TimeUtils {
    private final Clock clock;

    public TimeUtils() {
        this(new SystemClock());
    }

    public TimeUtils(Clock clock) {
        this.clock = clock;
    }

    public long nowInUnixTime() {
        return this.clock.currentTimeMs() / 1000L;
    }

    private static class SystemClock
    implements Clock {
        private SystemClock() {
        }

        @Override
        public long currentTimeMs() {
            return System.currentTimeMillis();
        }
    }
}

