/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.parser.NodeLocation;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class BytesLiteral
extends Literal {
    private final byte[] value;

    public BytesLiteral(ByteBuffer value) {
        this(Optional.empty(), value);
    }

    public BytesLiteral(Optional<NodeLocation> location, ByteBuffer value) {
        super(location);
        this.value = new byte[Objects.requireNonNull(value, "value").capacity()];
        value.get(this.value);
    }

    @Override
    public ByteBuffer getValue() {
        return ByteBuffer.wrap(this.value).asReadOnlyBuffer();
    }

    public byte[] getByteArray() {
        return (byte[])this.value.clone();
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitBytesLiteral(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BytesLiteral that = (BytesLiteral)((Object)o);
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

