/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class CreateStructExpression
extends Expression {
    private final ImmutableList<Field> fields;

    public CreateStructExpression(List<Field> fields) {
        this(Optional.empty(), fields);
    }

    public CreateStructExpression(Optional<NodeLocation> location, List<Field> fields) {
        super(location);
        this.fields = ImmutableList.copyOf(fields);
    }

    @Override
    protected <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitStructExpression(this, context);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="fields is ImmutableList")
    public ImmutableList<Field> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CreateStructExpression that = (CreateStructExpression)((Object)o);
        return Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    @Immutable
    public static class Field {
        private final String name;
        private final Expression value;

        public Field(String name, Expression value) {
            this.name = Objects.requireNonNull(name, "name");
            this.value = Objects.requireNonNull(value, "value");
        }

        public String getName() {
            return this.name;
        }

        public Expression getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field field = (Field)o;
            return Objects.equals(this.name, field.name) && Objects.equals((Object)this.value, (Object)field.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.value});
        }

        public String toString() {
            return "Field{name='" + this.name + '\'' + ", value=" + (Object)((Object)this.value) + '}';
        }
    }
}

