/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.function;

import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.function.AggregateFunctionFactory;
import io.confluent.ksql.function.AggregateFunctionInitArguments;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class UdafUtil {
    private UdafUtil() {
    }

    public static KsqlAggregateFunction<?, ?, ?> resolveAggregateFunction(FunctionRegistry functionRegistry, FunctionCall functionCall, LogicalSchema schema, KsqlConfig config) {
        try {
            ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(schema, functionRegistry);
            List args = functionCall.getArguments().stream().map(expressionTypeManager::getExpressionSqlType).collect(Collectors.toList());
            AggregateFunctionFactory.FunctionSource func = functionRegistry.getAggregateFactory(functionCall.getName()).getFunction(args);
            int totalArgs = functionCall.getArguments().size();
            List<Integer> argIndices = functionCall.getArguments().stream().limit(totalArgs - func.initArgs).map(arg -> {
                Optional column;
                if (arg instanceof UnqualifiedColumnReferenceExp) {
                    UnqualifiedColumnReferenceExp colRef = (UnqualifiedColumnReferenceExp)((Object)arg);
                    column = schema.findValueColumn(colRef.getColumnName());
                } else {
                    column = schema.findValueColumn(ColumnName.of((String)arg.toString()));
                }
                return (Column)column.orElseThrow(() -> new KsqlException("Could not find column for expression: " + (Object)arg));
            }).map(Column::index).collect(Collectors.toList());
            return (KsqlAggregateFunction)func.source.apply(UdafUtil.createAggregateFunctionInitArgs(func.initArgs, argIndices, functionCall, config));
        }
        catch (Exception e) {
            throw new KsqlException("Failed to create aggregate function: " + (Object)((Object)functionCall), (Throwable)e);
        }
    }

    public static AggregateFunctionInitArguments createAggregateFunctionInitArgs(int numInitArgs, FunctionCall functionCall) {
        return UdafUtil.createAggregateFunctionInitArgs(numInitArgs, Collections.emptyList(), functionCall, KsqlConfig.empty());
    }

    public static AggregateFunctionInitArguments createAggregateFunctionInitArgs(int numInitArgs, List<Integer> udafIndices, FunctionCall functionCall, KsqlConfig config) {
        List<Expression> args = functionCall.getArguments();
        ArrayList<Object> initArgs = new ArrayList<Object>(numInitArgs);
        for (int idx = args.size() - numInitArgs; idx < args.size(); ++idx) {
            Expression param = args.get(idx);
            if (!(param instanceof Literal)) {
                throw new KsqlException("Parameter " + (idx + 1) + " passed to function " + functionCall.getName().text() + " must be a literal constant, but was expression: '" + (Object)((Object)param) + "'");
            }
            initArgs.add(((Literal)param).getValue());
        }
        Map functionConfig = config.getKsqlFunctionsConfigProps(functionCall.getName().text());
        return new AggregateFunctionInitArguments(udafIndices, functionConfig, initArgs);
    }
}

