/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.types.SqlType;

public class SubscriptTerm
implements Term {
    private final Term baseObjectTerm;
    private final Term subscriptTerm;
    private final SubscriptFunction subscriptFunction;
    private final SqlType sqlType;

    public SubscriptTerm(Term baseObjectTerm, Term subscriptTerm, SubscriptFunction subscriptFunction, SqlType sqlType) {
        this.baseObjectTerm = baseObjectTerm;
        this.subscriptTerm = subscriptTerm;
        this.subscriptFunction = subscriptFunction;
        this.sqlType = sqlType;
    }

    @Override
    public Object getValue(TermEvaluationContext context) {
        return this.subscriptFunction.access(this.baseObjectTerm.getValue(context), this.subscriptTerm.getValue(context));
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    public static interface SubscriptFunction {
        public Object access(Object var1, Object var2);
    }
}

