/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KGroupedStreamHolder;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.PlanInfoExtractor;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.name.ColumnName;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.streams.kstream.Windowed;

@Immutable
public class StreamWindowedAggregate
implements ExecutionStep<KTableHolder<Windowed<GenericKey>>> {
    private final ExecutionStepPropertiesV1 properties;
    private final ExecutionStep<KGroupedStreamHolder> source;
    private final Formats internalFormats;
    private final ImmutableList<ColumnName> nonAggregateColumns;
    private final ImmutableList<FunctionCall> aggregationFunctions;
    private final KsqlWindowExpression windowExpression;

    public StreamWindowedAggregate(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<KGroupedStreamHolder> source, @JsonProperty(value="internalFormats", required=true) Formats internalFormats, @JsonProperty(value="nonAggregateColumns", required=true) List<ColumnName> nonAggregateColumns, @JsonProperty(value="aggregationFunctions", required=true) List<FunctionCall> aggregationFunctions, @JsonProperty(value="windowExpression", required=true) KsqlWindowExpression windowExpression) {
        this.properties = Objects.requireNonNull(props, "props");
        this.source = Objects.requireNonNull(source, "source");
        this.internalFormats = Objects.requireNonNull(internalFormats, "internalFormats");
        this.nonAggregateColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(nonAggregateColumns, "nonAggregateColumns"));
        this.aggregationFunctions = ImmutableList.copyOf((Collection)Objects.requireNonNull(aggregationFunctions, "aggregationFunctions"));
        this.windowExpression = Objects.requireNonNull(windowExpression, "windowExpression");
        if (aggregationFunctions.isEmpty()) {
            throw new IllegalArgumentException("Need at least one aggregate function");
        }
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="aggregationFunctions is ImmutableList")
    public List<FunctionCall> getAggregationFunctions() {
        return this.aggregationFunctions;
    }

    public Formats getInternalFormats() {
        return this.internalFormats;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="nonAggregateColumns is ImmutableList")
    public List<ColumnName> getNonAggregateColumns() {
        return this.nonAggregateColumns;
    }

    public KsqlWindowExpression getWindowExpression() {
        return this.windowExpression;
    }

    public ExecutionStep<KGroupedStreamHolder> getSource() {
        return this.source;
    }

    @Override
    public KTableHolder<Windowed<GenericKey>> build(PlanBuilder builder, PlanInfo info) {
        return builder.visitStreamWindowedAggregate(this, info);
    }

    @Override
    public PlanInfo extractPlanInfo(PlanInfoExtractor extractor) {
        return extractor.visitStreamWindowedAggregate(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamWindowedAggregate that = (StreamWindowedAggregate)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.source, that.source) && Objects.equals(this.internalFormats, that.internalFormats) && Objects.equals(this.aggregationFunctions, that.aggregationFunctions) && Objects.equals((Object)this.windowExpression, (Object)that.windowExpression) && Objects.equals(this.nonAggregateColumns, that.nonAggregateColumns);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.properties, this.source, this.internalFormats, this.aggregationFunctions, this.nonAggregateColumns, this.windowExpression});
    }
}

