/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.util;

import io.confluent.ksql.GenericKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.streams.kstream.Windowed;

public final class KeyUtil {
    private KeyUtil() {
    }

    public static List<Object> asList(Object key) {
        Optional<Windowed> windowed = key instanceof Windowed ? Optional.of((Windowed)key) : Optional.empty();
        Object naturalKey = windowed.map(Windowed::key).orElse(key);
        if (naturalKey != null && !(naturalKey instanceof GenericKey)) {
            throw new IllegalArgumentException("Non generic key: " + key);
        }
        Optional<GenericKey> genericKey = Optional.ofNullable((GenericKey)naturalKey);
        ArrayList<Object> data = new ArrayList<Object>(genericKey.map(GenericKey::size).orElse(0) + (windowed.isPresent() ? 2 : 0));
        genericKey.ifPresent(k -> data.addAll(k.values()));
        windowed.map(Windowed::window).ifPresent(wnd -> {
            data.add(wnd.start());
            data.add(wnd.end());
        });
        return data;
    }
}

