/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.internal.KsqlMetricsExtension;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ServiceInfo {
    private final String serviceId;
    private final String metricsPrefix;
    private final ImmutableMap<String, String> customMetricsTags;
    private final Optional<KsqlMetricsExtension> metricsExtension;

    public static ServiceInfo create(KsqlConfig ksqlConfig) {
        return ServiceInfo.create(ksqlConfig, "");
    }

    public static ServiceInfo create(KsqlConfig ksqlConfig, String metricsPrefix) {
        String serviceId = ksqlConfig.getString("ksql.service.id");
        Map customMetricsTags = ksqlConfig.getStringAsMap("ksql.metrics.tags.custom");
        Optional<Object> metricsExtension = Optional.ofNullable(ksqlConfig.getConfiguredInstance("ksql.metrics.extension", KsqlMetricsExtension.class));
        return new ServiceInfo(serviceId, customMetricsTags, metricsExtension, metricsPrefix);
    }

    private ServiceInfo(String serviceId, Map<String, String> customMetricsTags, Optional<KsqlMetricsExtension> metricsExtension, String metricsPrefix) {
        this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
        this.customMetricsTags = ImmutableMap.copyOf(Objects.requireNonNull(customMetricsTags, "customMetricsTags"));
        this.metricsExtension = Objects.requireNonNull(metricsExtension, "metricsExtension");
        this.metricsPrefix = Objects.requireNonNull(metricsPrefix, "metricsPrefix");
    }

    public String serviceId() {
        return this.serviceId;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="customMetricsTags is ImmutableMap")
    public Map<String, String> customMetricsTags() {
        return this.customMetricsTags;
    }

    public Optional<KsqlMetricsExtension> metricsExtension() {
        return this.metricsExtension;
    }

    public String metricsPrefix() {
        return this.metricsPrefix;
    }
}

