/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.connect;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.metastore.model.DataSource;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class Connector {
    private final String name;
    private final DataSource.DataSourceType sourceType;
    private final Optional<String> keyField;

    public Connector(String name, DataSource.DataSourceType sourceType, String keyField) {
        this.name = Objects.requireNonNull(name, "name");
        this.sourceType = Objects.requireNonNull(sourceType, "sourceType");
        this.keyField = Optional.ofNullable(keyField);
    }

    public String getName() {
        return this.name;
    }

    public DataSource.DataSourceType getSourceType() {
        return this.sourceType;
    }

    public Optional<String> getKeyField() {
        return this.keyField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connector that = (Connector)o;
        return Objects.equals(this.name, that.name) && this.sourceType == that.sourceType && Objects.equals(this.keyField, that.keyField);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.sourceType, this.keyField);
    }

    public String toString() {
        return "Connector{name='" + this.name + '\'' + ", sourceType=" + this.sourceType + ", keyField=" + this.keyField + '}';
    }
}

