/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine;

import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.ddl.commands.CommandFactories;
import io.confluent.ksql.ddl.commands.DdlCommandExec;
import io.confluent.ksql.engine.QueryCleanupService;
import io.confluent.ksql.engine.QueryEngine;
import io.confluent.ksql.engine.QueryEventListener;
import io.confluent.ksql.engine.RuntimeAssignor;
import io.confluent.ksql.engine.rewrite.AstSanitizer;
import io.confluent.ksql.execution.ddl.commands.DdlCommand;
import io.confluent.ksql.execution.ddl.commands.DdlCommandResult;
import io.confluent.ksql.execution.ddl.commands.DropSourceCommand;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.MutableMetaStore;
import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.DefaultKsqlParser;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.VariableSubstitutor;
import io.confluent.ksql.parser.tree.DdlStatement;
import io.confluent.ksql.parser.tree.ExecutableDdlStatement;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.planner.plan.KsqlStructuredDataOutputNode;
import io.confluent.ksql.query.KafkaStreamsQueryValidator;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.query.QueryRegistry;
import io.confluent.ksql.query.QueryRegistryImpl;
import io.confluent.ksql.query.QueryValidator;
import io.confluent.ksql.query.id.QueryIdGenerator;
import io.confluent.ksql.serde.RefinementInfo;
import io.confluent.ksql.services.SandboxedServiceContext;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.BinPackedPersistentQueryMetadataImpl;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlReferentialIntegrityException;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

final class EngineContext {
    private static final BiPredicate<SourceName, PersistentQueryMetadata> FILTER_QUERIES_WITH_SINK = (sourceName, query) -> query.getSinkName().equals(Optional.of(sourceName));
    private static final BiPredicate<SourceName, PersistentQueryMetadata> FILTER_QUERIES_WITH_SOURCE = (sourceName, query) -> query.getSourceNames().contains(sourceName);
    private final MutableMetaStore metaStore;
    private final ServiceContext serviceContext;
    private final CommandFactories ddlCommandFactory;
    private final DdlCommandExec ddlCommandExec;
    private final QueryIdGenerator queryIdGenerator;
    private final ProcessingLogContext processingLogContext;
    private final KsqlParser parser;
    private final QueryCleanupService cleanupService;
    private final QueryRegistry queryRegistry;
    private final RuntimeAssignor runtimeAssignor;
    private KsqlConfig ksqlConfig;

    static EngineContext create(ServiceContext serviceContext, ProcessingLogContext processingLogContext, MutableMetaStore metaStore, QueryIdGenerator queryIdGenerator, QueryCleanupService cleanupService, KsqlConfig ksqlConfig, Collection<QueryEventListener> registrationListeners, MetricCollectors metricCollectors) {
        return new EngineContext(serviceContext, processingLogContext, metaStore, queryIdGenerator, (KsqlParser)new DefaultKsqlParser(), cleanupService, ksqlConfig, new QueryRegistryImpl(registrationListeners, metricCollectors), new RuntimeAssignor(ksqlConfig));
    }

    private EngineContext(ServiceContext serviceContext, ProcessingLogContext processingLogContext, MutableMetaStore metaStore, QueryIdGenerator queryIdGenerator, KsqlParser parser, QueryCleanupService cleanupService, KsqlConfig ksqlConfig, QueryRegistry queryRegistry, RuntimeAssignor runtimeAssignor) {
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
        this.queryIdGenerator = Objects.requireNonNull(queryIdGenerator, "queryIdGenerator");
        this.ddlCommandFactory = new CommandFactories(serviceContext, (MetaStore)metaStore);
        this.ddlCommandExec = new DdlCommandExec(metaStore);
        this.processingLogContext = Objects.requireNonNull(processingLogContext, "processingLogContext");
        this.parser = Objects.requireNonNull(parser, "parser");
        this.cleanupService = Objects.requireNonNull(cleanupService, "cleanupService");
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.queryRegistry = Objects.requireNonNull(queryRegistry, "queryRegistry");
        this.runtimeAssignor = Objects.requireNonNull(runtimeAssignor, "runtimeAssignor");
    }

    synchronized EngineContext createSandbox(ServiceContext serviceContext) {
        this.runtimeAssignor.rebuildAssignment(this.queryRegistry.getPersistentQueries().values());
        return new EngineContext(SandboxedServiceContext.create(serviceContext), ProcessingLogContext.create(), this.metaStore.copy(), this.queryIdGenerator.createSandbox(), (KsqlParser)new DefaultKsqlParser(), this.cleanupService, this.ksqlConfig, this.queryRegistry.createSandbox(), this.runtimeAssignor.createSandbox());
    }

    MutableMetaStore getMetaStore() {
        return this.metaStore;
    }

    ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    ProcessingLogContext getProcessingLogContext() {
        return this.processingLogContext;
    }

    List<KsqlParser.ParsedStatement> parse(String sql) {
        return this.parser.parse(sql);
    }

    QueryIdGenerator idGenerator() {
        return this.queryIdGenerator;
    }

    QueryRegistry getQueryRegistry() {
        return this.queryRegistry;
    }

    RuntimeAssignor getRuntimeAssignor() {
        return this.runtimeAssignor;
    }

    synchronized KsqlConfig getKsqlConfig() {
        return this.ksqlConfig;
    }

    synchronized void configure(KsqlConfig config) {
        this.ksqlConfig = config;
    }

    synchronized void alterSystemProperty(Map<String, String> overrides) {
        this.ksqlConfig = this.ksqlConfig.cloneWithPropertyOverwrite(overrides);
    }

    private KsqlParser.ParsedStatement substituteVariables(KsqlParser.ParsedStatement stmt, Map<String, String> variablesMap) {
        return !variablesMap.isEmpty() ? this.parse(VariableSubstitutor.substitute((KsqlParser.ParsedStatement)stmt, variablesMap)).get(0) : stmt;
    }

    synchronized KsqlParser.PreparedStatement<?> prepare(KsqlParser.ParsedStatement stmt, Map<String, String> variablesMap) {
        try {
            KsqlParser.PreparedStatement preparedStatement = this.parser.prepare(this.substituteVariables(stmt, variablesMap), (TypeRegistry)this.metaStore);
            return KsqlParser.PreparedStatement.of((String)preparedStatement.getUnMaskedStatementText(), (Statement)AstSanitizer.sanitize(preparedStatement.getStatement(), (MetaStore)this.metaStore, this.ksqlConfig.getBoolean("ksql.lambdas.enabled")));
        }
        catch (KsqlStatementException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KsqlStatementException("Exception while preparing statement: " + e.getMessage(), stmt.getMaskedStatementText(), (Throwable)e);
        }
    }

    QueryEngine createQueryEngine(ServiceContext serviceContext) {
        return new QueryEngine(serviceContext, this.processingLogContext);
    }

    QueryValidator createQueryValidator() {
        return new KafkaStreamsQueryValidator();
    }

    DdlCommand createDdlCommand(String sqlExpression, ExecutableDdlStatement statement, SessionConfig config) {
        return this.ddlCommandFactory.create(sqlExpression, (DdlStatement)statement, config);
    }

    DdlCommand createDdlCommand(KsqlStructuredDataOutputNode outputNode, Optional<RefinementInfo> emitStrategy) {
        return this.ddlCommandFactory.create(outputNode, emitStrategy);
    }

    String executeDdl(String sqlExpression, DdlCommand command, boolean withQuery, Set<SourceName> withQuerySources, boolean restoreInProgress) {
        DdlCommandResult result;
        if (command instanceof DropSourceCommand && !restoreInProgress) {
            this.throwIfInsertQueriesExist(((DropSourceCommand)command).getSourceName());
        }
        if (!(result = this.ddlCommandExec.execute(sqlExpression, command, withQuery, withQuerySources, restoreInProgress)).isSuccess()) {
            throw new KsqlStatementException(result.getMessage(), sqlExpression);
        }
        if (command instanceof DropSourceCommand) {
            this.maybeTerminateCreateAsQuery(((DropSourceCommand)command).getSourceName());
        }
        return result.getMessage();
    }

    private void maybeTerminateCreateAsQuery(SourceName sourceName) {
        this.queryRegistry.getCreateAsQuery(sourceName).ifPresent(t -> {
            t.close();
            if (t instanceof BinPackedPersistentQueryMetadataImpl) {
                this.runtimeAssignor.dropQuery((BinPackedPersistentQueryMetadataImpl)t);
            }
        });
    }

    private void throwIfInsertQueriesExist(SourceName sourceName) {
        Set<QueryId> sinkQueries = this.queryRegistry.getInsertQueries(sourceName, FILTER_QUERIES_WITH_SINK);
        Set<QueryId> sourceQueries = this.queryRegistry.getInsertQueries(sourceName, FILTER_QUERIES_WITH_SOURCE);
        if (!sinkQueries.isEmpty() || !sourceQueries.isEmpty()) {
            throw new KsqlReferentialIntegrityException(String.format("Cannot drop %s.%nThe following queries read from this source: [%s].%nThe following queries write into this source: [%s].%nYou need to terminate them before dropping %s.", sourceName.text(), sourceQueries.stream().map(QueryId::toString).sorted().collect(Collectors.joining(", ")), sinkQueries.stream().map(QueryId::toString).sorted().collect(Collectors.joining(", ")), sourceName.text()));
        }
    }
}

