/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.ServiceInfo;
import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.analyzer.QueryAnalyzer;
import io.confluent.ksql.analyzer.RewrittenAnalysis;
import io.confluent.ksql.engine.EngineContext;
import io.confluent.ksql.engine.EngineExecutor;
import io.confluent.ksql.engine.KsqlPlan;
import io.confluent.ksql.engine.OrphanedTransientQueryCleaner;
import io.confluent.ksql.engine.QueryCleanupService;
import io.confluent.ksql.engine.QueryEventListener;
import io.confluent.ksql.engine.QueryExecutionUtil;
import io.confluent.ksql.engine.SandboxedExecutionContext;
import io.confluent.ksql.engine.TransientQueryCleanupService;
import io.confluent.ksql.execution.pull.HARouting;
import io.confluent.ksql.execution.pull.PullQueryResult;
import io.confluent.ksql.execution.scalablepush.PushRouting;
import io.confluent.ksql.execution.scalablepush.PushRoutingOptions;
import io.confluent.ksql.execution.streams.RoutingOptions;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.internal.KsqlEngineMetrics;
import io.confluent.ksql.internal.PullQueryExecutorMetrics;
import io.confluent.ksql.internal.ScalablePushQueryMetrics;
import io.confluent.ksql.internal.TransientQueryCleanupListener;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.logging.query.QueryLogger;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.MetaStoreImpl;
import io.confluent.ksql.metastore.MutableMetaStore;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.metrics.StreamsErrorCollector;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.ExecutableDdlStatement;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.QueryContainer;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.planner.QueryPlannerOptions;
import io.confluent.ksql.planner.plan.ConfiguredKsqlPlan;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.query.id.QueryIdGenerator;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.BinPackedPersistentQueryMetadataImpl;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlConfigurable;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlServerException;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import io.confluent.ksql.util.ScalablePushQueryMetadata;
import io.confluent.ksql.util.StreamPullQueryMetadata;
import io.confluent.ksql.util.TransientQueryMetadata;
import io.vertx.core.Context;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.StreamsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlEngine
implements KsqlExecutionContext,
Closeable,
KsqlConfigurable {
    private static final Logger log = LoggerFactory.getLogger(KsqlEngine.class);
    private final KsqlEngineMetrics engineMetrics;
    private final ScheduledExecutorService aggregateMetricsCollector;
    private final String serviceId;
    private final EngineContext primaryContext;
    private final QueryCleanupService cleanupService = new QueryCleanupService();
    private final OrphanedTransientQueryCleaner orphanedTransientQueryCleaner;
    private final MetricCollectors metricCollectors;
    private TransientQueryCleanupService transientQueryCleanupService;

    public KsqlEngine(ServiceContext serviceContext, ProcessingLogContext processingLogContext, FunctionRegistry functionRegistry, ServiceInfo serviceInfo, QueryIdGenerator queryIdGenerator, KsqlConfig ksqlConfig, List<QueryEventListener> queryEventListeners, MetricCollectors metricCollectors) {
        this(serviceContext, processingLogContext, serviceInfo.serviceId(), (MutableMetaStore)new MetaStoreImpl(functionRegistry), engine -> new KsqlEngineMetrics(serviceInfo.metricsPrefix(), (KsqlEngine)engine, serviceInfo.customMetricsTags(), serviceInfo.metricsExtension(), metricCollectors), queryIdGenerator, ksqlConfig, queryEventListeners, metricCollectors);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public KsqlEngine(ServiceContext serviceContext, ProcessingLogContext processingLogContext, String serviceId, MutableMetaStore metaStore, Function<KsqlEngine, KsqlEngineMetrics> engineMetricsFactory, QueryIdGenerator queryIdGenerator, KsqlConfig ksqlConfig, List<QueryEventListener> queryEventListeners, MetricCollectors metricCollectors) {
        this.orphanedTransientQueryCleaner = new OrphanedTransientQueryCleaner(this.cleanupService, ksqlConfig);
        this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
        this.engineMetrics = engineMetricsFactory.apply(this);
        ImmutableList.Builder registrationListeners = ImmutableList.builder().addAll(queryEventListeners).add((Object)this.engineMetrics.getQueryEventListener()).add((Object)new CleanupListener(this.cleanupService, serviceContext, ksqlConfig));
        if (this.getTransientQueryCleanupServiceEnabled(ksqlConfig)) {
            this.transientQueryCleanupService = new TransientQueryCleanupService(serviceContext, ksqlConfig);
            registrationListeners.add((Object)new TransientQueryCleanupListener(this.transientQueryCleanupService));
        }
        this.primaryContext = EngineContext.create(serviceContext, processingLogContext, metaStore, queryIdGenerator, this.cleanupService, ksqlConfig, (Collection<QueryEventListener>)registrationListeners.build(), metricCollectors);
        this.aggregateMetricsCollector = Executors.newSingleThreadScheduledExecutor();
        this.aggregateMetricsCollector.scheduleAtFixedRate(() -> {
            try {
                this.engineMetrics.updateMetrics();
            }
            catch (Exception e) {
                log.info("Error updating engine metrics", (Throwable)e);
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        this.metricCollectors = metricCollectors;
        this.cleanupService.startAsync();
        if (this.getTransientQueryCleanupServiceEnabled(ksqlConfig)) {
            this.transientQueryCleanupService.setQueryRegistry(this.primaryContext.getQueryRegistry());
            this.transientQueryCleanupService.startAsync();
        }
    }

    public int numberOfLiveQueries() {
        return this.primaryContext.getQueryRegistry().getAllLiveQueries().size();
    }

    @Override
    public Optional<PersistentQueryMetadata> getPersistentQuery(QueryId queryId) {
        return this.primaryContext.getQueryRegistry().getPersistentQuery(queryId);
    }

    @Override
    public Optional<QueryMetadata> getQuery(QueryId queryId) {
        return this.primaryContext.getQueryRegistry().getQuery(queryId);
    }

    @Override
    public List<PersistentQueryMetadata> getPersistentQueries() {
        return ImmutableList.copyOf(this.primaryContext.getQueryRegistry().getPersistentQueries().values());
    }

    @Override
    public Set<QueryId> getQueriesWithSink(SourceName sourceName) {
        return this.primaryContext.getQueryRegistry().getQueriesWithSink(sourceName);
    }

    @Override
    public List<QueryMetadata> getAllLiveQueries() {
        return this.primaryContext.getQueryRegistry().getAllLiveQueries();
    }

    public boolean hasActiveQueries() {
        return !this.primaryContext.getQueryRegistry().getPersistentQueries().isEmpty();
    }

    @Override
    public void updateStreamsPropertiesAndRestartRuntime() {
        KsqlConfig config = this.primaryContext.getKsqlConfig();
        ProcessingLogContext logContext = this.primaryContext.getProcessingLogContext();
        this.primaryContext.getQueryRegistry().updateStreamsPropertiesAndRestartRuntime(config, logContext);
    }

    @Override
    public MetaStore getMetaStore() {
        return this.primaryContext.getMetaStore();
    }

    @Override
    public ServiceContext getServiceContext() {
        return this.primaryContext.getServiceContext();
    }

    @Override
    public ProcessingLogContext getProcessingLogContext() {
        return this.primaryContext.getProcessingLogContext();
    }

    public String getServiceId() {
        return this.serviceId;
    }

    @VisibleForTesting
    QueryCleanupService getCleanupService() {
        return this.cleanupService;
    }

    @VisibleForTesting
    public KsqlEngineMetrics getEngineMetrics() {
        return this.engineMetrics;
    }

    @Override
    public KsqlExecutionContext createSandbox(ServiceContext serviceContext) {
        return new SandboxedExecutionContext(this.primaryContext, serviceContext, this.metricCollectors);
    }

    @Override
    public List<KsqlParser.ParsedStatement> parse(String sql) {
        return this.primaryContext.parse(sql);
    }

    @Override
    public KsqlParser.PreparedStatement<?> prepare(KsqlParser.ParsedStatement stmt, Map<String, String> variablesMap) {
        return this.primaryContext.prepare(stmt, variablesMap);
    }

    @Override
    public KsqlPlan plan(ServiceContext serviceContext, ConfiguredStatement<?> statement) {
        return EngineExecutor.create(this.primaryContext, serviceContext, statement.getSessionConfig()).plan(statement);
    }

    @Override
    public KsqlExecutionContext.ExecuteResult execute(ServiceContext serviceContext, ConfiguredKsqlPlan plan, boolean restoreInProgress) {
        try {
            KsqlExecutionContext.ExecuteResult result = EngineExecutor.create(this.primaryContext, serviceContext, plan.getConfig()).execute(plan.getPlan(), restoreInProgress);
            return result;
        }
        catch (KsqlStatementException e) {
            throw e;
        }
        catch (KsqlException e) {
            throw new KsqlStatementException(e.getMessage(), e.getMessage(), plan.getPlan().getStatementText(), e.getCause());
        }
    }

    @Override
    public KsqlExecutionContext.ExecuteResult execute(ServiceContext serviceContext, ConfiguredStatement<?> statement) {
        return this.execute(serviceContext, ConfiguredKsqlPlan.of(this.plan(serviceContext, statement), statement.getSessionConfig()));
    }

    @Override
    public TransientQueryMetadata executeTransientQuery(ServiceContext serviceContext, ConfiguredStatement<Query> statement, boolean excludeTombstones) {
        try {
            TransientQueryMetadata query = EngineExecutor.create(this.primaryContext, serviceContext, statement.getSessionConfig()).executeTransientQuery(statement, excludeTombstones);
            return query;
        }
        catch (KsqlStatementException e) {
            throw e;
        }
        catch (KsqlException e) {
            throw new KsqlStatementException(e.getMessage(), statement.getMaskedStatementText(), e.getCause());
        }
    }

    @Override
    public KsqlConfig getKsqlConfig() {
        return this.primaryContext.getKsqlConfig();
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="metrics")
    public MetricCollectors metricCollectors() {
        return this.metricCollectors;
    }

    @Override
    public void configure(KsqlConfig config) {
        if (!config.getKsqlStreamConfigProps().containsKey("application.server")) {
            throw new IllegalArgumentException("Need KS application server set");
        }
        this.primaryContext.configure(config);
    }

    @Override
    public void alterSystemProperty(String propertyName, String propertyValue) {
        ImmutableMap overrides = ImmutableMap.of((Object)propertyName, (Object)propertyValue);
        this.primaryContext.alterSystemProperty((Map<String, String>)overrides);
    }

    @Override
    public StreamPullQueryMetadata createStreamPullQuery(ServiceContext serviceContext, ImmutableAnalysis analysis, ConfiguredStatement<Query> statementOrig, boolean excludeTombstones) {
        boolean streamPullQueriesEnabled = statementOrig.getSessionConfig().getConfig(true).getBoolean("ksql.query.pull.stream.enabled");
        if (!streamPullQueriesEnabled) {
            throw new KsqlStatementException("Pull queries on streams are disabled. To create a push query on the stream, add EMIT CHANGES to the end. To enable pull queries on streams, set the ksql.query.pull.stream.enabled config to 'true'.", statementOrig.getMaskedStatementText());
        }
        HashMap<String, Object> overrides = new HashMap<String, Object>(statementOrig.getSessionConfig().getOverrides());
        overrides.put("auto.offset.reset", "earliest");
        overrides.put("num.stream.threads", 1);
        overrides.put("processing.guarantee", "at_least_once");
        ConfiguredStatement<Query> statement = statementOrig.withConfigOverrides(overrides);
        ImmutableMap<TopicPartition, Long> endOffsets = this.getQueryInputEndOffsets(analysis, serviceContext.getAdminClient());
        TransientQueryMetadata transientQueryMetadata = EngineExecutor.create(this.primaryContext, serviceContext, statement.getSessionConfig()).executeStreamPullQuery(statement, excludeTombstones, endOffsets);
        QueryLogger.info((Object)("Streaming stream pull query results '{}' from earliest to " + endOffsets), statement.getMaskedStatementText());
        return new StreamPullQueryMetadata(transientQueryMetadata, endOffsets);
    }

    private ImmutableMap<TopicPartition, Long> getQueryInputEndOffsets(ImmutableAnalysis analysis, Admin admin) {
        String sourceTopicName = analysis.getFrom().getDataSource().getKafkaTopicName();
        TopicDescription topicDescription = this.getTopicDescription(admin, sourceTopicName);
        return this.getEndOffsetsForStreamPullQuery(admin, topicDescription);
    }

    private TopicDescription getTopicDescription(Admin admin, String sourceTopicName) {
        KafkaFuture topicDescriptionKafkaFuture = (KafkaFuture)admin.describeTopics(Collections.singletonList(sourceTopicName)).topicNameValues().get(sourceTopicName);
        try {
            return (TopicDescription)topicDescriptionKafkaFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Admin#describeTopics(" + sourceTopicName + ") interrupted", (Throwable)e);
            throw new KsqlServerException("Interrupted");
        }
        catch (ExecutionException e) {
            log.error("Error executing Admin#describeTopics(" + sourceTopicName + ")", (Throwable)e);
            throw new KsqlServerException("Internal Server Error");
        }
        catch (TimeoutException e) {
            log.error("Admin#describeTopics(" + sourceTopicName + ") timed out", (Throwable)e);
            throw new KsqlServerException("Backend timed out");
        }
    }

    private ImmutableMap<TopicPartition, Long> getEndOffsetsForStreamPullQuery(Admin admin, TopicDescription topicDescription) {
        Map topicPartitions = topicDescription.partitions().stream().map(td -> new TopicPartition(topicDescription.name(), td.partition())).collect(Collectors.toMap(UnaryOperator.identity(), tp -> OffsetSpec.latest()));
        ListOffsetsResult listOffsetsResult = admin.listOffsets(topicPartitions, new ListOffsetsOptions(IsolationLevel.READ_UNCOMMITTED));
        ImmutableMap<TopicPartition, Long> startOffsetsForStreamPullQuery = this.getStartOffsetsForStreamPullQuery(admin, topicDescription);
        try {
            Map partitionResultMap = (Map)listOffsetsResult.all().get(10L, TimeUnit.SECONDS);
            Map<TopicPartition, Long> result = partitionResultMap.entrySet().stream().filter(e -> ((ListOffsetsResult.ListOffsetsResultInfo)e.getValue()).offset() > 0L && ((ListOffsetsResult.ListOffsetsResultInfo)e.getValue()).offset() > (Long)startOffsetsForStreamPullQuery.get(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((ListOffsetsResult.ListOffsetsResultInfo)e.getValue()).offset()));
            return ImmutableMap.copyOf(result);
        }
        catch (InterruptedException e2) {
            log.error("Admin#listOffsets(" + topicDescription.name() + ") interrupted", (Throwable)e2);
            throw new KsqlServerException("Interrupted");
        }
        catch (ExecutionException e3) {
            log.error("Error executing Admin#listOffsets(" + topicDescription.name() + ")", (Throwable)e3);
            throw new KsqlServerException("Internal Server Error");
        }
        catch (TimeoutException e4) {
            log.error("Admin#listOffsets(" + topicDescription.name() + ") timed out", (Throwable)e4);
            throw new KsqlServerException("Backend timed out");
        }
    }

    private ImmutableMap<TopicPartition, Long> getStartOffsetsForStreamPullQuery(Admin admin, TopicDescription topicDescription) {
        Map topicPartitions = topicDescription.partitions().stream().map(td -> new TopicPartition(topicDescription.name(), td.partition())).collect(Collectors.toMap(UnaryOperator.identity(), tp -> OffsetSpec.earliest()));
        ListOffsetsResult listOffsetsResult = admin.listOffsets(topicPartitions, new ListOffsetsOptions(IsolationLevel.READ_UNCOMMITTED));
        try {
            Map partitionResultMap = (Map)listOffsetsResult.all().get(10L, TimeUnit.SECONDS);
            Map<TopicPartition, Long> result = partitionResultMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ListOffsetsResult.ListOffsetsResultInfo)e.getValue()).offset()));
            return ImmutableMap.copyOf(result);
        }
        catch (InterruptedException e2) {
            log.error("Admin#listOffsets(" + topicDescription.name() + ") interrupted", (Throwable)e2);
            throw new KsqlServerException("Interrupted");
        }
        catch (ExecutionException e3) {
            log.error("Error executing Admin#listOffsets(" + topicDescription.name() + ")", (Throwable)e3);
            throw new KsqlServerException("Internal Server Error");
        }
        catch (TimeoutException e4) {
            log.error("Admin#listOffsets(" + topicDescription.name() + ") timed out", (Throwable)e4);
            throw new KsqlServerException("Backend timed out");
        }
    }

    @Override
    public ScalablePushQueryMetadata executeScalablePushQuery(ImmutableAnalysis analysis, ServiceContext serviceContext, ConfiguredStatement<Query> statement, PushRouting pushRouting, PushRoutingOptions pushRoutingOptions, QueryPlannerOptions queryPlannerOptions, Context context, Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics) {
        ScalablePushQueryMetadata query = EngineExecutor.create(this.primaryContext, serviceContext, statement.getSessionConfig()).executeScalablePushQuery(analysis, statement, pushRouting, pushRoutingOptions, queryPlannerOptions, context, scalablePushQueryMetrics);
        return query;
    }

    @Override
    public PullQueryResult executeTablePullQuery(ImmutableAnalysis analysis, ServiceContext serviceContext, ConfiguredStatement<Query> statement, HARouting routing, RoutingOptions routingOptions, QueryPlannerOptions plannerOptions, Optional<PullQueryExecutorMetrics> pullQueryMetrics, boolean startImmediately, Optional<ConsistencyOffsetVector> consistencyOffsetVector) {
        return EngineExecutor.create(this.primaryContext, serviceContext, statement.getSessionConfig()).executeTablePullQuery(analysis, statement, routing, routingOptions, plannerOptions, pullQueryMetrics, startImmediately, consistencyOffsetVector);
    }

    public void close(boolean closeQueries) {
        this.primaryContext.getQueryRegistry().close(closeQueries);
        try {
            this.cleanupService.stopAsync().awaitTerminated(this.primaryContext.getKsqlConfig().getLong("ksql.query.cleanup.shutdown.timeout.ms").longValue(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("Timed out while closing cleanup service. External resources for the following applications may be orphaned: {}", this.cleanupService.pendingApplicationIds());
        }
        this.engineMetrics.close();
        this.aggregateMetricsCollector.shutdown();
    }

    @Override
    public void close() {
        if (this.getTransientQueryCleanupServiceEnabled(this.getKsqlConfig())) {
            this.transientQueryCleanupService.stopAsync();
        }
        this.close(false);
    }

    public void removeQueryFromAssignor(PersistentQueryMetadata query) {
        this.primaryContext.getRuntimeAssignor().dropQuery(query);
    }

    public void cleanupOrphanedInternalTopics(ServiceContext serviceContext, Set<String> queryApplicationIds) {
        this.orphanedTransientQueryCleaner.cleanupOrphanedInternalTopics(serviceContext, queryApplicationIds);
    }

    public void populateTransientQueryCleanupServiceWithOldCommands(Set<String> queryApplicationIds) {
        this.transientQueryCleanupService.setLocalCommandsQueryAppIds(queryApplicationIds);
    }

    public static boolean isExecutableStatement(Statement statement) {
        return statement instanceof ExecutableDdlStatement || statement instanceof QueryContainer || statement instanceof Query;
    }

    @Override
    public ImmutableAnalysis analyzeQueryWithNoOutputTopic(Query query, String queryText, Map<String, Object> configOverrides) {
        Analysis analysis;
        KsqlConfig ksqlConfig = this.primaryContext.getKsqlConfig();
        QueryAnalyzer queryAnalyzer = new QueryAnalyzer(this.getMetaStore(), "", ksqlConfig.getBoolean("ksql.query.pull.limit.clause.enabled"));
        try {
            analysis = queryAnalyzer.analyze(query, Optional.empty());
        }
        catch (KsqlException e) {
            throw new KsqlStatementException(e.getMessage(), queryText, (Throwable)e);
        }
        return new RewrittenAnalysis(analysis, (arg_0, arg_1) -> ((QueryExecutionUtil.ColumnReferenceRewriter)new QueryExecutionUtil.ColumnReferenceRewriter()).process(arg_0, arg_1));
    }

    public int reportNumberOfLeakedTopics() {
        return this.transientQueryCleanupService.getNumLeakedTopics();
    }

    public int reportNumberOfLeakedStateDirs() {
        return this.transientQueryCleanupService.getNumLeakedStateDirs();
    }

    public int reportNumLeakedTopicsAfterCleanup() {
        return this.transientQueryCleanupService.getNumLeakedTopicsFailedToCleanUp();
    }

    public int reportNumLeakedStateDirsAfterCleanup() {
        return this.transientQueryCleanupService.getNumLeakedStateDirsFailedToCleanUp();
    }

    private boolean getTransientQueryCleanupServiceEnabled(KsqlConfig ksqlConfig) {
        return ksqlConfig.getBoolean("ksql.transient.query.cleanup.service.enable");
    }

    private static final class CleanupListener
    implements QueryEventListener {
        final QueryCleanupService cleanupService;
        final ServiceContext serviceContext;
        final KsqlConfig ksqlConfig;

        private CleanupListener(QueryCleanupService cleanupService, ServiceContext serviceContext, KsqlConfig ksqlConfig) {
            this.cleanupService = cleanupService;
            this.serviceContext = serviceContext;
            this.ksqlConfig = ksqlConfig;
        }

        @Override
        public void onClose(QueryMetadata query) {
            String applicationId = query.getQueryApplicationId();
            Optional<String> topologyName = Optional.empty();
            if (query instanceof BinPackedPersistentQueryMetadataImpl) {
                topologyName = Optional.of(query.getQueryId().toString());
            }
            if (query.hasEverBeenStarted()) {
                log.info("Cleaning up after query {}", (Object)applicationId);
                this.cleanupService.addCleanupTask(new QueryCleanupService.QueryCleanupTask(this.serviceContext, applicationId, topologyName, query instanceof TransientQueryMetadata, this.ksqlConfig.getKsqlStreamConfigProps().getOrDefault("state.dir", StreamsConfig.configDef().defaultValues().get("state.dir")).toString(), this.ksqlConfig.getString("ksql.service.id"), this.ksqlConfig.getString("ksql.persistent.prefix")));
            } else {
                log.info("Skipping cleanup for query {} since it was never started", (Object)applicationId);
            }
            Object o = query.getStreamsProperties().get("ksql.internal.streams.error.collector");
            if (o instanceof StreamsErrorCollector) {
                ((StreamsErrorCollector)o).cleanup();
            }
        }
    }
}

