/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine;

import com.google.common.collect.Iterables;
import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.analyzer.PullQueryValidator;
import io.confluent.ksql.engine.EngineContext;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import java.util.Set;

public final class PullQueryExecutionUtil {
    private PullQueryExecutionUtil() {
    }

    static PersistentQueryMetadata findMaterializingQuery(EngineContext engineContext, ImmutableAnalysis analysis) {
        DataSource source = analysis.getFrom().getDataSource();
        SourceName sourceName = source.getName();
        Set<QueryId> queries = engineContext.getQueryRegistry().getQueriesWithSink(sourceName);
        if (source.getDataSourceType() != DataSource.DataSourceType.KTABLE) {
            throw new KsqlException("Unexpected data source type for table pull query: " + source.getDataSourceType() + " " + PullQueryValidator.PULL_QUERY_SYNTAX_HELP);
        }
        if (queries.isEmpty()) {
            throw PullQueryExecutionUtil.notMaterializedException(sourceName);
        }
        if (queries.size() > 1) {
            throw new IllegalStateException("Tables do not support multiple queries writing into them, yet somehow this happened. Source Name: " + sourceName + " Queries: " + queries + ". Please submit a GitHub issue with the queries that were run.");
        }
        QueryId queryId = (QueryId)Iterables.getOnlyElement(queries);
        return engineContext.getQueryRegistry().getPersistentQuery(queryId).orElseThrow(() -> new KsqlException("Materializing query has been stopped"));
    }

    private static KsqlException notMaterializedException(SourceName sourceTable) {
        String tableName = sourceTable.toString().replaceAll("`", "");
        return new KsqlException("The " + sourceTable + " table isn't queryable. To derive a queryable table, you can do 'CREATE TABLE QUERYABLE_" + tableName + " AS SELECT * FROM " + tableName + "'." + PullQueryValidator.PULL_QUERY_SYNTAX_HELP);
    }
}

