/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine;

import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.analyzer.QueryAnalyzer;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.execution.ExecutionPlan;
import io.confluent.ksql.execution.ExecutionPlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.Sink;
import io.confluent.ksql.planner.LogicalPlanNode;
import io.confluent.ksql.planner.LogicalPlanner;
import io.confluent.ksql.planner.plan.OutputNode;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlStatementException;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.streams.StreamsBuilder;

class QueryEngine {
    private final ServiceContext serviceContext;
    private final ProcessingLogContext processingLogContext;

    QueryEngine(ServiceContext serviceContext, ProcessingLogContext processingLogContext) {
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.processingLogContext = Objects.requireNonNull(processingLogContext, "processingLogContext");
    }

    static OutputNode buildQueryLogicalPlan(Query query, Optional<Sink> sink, MetaStore metaStore, KsqlConfig config, String statementTextMasked) {
        Analysis analysis;
        String outputPrefix = config.getString("ksql.output.topic.name.prefix");
        Boolean pullLimitClauseEnabled = config.getBoolean("ksql.query.pull.limit.clause.enabled");
        QueryAnalyzer queryAnalyzer = new QueryAnalyzer(metaStore, outputPrefix, pullLimitClauseEnabled);
        try {
            analysis = queryAnalyzer.analyze(query, sink);
        }
        catch (KsqlException e) {
            throw new KsqlStatementException(e.getMessage(), statementTextMasked, (Throwable)e);
        }
        return new LogicalPlanner(config, analysis, metaStore).buildPersistentLogicalPlan();
    }

    ExecutionPlan buildPhysicalPlan(LogicalPlanNode logicalPlanNode, SessionConfig config, MetaStore metaStore, QueryId queryId, Optional<PlanInfo> oldPlanInfo) {
        StreamsBuilder builder = new StreamsBuilder();
        ExecutionPlanBuilder executionPlanBuilder = new ExecutionPlanBuilder(builder, config.getConfig(true), this.serviceContext, this.processingLogContext, (FunctionRegistry)metaStore);
        return executionPlanBuilder.buildPhysicalPlan(logicalPlanNode, queryId, oldPlanInfo);
    }
}

