/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.util.BinPackedPersistentQueryMetadataImpl;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryApplicationId;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeAssignor {
    private final Map<String, Collection<String>> runtimesToSourceTopics;
    private final Map<QueryId, String> idToRuntime;
    private final Logger log = LoggerFactory.getLogger(RuntimeAssignor.class);
    private final int numDefaultRuntimes;

    public RuntimeAssignor(KsqlConfig config) {
        this.runtimesToSourceTopics = new HashMap<String, Collection<String>>();
        this.idToRuntime = new HashMap<QueryId, String>();
        this.numDefaultRuntimes = config.getInt("ksql.shared.runtimes.count");
        for (int i = 0; i < this.numDefaultRuntimes; ++i) {
            String runtime = QueryApplicationId.buildSharedRuntimeId((KsqlConfig)config, (boolean)true, (int)i);
            this.runtimesToSourceTopics.put(runtime, new HashSet());
        }
    }

    private RuntimeAssignor(RuntimeAssignor other) {
        this.numDefaultRuntimes = other.numDefaultRuntimes;
        this.runtimesToSourceTopics = new HashMap<String, Collection<String>>();
        this.idToRuntime = new HashMap<QueryId, String>(other.idToRuntime);
        for (Map.Entry<String, Collection<String>> runtime : other.runtimesToSourceTopics.entrySet()) {
            this.runtimesToSourceTopics.put(runtime.getKey(), new HashSet<String>(runtime.getValue()));
        }
    }

    public RuntimeAssignor createSandbox() {
        return new RuntimeAssignor(this);
    }

    public String getRuntimeAndMaybeAddRuntime(QueryId queryId, Collection<String> sourceTopics, KsqlConfig config) {
        if (this.idToRuntime.containsKey(queryId)) {
            return this.idToRuntime.get(queryId);
        }
        List possibleRuntimes = this.runtimesToSourceTopics.entrySet().stream().filter(t -> ((Collection)t.getValue()).stream().noneMatch(sourceTopics::contains)).map(Map.Entry::getKey).collect(Collectors.toList());
        String runtime = possibleRuntimes.isEmpty() ? this.makeNewRuntime(config) : (String)possibleRuntimes.get(Math.abs(queryId.hashCode() % possibleRuntimes.size()));
        this.runtimesToSourceTopics.get(runtime).addAll(sourceTopics);
        this.idToRuntime.put(queryId, runtime);
        this.log.info("Assigning query {} to runtime {}", (Object)queryId, (Object)runtime);
        return runtime;
    }

    public void dropQuery(PersistentQueryMetadata queryMetadata) {
        if (queryMetadata instanceof BinPackedPersistentQueryMetadataImpl) {
            if (this.idToRuntime.containsKey(queryMetadata.getQueryId())) {
                this.log.info("Unassigning query {} from runtime {}", (Object)queryMetadata.getQueryId(), (Object)this.idToRuntime.get(queryMetadata.getQueryId()));
            } else {
                this.log.warn("Dropping an unassigned query {}, this should only possible with Gen 1 queries", (Object)queryMetadata);
            }
            this.runtimesToSourceTopics.get(queryMetadata.getQueryApplicationId()).removeAll(queryMetadata.getSourceTopicNames());
            this.idToRuntime.remove(queryMetadata.getQueryId());
            if (this.runtimesToSourceTopics.get(queryMetadata.getQueryApplicationId()).isEmpty() && this.runtimesToSourceTopics.size() > this.numDefaultRuntimes) {
                this.runtimesToSourceTopics.remove(queryMetadata.getQueryApplicationId());
                this.log.info("Removing runtime {} form selection of possible runtimes", (Object)queryMetadata.getQueryApplicationId());
            }
        }
    }

    private String makeNewRuntime(KsqlConfig config) {
        String runtime = QueryApplicationId.buildSharedRuntimeId((KsqlConfig)config, (boolean)true, (int)this.runtimesToSourceTopics.size());
        this.runtimesToSourceTopics.put(runtime, new HashSet());
        return runtime;
    }

    public void rebuildAssignment(Collection<PersistentQueryMetadata> queries) {
        HashSet<QueryId> gen1Queries = new HashSet<QueryId>();
        for (PersistentQueryMetadata queryMetadata : queries) {
            if (queryMetadata instanceof BinPackedPersistentQueryMetadataImpl) {
                if (!this.runtimesToSourceTopics.containsKey(queryMetadata.getQueryApplicationId())) {
                    this.runtimesToSourceTopics.put(queryMetadata.getQueryApplicationId(), new HashSet());
                }
                this.runtimesToSourceTopics.get(queryMetadata.getQueryApplicationId()).addAll(queryMetadata.getSourceTopicNames());
                this.idToRuntime.put(queryMetadata.getQueryId(), queryMetadata.getQueryApplicationId());
                continue;
            }
            gen1Queries.add(queryMetadata.getQueryId());
        }
        if (!this.idToRuntime.isEmpty()) {
            this.log.info("The current assignment of queries to Gen 2 runtimes is: {}", (Object)this.idToRuntime.entrySet().stream().map(e -> e.getKey() + "->" + (String)e.getValue()).collect(Collectors.joining(", ")));
        } else if (gen1Queries.size() == queries.size()) {
            this.log.info("There are no queries assigned to Gen 2 runtimes yet.");
        } else {
            this.log.error("Gen 2 queries are not getting assigned correctly, this should not be possible");
        }
        if (!gen1Queries.isEmpty()) {
            this.log.info("Currently there are {} queries running on the Gen 1 runtime which are: {}", (Object)gen1Queries.size(), gen1Queries);
        }
    }

    public Map<String, Collection<String>> getRuntimesToSourceTopics() {
        return ImmutableMap.copyOf(this.runtimesToSourceTopics);
    }

    public Map<QueryId, String> getIdToRuntime() {
        return ImmutableMap.copyOf(this.idToRuntime);
    }
}

