/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine.generic;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.CodeGenRunner;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.NullLiteral;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.TraversalExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.VisitParentExpressionVisitor;
import io.confluent.ksql.execution.interpreter.InterpretedExpression;
import io.confluent.ksql.execution.interpreter.InterpretedExpressionFactory;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.RecordProcessingError;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.DefaultSqlValueCoercer;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlValueCoercer;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;
import java.util.function.Supplier;

public class GenericExpressionResolver {
    private static final LogicalSchema NO_COLUMNS = LogicalSchema.builder().build();
    private static final Supplier<String> IGNORED_MSG = () -> "";
    private static final ProcessingLogger THROWING_LOGGER = new ProcessingLogger(){

        public void error(ProcessingLogger.ErrorMessage errorMessage) {
            throw new KsqlException(((RecordProcessingError)errorMessage).getMessage());
        }

        public void close() {
        }
    };
    private final SqlType fieldType;
    private final ColumnName fieldName;
    private final SqlValueCoercer sqlValueCoercer = DefaultSqlValueCoercer.STRICT;
    private final FunctionRegistry functionRegistry;
    private final KsqlConfig config;
    private final String operation;
    private final boolean shouldUseInterpreter;

    public GenericExpressionResolver(SqlType fieldType, ColumnName fieldName, FunctionRegistry functionRegistry, KsqlConfig config, String operation, boolean shouldUseInterpreter) {
        this.fieldType = Objects.requireNonNull(fieldType, "fieldType");
        this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.config = Objects.requireNonNull(config, "config");
        this.operation = Objects.requireNonNull(operation, "operation");
        this.shouldUseInterpreter = shouldUseInterpreter;
    }

    public Object resolve(Expression expression) {
        return new Visitor().process(expression, null);
    }

    private class EnsureNoColReferences
    extends TraversalExpressionVisitor<Void> {
        private final Expression parent;

        EnsureNoColReferences(Expression parent) {
            this.parent = Objects.requireNonNull(parent, "parent");
        }

        public Void visitUnqualifiedColumnReference(UnqualifiedColumnReferenceExp node, Void context) {
            throw new KsqlException("Unsupported column reference in " + GenericExpressionResolver.this.operation + ": " + this.parent);
        }

        public Void visitQualifiedColumnReference(QualifiedColumnReferenceExp node, Void context) {
            throw new KsqlException("Unsupported column reference in " + GenericExpressionResolver.this.operation + ": " + this.parent);
        }
    }

    private class Visitor
    extends VisitParentExpressionVisitor<Object, Void> {
        private Visitor() {
        }

        protected Object visitExpression(Expression expression, Void context) {
            new EnsureNoColReferences(expression).process(expression, context);
            InterpretedExpression evaluator = GenericExpressionResolver.this.shouldUseInterpreter ? InterpretedExpressionFactory.create((Expression)expression, (LogicalSchema)NO_COLUMNS, (FunctionRegistry)GenericExpressionResolver.this.functionRegistry, (KsqlConfig)GenericExpressionResolver.this.config) : CodeGenRunner.compileExpression((Expression)expression, (String)GenericExpressionResolver.this.operation, (LogicalSchema)NO_COLUMNS, (KsqlConfig)GenericExpressionResolver.this.config, (FunctionRegistry)GenericExpressionResolver.this.functionRegistry);
            Object value = evaluator.evaluate(new GenericRow(), null, THROWING_LOGGER, IGNORED_MSG);
            return GenericExpressionResolver.this.sqlValueCoercer.coerce(value, GenericExpressionResolver.this.fieldType).orElseThrow(() -> {
                SqlBaseType valueSqlType = SchemaConverters.javaToSqlConverter().toSqlType(value.getClass());
                String errorMessage = String.format("Expected type %s for field %s but got %s(%s)%s", GenericExpressionResolver.this.fieldType, GenericExpressionResolver.this.fieldName, valueSqlType, value, this.parseTimeErrorMessage(GenericExpressionResolver.this.fieldType, valueSqlType));
                return new KsqlException(errorMessage);
            }).orElse(null);
        }

        private String parseTimeErrorMessage(SqlType fieldType, SqlBaseType valueType) {
            if (valueType == SqlBaseType.STRING) {
                if (fieldType == SqlTypes.TIMESTAMP) {
                    return ". Timestamp format must be yyyy-mm-ddThh:mm:ss[.S]";
                }
                if (fieldType == SqlTypes.TIME) {
                    return ". Time format must be hh:mm:ss[.S]";
                }
                if (fieldType == SqlTypes.DATE) {
                    return ". Date format must be yyyy-mm-dd";
                }
            }
            return "";
        }

        public Object visitNullLiteral(NullLiteral node, Void context) {
            return null;
        }
    }
}

