/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine.rewrite;

import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.engine.rewrite.DataSourceExtractor;
import io.confluent.ksql.engine.rewrite.ExpressionTreeRewriter;
import io.confluent.ksql.engine.rewrite.StatementRewriter;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.LambdaFunctionCall;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.VisitParentExpressionVisitor;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.InsertInto;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.schema.ksql.ColumnAliasGenerator;
import io.confluent.ksql.schema.ksql.ColumnNames;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.util.AmbiguousColumnException;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.UnknownSourceException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public final class AstSanitizer {
    private AstSanitizer() {
    }

    public static Statement sanitize(Statement node, MetaStore metaStore) {
        return AstSanitizer.sanitize(node, metaStore, true);
    }

    public static Statement sanitize(Statement node, MetaStore metaStore, Boolean lambdaEnabled) {
        DataSourceExtractor dataSourceExtractor = new DataSourceExtractor(metaStore);
        dataSourceExtractor.extractDataSources((AstNode)node);
        RewriterPlugin rewriterPlugin = new RewriterPlugin(metaStore, dataSourceExtractor);
        ExpressionRewriterPlugin expressionRewriterPlugin = new ExpressionRewriterPlugin(dataSourceExtractor, lambdaEnabled);
        BiFunction<Expression, SanitizerContext, Expression> expressionRewriter = (e, v) -> ExpressionTreeRewriter.rewriteWith((arg_0, arg_1) -> ((ExpressionRewriterPlugin)expressionRewriterPlugin).process(arg_0, arg_1), e, v);
        return (Statement)new StatementRewriter<SanitizerContext>(expressionRewriter, (arg_0, arg_1) -> ((RewriterPlugin)rewriterPlugin).process(arg_0, arg_1)).rewrite((AstNode)node, new SanitizerContext());
    }

    private static class SanitizerContext {
        final Set<String> lambdaArgs = new HashSet<String>();

        private SanitizerContext() {
        }

        private void addLambdaArgs(Set<String> newArguments) {
            int previousLambdaArgumentsLength = this.lambdaArgs.size();
            this.lambdaArgs.addAll(newArguments);
            if (new HashSet<String>(this.lambdaArgs).size() < previousLambdaArgumentsLength + newArguments.size()) {
                throw new KsqlException("Reusing lambda arguments in nested lambda is not allowed");
            }
        }

        private void removeLambdaArgs() {
            this.lambdaArgs.clear();
        }

        private Set<String> getLambdaArgs() {
            return ImmutableSet.copyOf(this.lambdaArgs);
        }
    }

    private static final class ExpressionRewriterPlugin
    extends VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<SanitizerContext>> {
        private final DataSourceExtractor dataSourceExtractor;
        private final Boolean lambdaEnabled;

        ExpressionRewriterPlugin(DataSourceExtractor dataSourceExtractor, Boolean lambdaEnabled) {
            super(Optional.empty());
            this.dataSourceExtractor = Objects.requireNonNull(dataSourceExtractor, "dataSourceExtractor");
            this.lambdaEnabled = lambdaEnabled;
        }

        public Optional<Expression> visitUnqualifiedColumnReference(UnqualifiedColumnReferenceExp expression, ExpressionTreeRewriter.Context<SanitizerContext> ctx) {
            ColumnName columnName = expression.getColumnName();
            List<SourceName> sourceNames = this.dataSourceExtractor.getSourcesFor(columnName);
            if (sourceNames.size() > 1) {
                throw new AmbiguousColumnException(expression, sourceNames);
            }
            if (sourceNames.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new QualifiedColumnReferenceExp(expression.getLocation(), sourceNames.get(0), columnName));
        }

        public Optional<Expression> visitLambdaExpression(LambdaFunctionCall expression, ExpressionTreeRewriter.Context<SanitizerContext> ctx) {
            if (!this.lambdaEnabled.booleanValue()) {
                throw new UnsupportedOperationException("Lambdas are not enabled at this time.");
            }
            this.dataSourceExtractor.getAllSources().forEach(aliasedDataSource -> {
                for (String argument : expression.getArguments()) {
                    if (!aliasedDataSource.getDataSource().getSchema().columns().stream().map(column -> column.name().text()).collect(Collectors.toList()).contains(argument)) continue;
                    throw new KsqlException(String.format("Lambda function argument can't be a column name: %s", argument));
                }
            });
            HashSet previousLambdaArgs = new HashSet(ctx.getContext().getLambdaArgs());
            ctx.getContext().addLambdaArgs(new HashSet(expression.getArguments()));
            ctx.process(expression.getBody());
            ctx.getContext().removeLambdaArgs();
            ctx.getContext().addLambdaArgs(previousLambdaArgs);
            return (Optional)this.visitExpression((Expression)expression, ctx);
        }
    }

    private static final class RewriterPlugin
    extends AstVisitor<Optional<AstNode>, StatementRewriter.Context<SanitizerContext>> {
        private final MetaStore metaStore;
        private final DataSourceExtractor dataSourceExtractor;
        private final ColumnAliasGenerator aliasGenerator;

        RewriterPlugin(MetaStore metaStore, DataSourceExtractor dataSourceExtractor) {
            super(Optional.empty());
            this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
            this.dataSourceExtractor = Objects.requireNonNull(dataSourceExtractor, "dataSourceExtractor");
            this.aliasGenerator = ColumnNames.columnAliasGenerator(dataSourceExtractor.getAllSources().stream().map(Analysis.AliasedDataSource::getDataSource).map(DataSource::getSchema));
        }

        protected Optional<AstNode> visitInsertInto(InsertInto node, StatementRewriter.Context<SanitizerContext> ctx) {
            DataSource target = this.metaStore.getSource(node.getTarget());
            if (target == null) {
                Optional<NodeLocation> targetLocation = node.getLocation().map(l -> new NodeLocation(l.getStartLineNumber(), l.getStartColumnNumber() + "INSERT INTO".length()));
                throw new UnknownSourceException(targetLocation, node.getTarget());
            }
            if (target.getDataSourceType() != DataSource.DataSourceType.KSTREAM) {
                throw new KsqlException("INSERT INTO can only be used to insert into a stream. " + target.getName().toString(FormatOptions.noEscape()) + " is a table.");
            }
            if (!target.getSchema().headers().isEmpty()) {
                throw new KsqlException("Cannot insert into " + target.getName().text() + " because it has header columns");
            }
            return Optional.empty();
        }

        protected Optional<AstNode> visitSingleColumn(SingleColumn singleColumn, StatementRewriter.Context<SanitizerContext> ctx) {
            ColumnName alias;
            if (singleColumn.getAlias().isPresent()) {
                return Optional.empty();
            }
            Expression expression = ctx.process(singleColumn.getExpression());
            if (expression instanceof ColumnReferenceExp) {
                Optional source = ((ColumnReferenceExp)expression).maybeQualifier();
                ColumnName name = ((ColumnReferenceExp)expression).getColumnName();
                alias = source.isPresent() && this.dataSourceExtractor.isClashingColumnName(name) ? ColumnNames.generatedJoinColumnAlias((SourceName)((SourceName)source.get()), (ColumnName)name) : name;
            } else {
                alias = this.aliasGenerator.uniqueAliasFor(expression);
            }
            return Optional.of(new SingleColumn(singleColumn.getLocation(), expression, Optional.of(alias)));
        }
    }
}

